/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ClientSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.BooleanValue celsius;
    private static final ForgeConfigSpec.IntValue tempOffset;
    private static final ForgeConfigSpec.DoubleValue tempSmoothing;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> bodyIconPos;
    private static final ForgeConfigSpec.BooleanValue bodyIconEnabled;
    private static final ForgeConfigSpec.BooleanValue moveBodyIconWhenAdvanced;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> bodyReadoutPos;
    private static final ForgeConfigSpec.BooleanValue bodyReadoutEnabled;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> worldGaugePos;
    private static final ForgeConfigSpec.BooleanValue worldGaugeEnabled;
    private static final ForgeConfigSpec.BooleanValue customHotbarLayout;
    private static final ForgeConfigSpec.BooleanValue iconBobbing;
    private static final ForgeConfigSpec.BooleanValue hearthDebug;
    private static final ForgeConfigSpec.BooleanValue showConfigButton;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> configButtonPos;
    private static final ForgeConfigSpec.BooleanValue distortionEffects;
    private static final ForgeConfigSpec.BooleanValue highContrast;
    private static final ForgeConfigSpec.BooleanValue enableCreativeWarning;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "coldsweat/client.toml");
    }

    public static ClientSettingsConfig getInstance() {
        return new ClientSettingsConfig();
    }

    public boolean isHighContrast() {
        return (Boolean)highContrast.get();
    }

    public void setHighContrast(boolean enabled) {
        highContrast.set((Object)enabled);
    }

    public boolean isCelsius() {
        return (Boolean)celsius.get();
    }

    public int getTempOffset() {
        return (Integer)tempOffset.get();
    }

    public int getBodyIconX() {
        return (Integer)((List)bodyIconPos.get()).get(0);
    }

    public int getBodyIconY() {
        return (Integer)((List)bodyIconPos.get()).get(1);
    }

    public int getBodyReadoutX() {
        return (Integer)((List)bodyReadoutPos.get()).get(0);
    }

    public int getBodyReadoutY() {
        return (Integer)((List)bodyReadoutPos.get()).get(1);
    }

    public int getWorldGaugeX() {
        return (Integer)((List)worldGaugePos.get()).get(0);
    }

    public int getWorldGaugeY() {
        return (Integer)((List)worldGaugePos.get()).get(1);
    }

    public double getTempSmoothing() {
        return (Double)tempSmoothing.get();
    }

    public boolean isCustomHotbarLayout() {
        return (Boolean)customHotbarLayout.get();
    }

    public boolean isIconBobbing() {
        return (Boolean)iconBobbing.get();
    }

    public boolean isHearthDebug() {
        return (Boolean)hearthDebug.get();
    }

    public boolean showCreativeWarning() {
        return (Boolean)enableCreativeWarning.get();
    }

    public boolean isBodyIconEnabled() {
        return (Boolean)bodyIconEnabled.get();
    }

    public boolean isBodyReadoutEnabled() {
        return (Boolean)bodyReadoutEnabled.get();
    }

    public boolean isWorldGaugeEnabled() {
        return (Boolean)worldGaugeEnabled.get();
    }

    public boolean moveBodyIconWhenAdvanced() {
        return (Boolean)moveBodyIconWhenAdvanced.get();
    }

    public void setCelsius(boolean enabled) {
        celsius.set((Object)enabled);
    }

    public void setTempOffset(int offset) {
        tempOffset.set((Object)offset);
    }

    public void setBodyIconX(int pos) {
        bodyIconPos.set(List.of(Integer.valueOf(pos), Integer.valueOf(this.getBodyIconY())));
    }

    public void setBodyIconY(int pos) {
        bodyIconPos.set(List.of(Integer.valueOf(this.getBodyIconX()), Integer.valueOf(pos)));
    }

    public void setBodyReadoutX(int pos) {
        bodyReadoutPos.set(List.of(Integer.valueOf(pos), Integer.valueOf(this.getBodyReadoutY())));
    }

    public void setBodyReadoutY(int pos) {
        bodyReadoutPos.set(List.of(Integer.valueOf(this.getBodyReadoutX()), Integer.valueOf(pos)));
    }

    public void setWorldGaugeX(int pos) {
        worldGaugePos.set(List.of(Integer.valueOf(pos), Integer.valueOf(this.getWorldGaugeY())));
    }

    public void setWorldGaugeY(int pos) {
        worldGaugePos.set(List.of(Integer.valueOf(this.getWorldGaugeX()), Integer.valueOf(pos)));
    }

    public void setCustomHotbar(boolean enabled) {
        customHotbarLayout.set((Object)enabled);
    }

    public void setIconBobbing(boolean enabled) {
        iconBobbing.set((Object)enabled);
    }

    public void setHearthDebug(boolean enabled) {
        hearthDebug.set((Object)enabled);
    }

    public boolean showConfigButton() {
        return (Boolean)showConfigButton.get();
    }

    public List<? extends Integer> getConfigButtonPos() {
        return (List)configButtonPos.get();
    }

    public void setConfigButtonPos(List<Integer> pos) {
        configButtonPos.set(pos);
    }

    public boolean areDistortionsEnabled() {
        return (Boolean)distortionEffects.get();
    }

    public void setDistortionsEnabled(boolean enabled) {
        distortionEffects.set((Object)enabled);
    }

    public void setCreativeWarningEnabled(boolean enabled) {
        enableCreativeWarning.set((Object)enabled);
    }

    public void setBodyIconEnabled(boolean enabled) {
        bodyIconEnabled.set((Object)enabled);
    }

    public void setBodyReadoutEnabled(boolean enabled) {
        bodyReadoutEnabled.set((Object)enabled);
    }

    public void setWorldGaugeEnabled(boolean enabled) {
        worldGaugeEnabled.set((Object)enabled);
    }

    public void setTempSmoothing(double smoothing) {
        tempSmoothing.set((Object)smoothing);
    }

    public synchronized void writeAndSave() {
        this.setCelsius(ConfigSettings.CELSIUS.get());
        this.setTempOffset(ConfigSettings.TEMP_OFFSET.get());
        this.setTempSmoothing(ConfigSettings.TEMP_SMOOTHING.get());
        this.setBodyIconX(ConfigSettings.BODY_ICON_POS.get().x());
        this.setBodyIconY(ConfigSettings.BODY_ICON_POS.get().y());
        this.setBodyReadoutX(ConfigSettings.BODY_READOUT_POS.get().x());
        this.setBodyReadoutY(ConfigSettings.BODY_READOUT_POS.get().y());
        this.setWorldGaugeX(ConfigSettings.WORLD_GAUGE_POS.get().x());
        this.setWorldGaugeY(ConfigSettings.WORLD_GAUGE_POS.get().y());
        this.setCustomHotbar(ConfigSettings.CUSTOM_HOTBAR_LAYOUT.get());
        this.setIconBobbing(ConfigSettings.ICON_BOBBING.get());
        this.setHearthDebug(ConfigSettings.HEARTH_DEBUG.get());
        this.setCreativeWarningEnabled(ConfigSettings.SHOW_CREATIVE_WARNING.get());
        this.setBodyIconEnabled(ConfigSettings.BODY_ICON_ENABLED.get());
        this.setBodyReadoutEnabled(ConfigSettings.BODY_READOUT_ENABLED.get());
        this.setWorldGaugeEnabled(ConfigSettings.WORLD_GAUGE_ENABLED.get());
        this.setDistortionsEnabled(ConfigSettings.DISTORTION_EFFECTS.get());
        this.setHighContrast(ConfigSettings.HIGH_CONTRAST.get());
        this.setConfigButtonPos(List.of(Integer.valueOf(ConfigSettings.CONFIG_BUTTON_POS.get().x()), Integer.valueOf(ConfigSettings.CONFIG_BUTTON_POS.get().y())));
        this.save();
    }

    public synchronized void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("Visual Preferences");
        celsius = BUILDER.comment("Sets all temperatures to be displayed in Celsius").define("Celsius", false);
        tempOffset = BUILDER.comment("Visually offsets the world temperature to better match the user's definition of \"hot\" and \"cold\"").defineInRange("Temperature Offset", 0, -2147483647, Integer.MAX_VALUE);
        tempSmoothing = BUILDER.comment(new String[]{"The amount of smoothing applied to gauges in the UI", "A value of 1 has no smoothing"}).defineInRange("Temperature Smoothing", 10.0, 1.0, 2.147483647E9);
        BUILDER.pop();
        BUILDER.push("UI Options");
        customHotbarLayout = BUILDER.define("Custom hotbar layout", true);
        iconBobbing = BUILDER.comment("Controls whether UI elements will shake when in critical conditions").define("Icon Bobbing", true);
        bodyIconPos = BUILDER.comment("The position of the body temperature icon relative to default").defineList("Body Temperature Icon Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        bodyIconEnabled = BUILDER.comment("Enables the body temperature icon above the hotbar").define("Show Body Temperature Icon", true);
        moveBodyIconWhenAdvanced = BUILDER.comment("Moves the body temperature icon to make way for the advanced readout when a thermometer is equipped").define("Move Body Icon For Advanced Info", true);
        bodyReadoutPos = BUILDER.comment("The position of the body temperature readout relative to default").defineList("Body Temperature Readout Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        bodyReadoutEnabled = BUILDER.comment("Enables the body temperature readout above the hotbar").define("Show Body Temperature Readout", true);
        worldGaugePos = BUILDER.comment("The position of the world temperature gauge relative to default").defineList("World Temperature UI Offset", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        worldGaugeEnabled = BUILDER.comment("Enables the world temperature gauge next to the hotbar").define("Show World Temperature Gauge", true);
        BUILDER.pop();
        BUILDER.push("Accessibility");
        distortionEffects = BUILDER.comment("Enables visual distortion effects when the player is too hot or cold").define("Distortion Effects", true);
        highContrast = BUILDER.comment("Enables high contrast mode for UI elements").define("High Contrast", false);
        BUILDER.pop();
        BUILDER.push("Misc");
        showConfigButton = BUILDER.comment("Show the config menu button in the Options menu").define("Enable In-Game Config", true);
        configButtonPos = BUILDER.comment("The position (offset) of the config button on the screen").defineList("Config Button Position", List.of(Integer.valueOf(0), Integer.valueOf(0)), it -> it instanceof Integer);
        enableCreativeWarning = BUILDER.comment("Warns the player about a bug that clears armor insulation when in creative mode").define("Enable Creative Mode Warning", true);
        hearthDebug = BUILDER.comment("Displays areas that the Hearth is affecting when the F3 debug menu is open").define("Hearth Debug", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

