/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class FilledWaterskinItem
extends Item {
    public static final double EFFECT_RATE = 0.4;
    public static final String NBT_TEMPERATURE = "Temperature";

    public FilledWaterskinItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(1).m_41495_((Item)ItemInit.WATERSKIN.get()));
        DispenserBlock.m_52672_((ItemLike)this, (source, stack) -> {
            final BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, pos);
            double itemTemp = stack.m_41784_().m_128459_(NBT_TEMPERATURE);
            if (chunk == null) {
                return stack;
            }
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12590_, SoundSource.PLAYERS, 1.0f, (float)(Math.random() / 5.0 + 0.9), false);
            Random rand = new Random();
            for (int i = 0; i < 6; ++i) {
                TaskScheduler.scheduleServer(() -> {
                    ParticleBatchMessage particles = new ParticleBatchMessage();
                    for (int p = 0; p < rand.nextInt(5) + 5; ++p) {
                        particles.addParticle((ParticleOptions)ParticleTypes.f_123804_, new ParticleBatchMessage.ParticlePlacement((double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + rand.nextDouble(), (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.0, 0.0));
                    }
                    ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)chunk), (Object)particles);
                }, i);
            }
            new Object((Level)level, itemTemp, chunk){
                double acceleration = 0.0;
                int tick = 0;
                AABB aabb = new AABB(pos).m_82400_(0.5);
                List<Player> affectedPlayers = new ArrayList<Player>();
                final /* synthetic */ Level val$level;
                final /* synthetic */ double val$itemTemp;
                final /* synthetic */ ChunkAccess val$chunk;
                {
                    this.val$level = level;
                    this.val$itemTemp = d;
                    this.val$chunk = chunkAccess;
                }

                void start() {
                    MinecraftForge.EVENT_BUS.register((Object)this);
                }

                @SubscribeEvent
                public void onTick(TickEvent.LevelTickEvent event) {
                    if (event.level.f_46443_ == this.val$level.f_46443_ && event.phase == TickEvent.Phase.START) {
                        double waterTemp = CSMath.blend(this.val$itemTemp, this.val$itemTemp / 5.0, (double)this.tick, 20.0, 100.0);
                        this.aabb = this.aabb.m_82386_(0.0, -this.acceleration, 0.0);
                        BlockPos pos2 = new BlockPos(this.aabb.f_82288_, this.aabb.f_82289_, this.aabb.f_82290_);
                        if (WorldHelper.isSpreadBlocked((LevelAccessor)this.val$level, this.val$chunk.m_8055_(pos2), pos2, Direction.DOWN, Direction.DOWN)) {
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                            return;
                        }
                        this.val$level.m_45976_(Player.class, this.aabb).forEach(player -> {
                            if (!this.affectedPlayers.contains(player)) {
                                Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(waterTemp).expires(0), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
                                this.affectedPlayers.add((Player)player);
                            }
                        });
                        this.acceleration += 0.0052;
                        ++this.tick;
                        if (this.tick > 100) {
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                        }
                    }
                }
            }.start();
            return FilledWaterskinItem.getEmpty(stack);
        });
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(itemstack, world, entity, slot, isSelected);
        if (entity.f_19797_ % 5 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            double itemTemp = itemstack.m_41784_().m_128459_(NBT_TEMPERATURE);
            if (itemTemp != 0.0 && slot <= 8 || player.m_21206_().equals(itemstack)) {
                double temp = 0.02 * ConfigSettings.TEMP_RATE.get();
                double newTemp = CSMath.shrink(itemTemp, temp * 5.0);
                itemstack.m_41784_().m_128347_(NBT_TEMPERATURE, newTemp);
                Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(temp * (double)CSMath.sign(itemTemp)).expires(5), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
            }
        }
    }

    public static boolean performPourAction(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        block6: {
            block5: {
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (stack.m_150930_(ModItems.FILLED_WATERSKIN)) break block6;
            }
            return false;
        }
        Level level = player.f_19853_;
        double amount = stack.m_41784_().m_128459_(NBT_TEMPERATURE) * ((double)ConfigSettings.WATERSKIN_STRENGTH.get().intValue() / 50.0);
        Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(amount).expires(0), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
        if (!player.f_19853_.f_46443_) {
            WorldHelper.playEntitySound(ModSounds.WATERSKIN_POUR, (Entity)player, player.m_5720_(), 2.0f, (float)(Math.random() / 5.0 + 0.9));
        }
        FilledWaterskinItem.consumeWaterskin(stack, player, hand);
        player.m_6674_(hand);
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleClient(() -> {
                for (int p = 0; p < 10; ++p) {
                    AABB playerBB = player.m_6972_(player.m_20089_()).m_20393_(player.m_20182_()).m_82400_(0.2);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123804_, Mth.m_14139_((double)rand.nextFloat(), (double)playerBB.f_82288_, (double)playerBB.f_82291_), playerBB.f_82292_, Mth.m_14139_((double)rand.nextFloat(), (double)playerBB.f_82290_, (double)playerBB.f_82293_), 0.3, 0.3, 0.3);
                }
            }, i);
        }
        player.m_20095_();
        player.m_36335_().m_41524_(ModItems.FILLED_WATERSKIN, 10);
        player.m_36335_().m_41524_(ModItems.WATERSKIN, 10);
        return true;
    }

    public static void consumeWaterskin(ItemStack stack, Player player, InteractionHand usedHand) {
        ItemStack emptyStack = FilledWaterskinItem.getEmpty(stack);
        emptyStack.m_41784_().m_128473_("Purity");
        if (player.m_150109_().m_36063_(emptyStack)) {
            player.m_36356_(emptyStack);
            player.m_21008_(usedHand, ItemStack.f_41583_);
        } else {
            player.m_21008_(usedHand, emptyStack);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        if (FilledWaterskinItem.performPourAction(player.m_21120_(hand), (LivingEntity)player, hand)) {
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152476_)) {
            int waterLevel;
            boolean hasWater = state.m_60713_(Blocks.f_152476_);
            int n = waterLevel = hasWater ? (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) : 0;
            if (waterLevel >= 3) {
                return InteractionResult.PASS;
            }
            state = hasWater ? (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel + 1)) : (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, state, 3);
            if (!level.f_46443_) {
                level.m_5594_(null, pos, ModSounds.WATERSKIN_FILL, SoundSource.BLOCKS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
                WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            }
            if (player != null) {
                FilledWaterskinItem.consumeWaterskin(context.m_43722_(), player, context.m_43724_());
                player.m_36335_().m_41524_(ModItems.WATERSKIN, 10);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        double amount = stack.m_41784_().m_128459_(NBT_TEMPERATURE) * ((double)ConfigSettings.WATERSKIN_STRENGTH.get().intValue() / 50.0);
        Temperature.addModifier(entity, new WaterskinTempModifier(amount / 100.0).expires(100), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
        return entity instanceof Player && (player = (Player)entity).m_7500_() ? stack : this.getCraftingRemainingItem(stack);
    }

    public static ItemStack getEmpty(ItemStack stack) {
        if (stack.m_41720_() instanceof FilledWaterskinItem) {
            ItemStack emptyWaterskin = new ItemStack((ItemLike)ModItems.WATERSKIN);
            emptyWaterskin.m_41751_(stack.m_41783_());
            emptyWaterskin.m_41749_(NBT_TEMPERATURE);
            return emptyWaterskin;
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        double temp = CSMath.round(stack.m_41784_().m_128459_(NBT_TEMPERATURE), 2);
        if (Screen.m_96638_()) {
            String perSecond = Component.m_237115_((String)"tooltip.cold_sweat.per_second").getString();
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.cold_sweat.hotbar").m_130940_(ChatFormatting.GRAY));
            MutableComponent tempEffectText = (temp > 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.round(0.4 * ConfigSettings.TEMP_RATE.get(), 2)}).m_130948_(TooltipHandler.HOT) : (temp == 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+0"}) : Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{CSMath.round(0.4 * ConfigSettings.TEMP_RATE.get(), 2)}).m_130948_(TooltipHandler.COLD))).m_130946_(perSecond);
            tooltip.add((Component)tempEffectText);
            MutableComponent tempText = temp > 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}).m_130948_(TooltipHandler.HOT) : (temp == 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}) : Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{CSMath.formatDoubleOrInt(temp)}).m_130948_(TooltipHandler.COLD));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.cold_sweat.consumed").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)tempText);
        } else {
            tooltip.add(TooltipHandler.EXPAND_TOOLTIP);
        }
        boolean celsius = ConfigSettings.CELSIUS.get();
        Style color = temp == 0.0 ? Style.f_131099_ : (temp < 0.0 ? TooltipHandler.COLD : TooltipHandler.HOT);
        String tempUnits = celsius ? "C" : "F";
        temp = temp / 2.0 + 95.0;
        if (celsius) {
            temp = Temperature.convert(temp, Temperature.Units.F, Temperature.Units.C, true);
        }
        tooltip.add(1, (Component)Component.m_237115_((String)"item.cold_sweat.waterskin.filled").m_130940_(ChatFormatting.GRAY).m_130946_(" (").m_7220_((Component)Component.m_237113_((String)((int)(temp += (double)ConfigSettings.TEMP_OFFSET.get().intValue() / 2.0) + " \u00b0" + tempUnits)).m_130948_(color)).m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GRAY)));
        super.m_7373_(stack, level, tooltip, advanced);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack empty = FilledWaterskinItem.getEmpty(itemStack);
        empty.m_41784_().m_128473_("Purity");
        return empty;
    }

    public String m_5524_() {
        return Component.m_237115_((String)"item.cold_sweat.waterskin").getString();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> itemList) {
        if (this.m_220152_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack = CompatManager.setWaterPurity(stack, 3);
            itemList.add((Object)stack);
        }
    }
}

