/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.event.TempEffectsCommon;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PreventPlayerSleep {
    @SubscribeEvent
    public static void onTrySleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        if (event.getResultStatus() != null || !ConfigSettings.CHECK_SLEEP_CONDITIONS.get().booleanValue() || ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().contains(player.f_19853_.m_8055_(event.getPos()).m_60734_())) {
            return;
        }
        double bodyTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
        double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
        double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
        if (!CSMath.betweenExclusive(bodyTemp, -100.0, 100.0)) {
            if (TempEffectsCommon.getTempResistance(event.getEntity(), bodyTemp < 100.0) >= 4) {
                return;
            }
            player.m_5661_((Component)Component.m_237115_((String)("cold_sweat.message.sleep.body." + (bodyTemp > 99.0 ? "hot" : "cold"))), true);
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        } else if (!CSMath.betweenExclusive(worldTemp, minTemp, maxTemp)) {
            if (TempEffectsCommon.getTempResistance(event.getEntity(), minTemp > worldTemp) >= 4) {
                return;
            }
            player.m_5661_((Component)Component.m_237115_((String)("cold_sweat.message.sleep.world." + (worldTemp > maxTemp ? "hot" : "cold"))), true);
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }
}

