/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.MenuInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncContainerSlotMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class SewingContainer
extends AbstractContainerMenu {
    BlockPos pos;
    Inventory playerInventory;
    SewingInventory sewingInventory;
    protected boolean quickMoved = false;

    public SewingContainer(int windowId, Inventory playerInv) {
        super((MenuType)MenuInit.SEWING_CONTAINER_TYPE.get(), windowId);
        this.pos = playerInv.f_35978_.m_20183_();
        this.playerInventory = playerInv;
        this.sewingInventory = new SewingInventory(this);
        this.m_38897_(new Slot(this.sewingInventory, 0, 43, 26){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof Wearable && !ConfigSettings.INSULATION_BLACKLIST.get().contains(stack.m_41720_()) && ((Insulation)CSMath.getIfNotNull(ConfigSettings.INSULATION_ITEMS.get().get(stack.m_41720_()), ins -> ins.insulation(), new StaticInsulation(0.0, 0.0))).isEmpty();
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                SewingContainer.this.takeInput();
            }

            public void m_6654_() {
                super.m_6654_();
                TaskScheduler.schedule(SewingContainer.this::testForRecipe, 0);
            }
        });
        this.m_38897_(new Slot(this.sewingInventory, 1, 43, 53){

            public boolean m_5857_(ItemStack stack) {
                return !((Insulation)CSMath.getIfNotNull(ConfigSettings.INSULATION_ITEMS.get().get(stack.m_41720_()), ins -> ins.insulation(), new StaticInsulation(0.0, 0.0))).isEmpty() || stack.m_41720_() instanceof ShearsItem;
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                SewingContainer.this.takeInput();
            }

            public void m_6654_() {
                super.m_6654_();
                TaskScheduler.schedule(SewingContainer.this::testForRecipe, 0);
            }
        });
        this.m_38897_(new Slot(this.sewingInventory, 2, 121, 39){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                SewingContainer.this.takeOutput(stack);
                if (!SewingContainer.this.playerInventory.f_35978_.f_19853_.f_46443_) {
                    TaskScheduler.scheduleServer(() -> SewingContainer.this.testForRecipe(), 0);
                }
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + 9 * row + 9, 8 + col * 18, 166 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public SewingContainer(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory);
        try {
            this.pos = BlockPos.m_122022_((long)friendlyByteBuf.readLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setItem(int index, ItemStack stack) {
        this.sewingInventory.m_6836_(index, stack);
        this.m_150404_(index, stack);
    }

    public void syncSlot(int index) {
        Player player = this.playerInventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TaskScheduler.scheduleServer(() -> ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncContainerSlotMessage(index, this.getItem(index), this)), 0);
        }
    }

    public void growItem(int index, int amount) {
        ItemStack stack = this.sewingInventory.m_8020_(index);
        stack.m_41769_(amount);
        this.sewingInventory.m_6836_(index, stack);
        this.m_150404_(index, stack);
    }

    public ItemStack getItem(int index) {
        return this.sewingInventory.m_8020_(index);
    }

    private void takeInput() {
        this.sewingInventory.m_6836_(2, ItemStack.f_41583_);
    }

    private void takeOutput(ItemStack stack) {
        Player player = this.playerInventory.f_35978_;
        ItemStack input1 = this.getItem(0);
        ItemStack input2 = this.getItem(1);
        ItemInsulationManager.getInsulationCap(input1).ifPresent(cap -> {
            if (input2.m_41720_() instanceof ShearsItem) {
                if (!cap.getInsulation().isEmpty()) {
                    if (!player.m_7500_()) {
                        input2.m_220157_(1, player.m_217043_(), null);
                    }
                    cap.removeInsulationItem(cap.getInsulationItem(cap.getInsulation().size() - 1));
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 0.8f, 1.0f);
                    input1.m_41784_().m_128391_((CompoundTag)cap.serializeNBT());
                }
            } else {
                if (!this.quickMoved) {
                    this.growItem(0, -1);
                    this.growItem(1, -1);
                }
                this.quickMoved = false;
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12100_, SoundSource.BLOCKS, 0.5f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModAdvancementTriggers.ARMOR_INSULATED.trigger(serverPlayer, input1, input2);
                }
            }
        });
        SoundEvent equipSound = stack.m_41720_().m_142602_();
        if (equipSound != null) {
            player.f_19853_.m_5594_(null, player.m_20183_(), equipSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void testForRecipe() {
        ItemStack wearableItem = this.getItem(0);
        ItemStack insulatorItem = this.getItem(1);
        if (wearableItem.m_41720_() instanceof Wearable) {
            ItemStack processed;
            if (insulatorItem.m_41720_() instanceof ShearsItem) {
                ItemInsulationManager.getInsulationCap(wearableItem).ifPresent(cap -> {
                    if (!cap.getInsulation().isEmpty()) {
                        this.setItem(2, cap.getInsulationItem(cap.getInsulation().size() - 1).m_41777_());
                    }
                });
            } else if (ConfigSettings.INSULATION_ITEMS.get().get(insulatorItem.m_41720_()) != null && (!(insulatorItem.m_41720_() instanceof Wearable) || LivingEntity.m_147233_((ItemStack)wearableItem) == LivingEntity.m_147233_((ItemStack)insulatorItem)) && this.insulateArmorItem(processed = wearableItem.m_41777_(), insulatorItem)) {
                this.setItem(2, processed);
                this.m_150429_();
            }
        }
        this.m_38946_();
    }

    private boolean insulateArmorItem(ItemStack armorItem, ItemStack insulatorItem) {
        IInsulatableCap insulCap = (IInsulatableCap)ItemInsulationManager.getInsulationCap(armorItem).orElseThrow(() -> new IllegalStateException("Item does not have insulation capability"));
        ItemStack insulator = insulatorItem.m_41777_();
        insulator.m_41764_(1);
        if (!insulCap.canAddInsulationItem(armorItem, insulator)) {
            return false;
        }
        insulCap.addInsulationItem(insulator);
        Map armorEnch = EnchantmentHelper.m_44831_((ItemStack)armorItem);
        insulator.m_41785_().removeIf(nbt -> {
            CompoundTag enchantTag = (CompoundTag)nbt;
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantTag.m_128461_("id")));
            if (ench == null) {
                return false;
            }
            if (ench.m_6081_(armorItem) && armorEnch.keySet().stream().allMatch(ench2 -> ench2.m_44695_(ench))) {
                armorItem.m_41663_(ench, enchantTag.m_128451_("lvl"));
                return true;
            }
            return false;
        });
        Player player = this.playerInventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TaskScheduler.scheduleServer(() -> ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncContainerSlotMessage(2, armorItem, this)), 1);
        }
        return true;
    }

    public SewingContainer(int windowId, Player playerInv, BlockPos pos) {
        this(windowId, playerInv.m_150109_());
        this.pos = pos;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < this.sewingInventory.m_6643_(); ++i) {
                ItemStack itemStack = this.m_38853_(i).m_7993_();
                if (itemStack.m_41619_() || i == 2) continue;
                if (player.m_6084_() && !serverPlayer.m_9232_()) {
                    player.m_150109_().m_150079_(itemStack);
                    continue;
                }
                player.m_36176_(itemStack, true);
            }
        }
    }

    public boolean m_6875_(Player playerIn) {
        if (this.pos != null) {
            return playerIn.m_20238_(Vec3.m_82512_((Vec3i)this.pos)) <= 64.0;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) return newStack;
        ItemStack slotItem = slot.m_7993_();
        newStack = slotItem.m_41777_();
        if (CSMath.betweenInclusive(index, 0.0, 2.0)) {
            if (index == 2 && !(this.getItem(1).m_41720_() instanceof ShearsItem)) {
                this.quickMoved = true;
                do {
                    this.growItem(0, -1);
                    this.growItem(1, -1);
                } while (this.insulateArmorItem(slotItem, this.getItem(1)));
            }
            if (!this.m_38903_(slotItem, 3, 39, true)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (((Slot)this.f_38839_.get(1)).m_5857_(slotItem)) {
                if (!this.m_38903_(slotItem, 1, 2, false)) return ItemStack.f_41583_;
                slot.m_40234_(slotItem, newStack);
                return ItemStack.f_41583_;
            } else if (((Slot)this.f_38839_.get(0)).m_5857_(slotItem)) {
                if (this.m_38903_(slotItem, 0, 1, false)) return ItemStack.f_41583_;
                slot.m_40234_(slotItem, newStack);
                return ItemStack.f_41583_;
            } else if (CSMath.betweenInclusive(index, this.f_38839_.size() - 9, this.f_38839_.size())) {
                if (this.m_38903_(slotItem, 3, 29, false)) return ItemStack.f_41583_;
                slot.m_40234_(slotItem, newStack);
                return ItemStack.f_41583_;
            } else {
                if (!CSMath.betweenInclusive(index, 3.0, this.f_38839_.size() - 9)) return ItemStack.f_41583_;
                if (this.m_38903_(slotItem, this.f_38839_.size() - 9, this.f_38839_.size(), false)) return ItemStack.f_41583_;
                slot.m_40234_(slotItem, newStack);
            }
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, newStack);
        if (slotItem.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
            return newStack;
        } else {
            slot.m_6654_();
        }
        return newStack;
    }

    public static class SewingInventory
    implements Container {
        private final NonNullList<ItemStack> stackList = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        private final AbstractContainerMenu menu;

        public SewingInventory(AbstractContainerMenu menu) {
            this.menu = menu;
        }

        public int m_6643_() {
            return 3;
        }

        public boolean m_7983_() {
            return !this.stackList.stream().anyMatch(stack -> !stack.m_41619_());
        }

        @Nonnull
        public ItemStack m_8020_(int index) {
            return (ItemStack)this.stackList.get(index);
        }

        @Nonnull
        public ItemStack m_7407_(int index, int count) {
            ItemStack itemstack = ContainerHelper.m_18969_(this.stackList, (int)index, (int)count);
            if (!itemstack.m_41619_()) {
                this.menu.m_6199_((Container)this);
            }
            return itemstack;
        }

        @Nonnull
        public ItemStack m_8016_(int index) {
            return ContainerHelper.m_18966_(this.stackList, (int)index);
        }

        public void m_6836_(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.menu.m_6199_((Container)this);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            this.stackList.clear();
        }
    }
}

