/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.common.blockentity.BoilerBlockEntity;
import com.momosoftworks.coldsweat.core.init.MenuInit;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BoilerContainer
extends AbstractContainerMenu {
    public final BoilerBlockEntity te;

    public BoilerContainer(int windowId, Inventory playerInv, final BoilerBlockEntity te) {
        super((MenuType)MenuInit.BOILER_CONTAINER_TYPE.get(), windowId);
        this.te = te;
        this.m_38897_(new Slot((Container)te, 0, 80, 62){

            public boolean m_5857_(ItemStack stack) {
                return te.getItemFuel(stack) > 0;
            }
        });
        for (int in = 1; in < 10; ++in) {
            this.m_38897_(new Slot((Container)te, in, -10 + in * 18, 35){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_204117_(ModItemTags.BOILER_VALID) || CompatManager.isThirstLoaded() && stack.m_204117_(ModItemTags.BOILER_PURIFIABLE);
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + 9 * row + 9, 8 + col * 18, 163 - (4 - row) * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 149));
        }
    }

    public BoilerContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, BoilerContainer.getTileEntity(playerInv, data));
    }

    public int getFuel() {
        return this.te.getFuel();
    }

    private static BoilerBlockEntity getTileEntity(Inventory playerInv, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "PacketBuffer inventory cannot be null");
        BlockEntity te = playerInv.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (te instanceof BoilerBlockEntity) {
            return (BoilerBlockEntity)te;
        }
        throw new IllegalStateException("Tile Entity is not correct");
    }

    public boolean m_6875_(Player playerIn) {
        return playerIn.m_20275_((double)this.te.m_58899_().m_123341_(), (double)this.te.m_58899_().m_123342_(), (double)this.te.m_58899_().m_123343_()) <= 64.0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (CSMath.betweenInclusive(index, 0.0, 9.0)) {
                if (!this.m_38903_(itemstack1, 10, 46, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (itemstack.m_204117_(ModItemTags.BOILER_VALID)) {
                    if (!this.m_38903_(itemstack1, 1, 10, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (this.te.getItemFuel(itemstack) > 0) {
                    if (!this.m_38903_(itemstack1, 0, 1, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (CSMath.betweenInclusive(index, this.f_38839_.size() - 9, this.f_38839_.size())) {
                    if (!this.m_38903_(itemstack1, 10, 36, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (CSMath.betweenInclusive(index, 10.0, this.f_38839_.size() - 9) && !this.m_38903_(itemstack1, this.f_38839_.size() - 9, this.f_38839_.size(), false)) {
                    slot.m_40234_(itemstack1, itemstack);
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            slot.m_40234_(itemstack1, itemstack);
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

