/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.temperature;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModDamageSources;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class AbstractTempCap
implements ITemperatureCap {
    boolean changed = true;
    int syncTimer = 0;
    Temperature.Units preferredUnits = Temperature.Units.F;
    private final Set<Attribute> persistentAttributes = new HashSet<Attribute>();
    private final EnumMap<Temperature.Trait, Double> traits = Arrays.stream(EntityTempManager.VALID_TEMPERATURE_TRAITS).collect(() -> new EnumMap(Temperature.Trait.class), (map, type) -> map.put(type, 0.0), EnumMap::putAll);
    private final EnumMap<Temperature.Trait, List<TempModifier>> modifiers = Arrays.stream(EntityTempManager.VALID_MODIFIER_TRAITS).collect(() -> new EnumMap(Temperature.Trait.class), (map, type) -> map.put(type, new ArrayList()), EnumMap::putAll);
    public boolean showBodyTemp;
    public boolean showWorldTemp;

    @Override
    public double getTrait(Temperature.Trait trait) {
        if (trait == Temperature.Trait.BODY) {
            return this.getTrait(Temperature.Trait.CORE) + this.getTrait(Temperature.Trait.BASE);
        }
        if (!this.traits.containsKey((Object)trait)) {
            throw new IllegalArgumentException("Invalid temperature trait: " + trait);
        }
        return this.traits.get((Object)trait);
    }

    @Override
    public EnumMap<Temperature.Trait, Double> getTraits() {
        return new EnumMap<Temperature.Trait, Double>(this.traits);
    }

    @Override
    public void setTrait(Temperature.Trait trait, double value) {
        this.changed |= (switch (trait) {
            case Temperature.Trait.CORE -> {
                if ((int)value != (int)this.getTrait(Temperature.Trait.CORE)) {
                    yield true;
                }
                yield false;
            }
            case Temperature.Trait.BASE -> {
                if ((int)value != (int)this.getTrait(Temperature.Trait.BASE)) {
                    yield true;
                }
                yield false;
            }
            case Temperature.Trait.WORLD -> {
                if (Math.abs(value - this.getTrait(Temperature.Trait.WORLD)) >= 0.02) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        });
        if (this.traits.replace(trait, value) == null) {
            throw new IllegalArgumentException("Invalid temperature trait: " + trait);
        }
    }

    public void setTrait(Temperature.Trait trait, double value, LivingEntity entity) {
        double oldTemp = this.getTrait(trait);
        this.setTrait(trait, value);
        if (oldTemp != value && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModAdvancementTriggers.TEMPERATURE_CHANGED.trigger(player, this.getTraits());
        }
    }

    @Override
    public void addModifier(TempModifier modifier, Temperature.Trait trait) {
        this.modifiers.get((Object)trait).add(modifier);
    }

    @Override
    public List<TempModifier> getModifiers(Temperature.Trait trait) {
        return this.modifiers.computeIfAbsent(trait, t -> {
            throw new IllegalArgumentException("Invalid modifier trait: " + t);
        });
    }

    @Override
    public boolean hasModifier(Temperature.Trait trait, Class<? extends TempModifier> mod) {
        return this.getModifiers(trait).stream().anyMatch(mod::isInstance);
    }

    @Override
    public void markPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.add(attribute);
    }

    @Override
    public void clearPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.remove(attribute);
    }

    @Override
    public Collection<Attribute> getPersistentAttributes() {
        return this.persistentAttributes;
    }

    @Override
    public void clearModifiers(Temperature.Trait trait) {
        this.getModifiers(trait).clear();
    }

    @Override
    public Temperature.Units getPreferredUnits() {
        return this.preferredUnits;
    }

    @Override
    public void setPreferredUnits(Temperature.Units units) {
        this.preferredUnits = units;
    }

    public boolean shouldShowBodyTemp() {
        return this.showBodyTemp;
    }

    public boolean showAdvancedWorldTemp() {
        return this.showWorldTemp;
    }

    @Override
    public void tickDummy(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Temperature.apply(0.0, (LivingEntity)player, Temperature.Trait.WORLD, this.getModifiers(Temperature.Trait.WORLD));
        Temperature.apply(this.getTrait(Temperature.Trait.CORE), (LivingEntity)player, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        Temperature.apply(0.0, (LivingEntity)player, Temperature.Trait.BASE, this.getModifiers(Temperature.Trait.BASE));
    }

    @Override
    public void tick(LivingEntity entity) {
        double changeBy;
        Player player;
        boolean isFullyHeatDampened;
        double newWorldTemp = this.modifyFromAttribute(entity, Temperature.Trait.WORLD, 0.0);
        double newBaseTemp = this.modifyFromAttribute(entity, Temperature.Trait.BASE, 0.0);
        double newCoreTemp = Temperature.apply(this.getTrait(Temperature.Trait.CORE), entity, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        double maxTemp = this.modifyFromAttribute(entity, Temperature.Trait.BURNING_POINT, ConfigSettings.MAX_TEMP.get());
        double minTemp = this.modifyFromAttribute(entity, Temperature.Trait.FREEZING_POINT, ConfigSettings.MIN_TEMP.get());
        double coldDampening = this.modifyFromAttribute(entity, Temperature.Trait.COLD_DAMPENING, 0.0);
        double heatDampening = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_DAMPENING, 0.0);
        double coldResistance = this.modifyFromAttribute(entity, Temperature.Trait.COLD_RESISTANCE, 0.0);
        double heatResistance = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_RESISTANCE, 0.0);
        int worldTempSign = CSMath.signForRange(newWorldTemp, minTemp, maxTemp);
        boolean isFullyColdDampened = worldTempSign < 0 && coldDampening >= 1.0;
        boolean bl = isFullyHeatDampened = worldTempSign > 0 && heatDampening >= 1.0;
        if (!(worldTempSign == 0 || entity instanceof Player && (player = (Player)entity).m_7500_() || entity.m_5833_())) {
            double difference = Math.abs(newWorldTemp - CSMath.clamp(newWorldTemp, minTemp, maxTemp));
            changeBy = Math.max(difference / 7.0 * (double)ConfigSettings.TEMP_RATE.get().floatValue(), Math.abs((double)ConfigSettings.TEMP_RATE.get().floatValue() / 50.0)) * (double)worldTempSign;
            if (changeBy < 0.0) {
                changeBy = coldDampening < 0.0 ? changeBy * (1.0 + Math.abs(coldDampening)) : CSMath.blend(changeBy, 0.0, coldDampening, 0.0, 1.0);
            } else if (changeBy > 0.0) {
                changeBy = heatDampening < 0.0 ? changeBy * (1.0 + Math.abs(heatDampening)) : CSMath.blend(changeBy, 0.0, heatDampening, 0.0, 1.0);
            }
            newCoreTemp += Temperature.apply(changeBy, entity, Temperature.Trait.RATE, this.getModifiers(Temperature.Trait.RATE));
        }
        int coreTempSign = CSMath.sign(newCoreTemp);
        if (this.getModifiers(Temperature.Trait.CORE).isEmpty()) {
            double amount = 0.0;
            if (isFullyColdDampened && coreTempSign < 0) {
                amount = ConfigSettings.TEMP_RATE.get() / 10.0;
            } else if (isFullyHeatDampened && coreTempSign > 0) {
                amount = ConfigSettings.TEMP_RATE.get() / -10.0;
            } else if (coreTempSign != 0 && coreTempSign != worldTempSign) {
                amount = (coreTempSign == 1 ? newWorldTemp - maxTemp : newWorldTemp - minTemp) / 3.0;
            }
            if (amount != 0.0) {
                changeBy = CSMath.maxAbs(amount * ConfigSettings.TEMP_RATE.get(), ConfigSettings.TEMP_RATE.get() / 10.0 * (double)(-coreTempSign));
                newCoreTemp += CSMath.minAbs(changeBy, -this.getTrait(Temperature.Trait.CORE));
            }
        }
        this.setTrait(Temperature.Trait.CORE, CSMath.clamp(newCoreTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.BASE, CSMath.clamp(newBaseTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.WORLD, newWorldTemp, entity);
        this.setTrait(Temperature.Trait.BURNING_POINT, maxTemp);
        this.setTrait(Temperature.Trait.FREEZING_POINT, minTemp);
        this.setTrait(Temperature.Trait.COLD_RESISTANCE, coldResistance);
        this.setTrait(Temperature.Trait.HEAT_RESISTANCE, heatResistance);
        this.setTrait(Temperature.Trait.COLD_DAMPENING, coldDampening);
        this.setTrait(Temperature.Trait.HEAT_DAMPENING, heatDampening);
        if (this.syncTimer > 0) {
            --this.syncTimer;
        }
        if (this.changed && this.syncTimer <= 0) {
            this.syncValues(entity);
        }
        this.tickHurting(entity, heatResistance, coldResistance);
    }

    private double modifyFromAttribute(LivingEntity entity, Temperature.Trait type, double baseValue) {
        Supplier<Double> defaultSupplier = () -> Temperature.apply(baseValue, entity, type, this.getModifiers(type));
        AttributeInstance attribute = EntityTempManager.getAttribute(type, entity);
        if (attribute == null) {
            return defaultSupplier.get();
        }
        double base = CSMath.safeDouble(attribute.m_22115_()).orElse(defaultSupplier.get());
        Collection<AttributeModifier> attributeModifiers = EntityTempManager.getAllAttributeModifiers(entity, attribute, null);
        for (AttributeModifier mod2 : attributeModifiers.stream().filter(mod -> mod.m_22217_() == AttributeModifier.Operation.ADDITION).toList()) {
            base += mod2.m_22218_();
        }
        double value = base;
        for (AttributeModifier mod3 : attributeModifiers.stream().filter(mod -> mod.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE).toList()) {
            value += base * mod3.m_22218_();
        }
        for (AttributeModifier mod3 : attributeModifiers.stream().filter(mod -> mod.m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL).toList()) {
            value *= 1.0 + mod3.m_22218_();
        }
        return value;
    }

    public void syncValues(LivingEntity entity) {
        Temperature.updateTemperature(entity, this, false);
        this.changed = false;
        this.syncTimer = 5;
    }

    public void tickHurting(LivingEntity entity, double heatResistance, double coldResistance) {
        double bodyTemp = this.getTrait(Temperature.Trait.BODY);
        boolean hasGrace = entity.m_21023_(ModEffects.GRACE);
        boolean hasFireResist = entity.m_21023_(MobEffects.f_19607_);
        boolean hasIceResist = entity.m_21023_(ModEffects.ICE_RESISTANCE);
        if (!hasGrace && entity.f_19797_ % 40 == 0) {
            if (!(!(bodyTemp >= 100.0) || hasFireResist && ConfigSettings.FIRE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource hot = ModDamageSources.HOT;
                DamageSource hotScaling = ModDamageSources.HOT.m_19386_();
                entity.m_6469_(ConfigSettings.DAMAGE_SCALING.get() != false ? hotScaling : hot, (float)CSMath.blend(ConfigSettings.TEMP_DAMAGE.get(), 0.0, heatResistance, 0.0, 1.0));
            } else if (!(!(bodyTemp <= -100.0) || hasIceResist && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource cold = ModDamageSources.COLD;
                DamageSource coldScaling = ModDamageSources.COLD.m_19386_();
                entity.m_6469_(ConfigSettings.DAMAGE_SCALING.get() != false ? coldScaling : cold, (float)CSMath.blend(ConfigSettings.TEMP_DAMAGE.get(), 0.0, coldResistance, 0.0, 1.0));
            }
        }
    }

    @Override
    public void copy(ITemperatureCap cap) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, cap.getTrait(trait));
        }
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            this.getModifiers(trait).clear();
            this.getModifiers(trait).addAll(cap.getModifiers(trait));
        }
        this.persistentAttributes.clear();
        this.persistentAttributes.addAll(cap.getPersistentAttributes());
        this.setPreferredUnits(cap.getPreferredUnits());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Traits", (Tag)this.serializeTraits());
        nbt.m_128365_("TempModifiers", (Tag)this.serializeModifiers());
        ListTag attributes = new ListTag();
        for (Attribute attribute : this.getPersistentAttributes()) {
            attributes.add((Object)StringTag.m_129297_((String)ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString()));
        }
        nbt.m_128365_("PersistentAttributes", (Tag)attributes);
        return nbt;
    }

    @Override
    public CompoundTag serializeTraits() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<Temperature.Trait, Double> trait : this.traits.entrySet()) {
            nbt.m_128347_(NBTHelper.getTraitTagKey(trait.getKey()), trait.getValue().doubleValue());
        }
        return nbt;
    }

    @Override
    public CompoundTag serializeModifiers() {
        CompoundTag nbt = new CompoundTag();
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            ListTag modifiers = new ListTag();
            for (TempModifier modifier : this.getModifiers(trait)) {
                modifiers.add((Object)NBTHelper.modifierToTag(modifier));
            }
            nbt.m_128365_(NBTHelper.getTraitTagKey(trait), (Tag)modifiers);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.deserializeTraits(nbt.m_128469_("Traits"));
        this.deserializeModifiers(nbt.m_128469_("TempModifiers"));
        ListTag attributes = nbt.m_128437_("PersistentAttributes", 8);
        for (int i = 0; i < attributes.size(); ++i) {
            this.markPersistentAttribute((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributes.m_128778_(i))));
        }
    }

    @Override
    public void deserializeTraits(CompoundTag nbt) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, nbt.m_128459_(NBTHelper.getTraitTagKey(trait)));
        }
    }

    @Override
    public void deserializeModifiers(CompoundTag nbt) {
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            this.getModifiers(trait).clear();
            ListTag modifiers = nbt.m_128437_(NBTHelper.getTraitTagKey(trait), 10);
            modifiers.forEach(modNBT -> NBTHelper.tagToModifier((CompoundTag)modNBT).ifPresent(modifier -> this.getModifiers(trait).add((TempModifier)modifier)));
        }
    }
}

