/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.insulation;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemInsulationCap
implements IInsulatableCap {
    private final List<Pair<ItemStack, List<Insulation>>> insulation = new ArrayList<Pair<ItemStack, List<Insulation>>>();

    @Override
    public List<Pair<ItemStack, List<Insulation>>> getInsulation() {
        return this.insulation;
    }

    public void calcAdaptiveInsulation(double worldTemp, double minTemp, double maxTemp) {
        for (Pair<ItemStack, List<Insulation>> entry : this.insulation) {
            List list = (List)entry.getSecond();
            for (Insulation pair : list) {
                if (!(pair instanceof AdaptiveInsulation)) continue;
                AdaptiveInsulation insul = (AdaptiveInsulation)pair;
                double factor = insul.getFactor();
                double adaptSpeed = insul.getSpeed();
                double newFactor = CSMath.betweenInclusive(CSMath.blend(-1.0, 1.0, worldTemp, minTemp, maxTemp), -0.25, 0.25) ? CSMath.shrink(factor, adaptSpeed) : CSMath.clamp(factor + CSMath.blend(-adaptSpeed, adaptSpeed, worldTemp, minTemp, maxTemp), -1.0, 1.0);
                insul.setFactor(newFactor);
            }
        }
    }

    @Override
    public void addInsulationItem(ItemStack stack) {
        ConfigSettings.INSULATION_ITEMS.get().computeIfPresent(stack.m_41720_(), (item, insulator) -> {
            this.insulation.add((Pair<ItemStack, List<Insulation>>)Pair.of((Object)stack, insulator.insulation().split()));
            return insulator;
        });
    }

    @Override
    public ItemStack removeInsulationItem(ItemStack stack) {
        Optional<Pair> toRemove = this.insulation.stream().filter(entry -> ((ItemStack)entry.getFirst()).equals(stack)).findFirst();
        toRemove.ifPresent(this.insulation::remove);
        return stack;
    }

    @Override
    public ItemStack getInsulationItem(int index) {
        return (ItemStack)this.insulation.get(index).getFirst();
    }

    @Override
    public boolean canAddInsulationItem(ItemStack armorItem, ItemStack insulationItem) {
        AtomicInteger positiveInsul = new AtomicInteger();
        Insulator insulator = ConfigSettings.INSULATION_ITEMS.get().get(insulationItem.m_41720_());
        if (insulator == null) {
            return false;
        }
        ArrayList<Pair<ItemStack, List<Insulation>>> insulList = new ArrayList<Pair<ItemStack, List<Insulation>>>(this.insulation);
        insulList.add((Pair<ItemStack, List<Insulation>>)Pair.of((Object)insulationItem, insulator.insulation().split()));
        insulList.stream().map(Pair::getSecond).flatMap(Collection::stream).forEach(insul -> {
            if (insul.getHeat() >= 0.0 || insul.getCold() >= 0.0) {
                positiveInsul.getAndIncrement();
            }
        });
        return positiveInsul.get() <= ItemInsulationManager.getInsulationSlots(armorItem);
    }

    public CompoundTag serializeNBT() {
        ListTag insulNBT = new ListTag();
        for (int i = 0; i < this.insulation.size(); ++i) {
            Pair<ItemStack, List<Insulation>> entry = this.insulation.get(i);
            CompoundTag entryNBT = new CompoundTag();
            List pairList = (List)entry.getSecond();
            entryNBT.m_128365_("Item", (Tag)((ItemStack)entry.getFirst()).m_41739_(new CompoundTag()));
            ListTag pairListNBT = ItemInsulationCap.serializeInsulation(pairList);
            entryNBT.m_128365_("Values", (Tag)pairListNBT);
            insulNBT.add((Object)entryNBT);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Insulation", (Tag)insulNBT);
        return tag;
    }

    private static ListTag serializeInsulation(List<Insulation> pairList) {
        ListTag insulList = new ListTag();
        for (int i = 0; i < pairList.size(); ++i) {
            insulList.add((Object)pairList.get(i).serialize());
        }
        return insulList;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.insulation.clear();
        ListTag insulList = tag.m_128437_("Insulation", 10);
        for (int i = 0; i < insulList.size(); ++i) {
            CompoundTag entryNBT = insulList.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)entryNBT.m_128469_("Item"));
            List pairList = entryNBT.m_128437_("Values", 10).stream().map(tg -> Insulation.deserialize((CompoundTag)tg)).filter(Objects::nonNull).map(Insulation::split).flatMap(Collection::stream).toList();
            this.insulation.add((Pair<ItemStack, List<Insulation>>)Pair.of((Object)stack, new ArrayList(pairList)));
        }
    }

    @Override
    public void copy(IInsulatableCap cap) {
        this.insulation.clear();
        this.insulation.addAll(cap.getInsulation());
    }
}

