/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.shearing.IShearableCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncShearableDataMessage;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import oshi.util.tuples.Triplet;

@Mod.EventBusSubscriber
public class ShearableFurManager {
    public static Map<Entity, LazyOptional<IShearableCap>> SERVER_CAP_CACHE = new HashMap<Entity, LazyOptional<IShearableCap>>();
    public static Map<Entity, LazyOptional<IShearableCap>> CLIENT_CAP_CACHE = new HashMap<Entity, LazyOptional<IShearableCap>>();

    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Goat) {
            final ShearableFurCap cap = new ShearableFurCap();
            final LazyOptional capOptional = LazyOptional.of(() -> cap);
            final Capability<IShearableCap> capability = ModCapabilities.SHEARABLE_FUR;
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap2, @Nullable Direction direction) {
                    if (cap2 == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "fur"), (ICapabilityProvider)provider);
        }
    }

    public static LazyOptional<IShearableCap> getFurCap(Entity entity) {
        Map<Entity, LazyOptional<IShearableCap>> cache = entity.f_19853_.f_46443_ ? CLIENT_CAP_CACHE : SERVER_CAP_CACHE;
        return cache.computeIfAbsent(entity, e -> {
            LazyOptional cap = e.getCapability(ModCapabilities.SHEARABLE_FUR);
            cap.addListener(opt -> cache.remove(e));
            return cap;
        });
    }

    @SubscribeEvent
    public static void onShearGoat(PlayerInteractEvent.EntityInteract event) {
        Goat goat;
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (entity instanceof Goat && !(goat = (Goat)entity).m_6162_() && !goat.f_19853_.f_46443_ && stack.m_41720_() == Items.f_42574_) {
            ShearableFurManager.getFurCap((Entity)goat).ifPresent(cap -> {
                block5: {
                    if (cap.isSheared()) {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                    player.m_21011_(event.getHand(), true);
                    stack.m_41622_(1, (LivingEntity)event.getEntity(), p -> p.m_21190_(event.getHand()));
                    goat.f_19853_.m_6269_(null, (Entity)goat, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    for (ItemStack item : ModLootTables.getDropsLootTable((Entity)goat, player, ModLootTables.GOAT_SHEARING)) {
                        WorldHelper.entityDropItem((Entity)goat, item);
                    }
                    if (!player.m_7500_() && goat.f_19853_.m_46791_() != Difficulty.PEACEFUL && !goat.f_19853_.f_46443_ && goat.m_217043_().m_188500_() < 0.4) {
                        goat.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)30);
                        for (WrappedGoal goal : goat.f_21345_.m_148105_()) {
                            if (goal.m_6767_()) {
                                goal.m_8041_();
                                continue;
                            }
                            break block5;
                        }
                        TaskScheduler.scheduleServer(() -> {
                            ClientboundEntityEventPacket packet = new ClientboundEntityEventPacket((Entity)goat, 58);
                            ((ServerChunkCache)goat.f_19853_.m_7726_()).m_8394_((Entity)goat, (Packet)packet);
                        }, 5);
                        BehaviorUtils.m_22595_((LivingEntity)goat, (LivingEntity)player);
                        goat.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                        goat.m_6274_().m_21879_(MemoryModuleType.f_148203_, (Object)player.m_20182_());
                        TaskScheduler.scheduleServer(() -> {
                            if (player.m_20270_((Entity)goat) <= 10.0f) {
                                goat.m_5496_(goat.m_149397_() ? SoundEvents.f_144149_ : SoundEvents.f_144169_, 1.0f, 1.0f);
                                goat.m_6274_().m_21879_(MemoryModuleType.f_148203_, (Object)player.m_20182_());
                            }
                        }, 30);
                        goat.m_6274_().m_21889_(Activity.f_150240_);
                    }
                }
                cap.setSheared(true);
                cap.setLastSheared(goat.f_19797_);
                entity.getPersistentData().m_128405_("FurGrowthCooldown", ((Integer)ConfigSettings.FUR_TIMINGS.get().getB()).intValue());
                ShearableFurManager.syncData(goat, null);
                event.setResult(Event.Result.ALLOW);
            });
        }
    }

    @SubscribeEvent
    public static void onGoatTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Goat)) {
            return;
        }
        Goat goat = (Goat)entity;
        Triplet<Integer, Integer, Double> furConfig = ConfigSettings.FUR_TIMINGS.get();
        if (entity.getPersistentData().m_128451_("FurGrowthCooldown") > 0) {
            entity.getPersistentData().m_128405_("FurGrowthCooldown", entity.getPersistentData().m_128451_("FurGrowthCooldown") - 1);
        }
        if (!goat.f_19853_.f_46443_ && goat.f_19797_ % (Integer)furConfig.getA() == 0 && Math.random() < (Double)furConfig.getC()) {
            ShearableFurManager.getFurCap((Entity)goat).ifPresent(arg_0 -> ShearableFurManager.lambda$onGoatTick$7((Entity)entity, goat, arg_0));
        }
    }

    @SubscribeEvent
    public static void onEntityLoaded(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof Goat) {
                Goat goat = (Goat)player;
                ShearableFurManager.syncData(goat, player2);
            }
        }
    }

    public static void syncData(Goat goat, ServerPlayer player) {
        if (!goat.f_19853_.f_46443_) {
            ShearableFurManager.getFurCap((Entity)goat).ifPresent(cap -> ColdSweatPacketHandler.INSTANCE.send(player != null ? PacketDistributor.PLAYER.with(() -> player) : PacketDistributor.TRACKING_ENTITY.with(() -> goat), (Object)new SyncShearableDataMessage(cap.isSheared(), cap.lastSheared(), goat.m_19879_())));
        }
    }

    private static /* synthetic */ void lambda$onGoatTick$7(Entity entity, Goat goat, IShearableCap cap) {
        if (entity.getPersistentData().m_128451_("FurGrowthCooldown") <= 0 && cap.isSheared()) {
            WorldHelper.playEntitySound(SoundEvents.f_12641_, (Entity)goat, goat.m_5720_(), 0.5f, 0.6f);
            WorldHelper.playEntitySound(SoundEvents.f_12100_, (Entity)goat, goat.m_5720_(), 0.5f, 0.8f);
            WorldHelper.spawnParticleBatch(goat.f_19853_, (ParticleOptions)ParticleTypes.f_123764_, goat.m_20185_(), goat.m_20186_() + (double)(goat.m_20206_() / 2.0f), goat.m_20189_(), 0.5, 0.5, 0.5, 10.0, 0.05f);
            cap.setSheared(false);
            ShearableFurManager.syncData(goat, null);
        }
    }
}

