/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.model.entity.ChameleonModel;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ChameleonColorLayer<T extends Entity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final RenderType CHAMELEON_SHED = RenderType.m_110473_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_SHED);
    private static final RenderType CHAMELEON_RED = RenderType.m_110473_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_RED);
    private static final RenderType CHAMELEON_BLUE = RenderType.m_110473_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_BLUE);

    public ChameleonColorLayer(RenderLayerParent<T, M> parentLayer) {
        super(parentLayer);
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource bufferSource, int light, T entity, float p_117353_, float p_117354_, float partialTick, float p_117356_, float p_117357_, float p_117358_) {
        if (entity instanceof Chameleon) {
            float alpha;
            VertexConsumer vertexConsumer;
            Chameleon chameleon = (Chameleon)((Object)entity);
            float midTemp = (float)CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            if (!CSMath.betweenInclusive(chameleon.getTemperature(), CSMath.average(ConfigSettings.MIN_TEMP.get(), Float.valueOf(midTemp)), CSMath.average(ConfigSettings.MAX_TEMP.get(), Float.valueOf(midTemp)))) {
                if (chameleon.getTemperature() > midTemp) {
                    vertexConsumer = bufferSource.m_6299_(CHAMELEON_RED);
                    float f = alpha = chameleon.f_20916_ > 0 ? 0.0f : (float)CSMath.blend(0.0, 1.0, (double)chameleon.getTemperature(), CSMath.average(ConfigSettings.MAX_TEMP.get(), Float.valueOf(midTemp)), ConfigSettings.MAX_TEMP.get());
                    if (alpha > 0.0f) {
                        ((ChameleonModel)this.m_117386_()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha * chameleon.opacity, true);
                    }
                } else {
                    vertexConsumer = bufferSource.m_6299_(CHAMELEON_BLUE);
                    float f = alpha = chameleon.f_20916_ > 0 ? 0.0f : (float)CSMath.blend(1.0, 0.0, (double)chameleon.getTemperature(), ConfigSettings.MIN_TEMP.get(), CSMath.average(ConfigSettings.MIN_TEMP.get(), Float.valueOf(midTemp)));
                    if (alpha > 0.0f) {
                        ((ChameleonModel)this.m_117386_()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha * chameleon.opacity, true);
                    }
                }
            }
            if (chameleon.isShedding()) {
                vertexConsumer = bufferSource.m_6299_(CHAMELEON_SHED);
                float f = alpha = chameleon.f_20916_ > 0 || chameleon.getLastShed() == 0 ? 0.0f : CSMath.blend(0.0f, 0.7f, chameleon.getAgeSecs() * 20 - chameleon.getLastShed(), 0.0f, chameleon.getTimeToShed());
                if (alpha > 0.0f) {
                    ((ChameleonModel)this.m_117386_()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha * chameleon.opacity, true);
                }
            }
            RenderSystem.m_69461_();
        }
    }
}

