/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientInsulationTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TOOLTIP = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar.png");
    public static final ResourceLocation TOOLTIP_HC = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    List<Insulation> insulation;
    Insulation.Slot type;
    int width = 0;
    ItemStack stack;
    private static final Method INNER_BLIT = ObfuscationReflectionHelper.findMethod(GuiComponent.class, (String)"m_93187_", (Class[])new Class[]{PoseStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE});

    public static void innerBlit(PoseStack poseStack, int x1, int x2, int y1, int y2, int zOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        try {
            INNER_BLIT.invoke(null, poseStack, x1, x2, y1, y2, zOffset, uWidth, vHeight, Float.valueOf(uOffset), Float.valueOf(vOffset), textureWidth, textureHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void blit(PoseStack poseStack, int x, int y, int zOffset, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        ClientInsulationTooltip.innerBlit(poseStack, x, x + width, y, y + height, zOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public ClientInsulationTooltip(List<Insulation> insulation, Insulation.Slot type, ItemStack stack) {
        this.insulation = insulation;
        this.type = type;
        this.stack = stack;
    }

    public int m_142103_() {
        return 10;
    }

    public int m_142069_(Font font) {
        return this.width + 12;
    }

    public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer itemRenderer, int depth) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        ArrayList<Insulation> posInsulation = new ArrayList<Insulation>();
        ArrayList<Insulation> negInsulation = new ArrayList<Insulation>();
        for (Insulation ins : this.insulation) {
            if (ins instanceof StaticInsulation) {
                StaticInsulation insul = (StaticInsulation)ins;
                double cold = insul.getCold();
                double heat = insul.getHeat();
                if (CSMath.sign(cold) == CSMath.sign(heat)) {
                    switch (CSMath.sign(cold)) {
                        case -1: {
                            negInsulation.add(ins);
                            break;
                        }
                        case 1: {
                            posInsulation.add(ins);
                        }
                    }
                    continue;
                }
                switch (CSMath.sign(cold)) {
                    case -1: {
                        negInsulation.add(new StaticInsulation(-cold, 0.0));
                        break;
                    }
                    case 1: {
                        posInsulation.add(new StaticInsulation(cold, 0.0));
                    }
                }
                switch (CSMath.sign(heat)) {
                    case -1: {
                        negInsulation.add(new StaticInsulation(0.0, heat));
                        break;
                    }
                    case 1: {
                        posInsulation.add(new StaticInsulation(0.0, heat));
                    }
                }
                continue;
            }
            if (!(ins instanceof AdaptiveInsulation)) continue;
            AdaptiveInsulation adaptive = (AdaptiveInsulation)ins;
            double value = adaptive.getInsulation();
            if (value < 0.0) {
                negInsulation.add(ins);
                continue;
            }
            posInsulation.add(ins);
        }
        poseStack.m_85836_();
        this.width = 0;
        if (!posInsulation.isEmpty()) {
            ClientInsulationTooltip.renderBar(poseStack, x, y, posInsulation, this.type, !negInsulation.isEmpty(), false, this.stack);
            poseStack.m_85837_((double)(posInsulation.size() * 6 + 12), 0.0, 0.0);
            this.width += posInsulation.size() * 6 + 12;
        }
        if (!negInsulation.isEmpty()) {
            ClientInsulationTooltip.renderBar(poseStack, x + this.width, y, negInsulation, this.type, true, true, this.stack);
            this.width += negInsulation.size() * 6 + 12;
        }
        poseStack.m_85849_();
    }

    static void renderCell(PoseStack poseStack, int x, int y, double insulation, int uvX, boolean isAdaptive) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        double rounded = CSMath.roundNearest(Math.abs(insulation), 0.25);
        int uvY = isAdaptive ? (rounded >= 2.0 ? 16 : 20) : (rounded >= 2.0 ? 8 : 12);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)401, (float)uvX, (float)uvY, (int)6, (int)4, (int)32, (int)24);
    }

    static int renderOverloadCell(PoseStack poseStack, Font font, int x, int y, double insulation, int textColor, Insulation.Type type) {
        Number insul = CSMath.truncate(insulation / 2.0, 2);
        if (CSMath.isInteger(insul)) {
            insul = ((Number)insul).intValue();
        }
        String text = "x" + insul;
        int uvX = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Insulation.Type.COLD -> 12;
            case Insulation.Type.HEAT -> 18;
            case Insulation.Type.NEUTRAL -> 6;
            case Insulation.Type.ADAPTIVE -> 12;
        };
        poseStack.m_85836_();
        int prevShader = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        ClientInsulationTooltip.renderCell(poseStack, x + 7, y + 1, insulation, uvX, type == Insulation.Type.ADAPTIVE);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + 6), (int)y, (int)401, (float)11.0f, (float)0.0f, (int)8, (int)6, (int)32, (int)24);
        poseStack.m_85837_(0.0, 0.0, 400.0);
        font.m_92750_(poseStack, text, (float)(x + 15), (float)(y - 1), textColor);
        RenderSystem.m_157453_((int)0, (int)prevShader);
        poseStack.m_85849_();
        return 12 + font.m_92895_(text);
    }

    static void renderBar(PoseStack poseStack, int x, int y, List<Insulation> insulations, Insulation.Slot type, boolean showSign, boolean isNegative, ItemStack stack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        Font font = Minecraft.m_91087_().f_91062_;
        List<Insulation> sortedInsulation = Insulation.sort(insulations);
        boolean overflow = sortedInsulation.size() >= 10;
        int insulSlotCount = Math.max(type == Insulation.Slot.ARMOR ? ConfigSettings.INSULATION_SLOTS.get().getSlots(LivingEntity.m_147233_((ItemStack)stack), stack) : 0, insulations.size());
        for (int i = 0; i < insulSlotCount && !overflow; ++i) {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + 7 + i * 6), (int)(y + 1), (int)401, (float)0.0f, (float)0.0f, (int)6, (int)4, (int)32, (int)24);
        }
        poseStack.m_85836_();
        if (overflow) {
            double cold = 0.0;
            double heat = 0.0;
            double neutral = 0.0;
            double adaptive = 0.0;
            for (Insulation insulation : sortedInsulation) {
                if (insulation instanceof StaticInsulation) {
                    StaticInsulation staticInsulation = (StaticInsulation)insulation;
                    if (staticInsulation.getCold() > staticInsulation.getHeat()) {
                        cold += staticInsulation.getCold();
                        continue;
                    }
                    if (staticInsulation.getHeat() > staticInsulation.getCold()) {
                        heat += staticInsulation.getHeat();
                        continue;
                    }
                    neutral += staticInsulation.getCold() * 2.0;
                    continue;
                }
                if (!(insulation instanceof AdaptiveInsulation)) continue;
                AdaptiveInsulation adaptiveInsulation = (AdaptiveInsulation)insulation;
                adaptive += adaptiveInsulation.getInsulation();
            }
            int textColor = 0xA0A0A0;
            poseStack.m_85836_();
            if (cold > 0.0) {
                int xOffs = ClientInsulationTooltip.renderOverloadCell(poseStack, font, x, y, cold, textColor, Insulation.Type.COLD);
                poseStack.m_85837_((double)xOffs, 0.0, 0.0);
            }
            if (heat > 0.0) {
                int xOffs = ClientInsulationTooltip.renderOverloadCell(poseStack, font, x, y, heat, textColor, Insulation.Type.HEAT);
                poseStack.m_85837_((double)xOffs, 0.0, 0.0);
            }
            if (neutral > 0.0) {
                int xOffs = ClientInsulationTooltip.renderOverloadCell(poseStack, font, x, y, neutral, textColor, Insulation.Type.NEUTRAL);
                poseStack.m_85837_((double)xOffs, 0.0, 0.0);
            }
            if (adaptive > 0.0) {
                int xOffs = ClientInsulationTooltip.renderOverloadCell(poseStack, font, x, y, adaptive, textColor, Insulation.Type.ADAPTIVE);
                poseStack.m_85837_((double)xOffs, 0.0, 0.0);
            }
            poseStack.m_85849_();
        } else {
            for (Insulation insulation : sortedInsulation) {
                int i;
                if (insulation instanceof AdaptiveInsulation) {
                    AdaptiveInsulation adaptive = (AdaptiveInsulation)insulation;
                    double value = adaptive.getInsulation();
                    for (int i2 = 0; i2 < CSMath.ceil(Math.abs(value)) / 2; ++i2) {
                        double insul = CSMath.minAbs(CSMath.shrink(value, (double)(i2 * 2)), 2.0);
                        ClientInsulationTooltip.renderCell(poseStack, x + 7, y + 1, insul, 12, true);
                        double blend = Math.abs(adaptive.getFactor());
                        int overlayU = switch (CSMath.sign(adaptive.getFactor())) {
                            case -1 -> 6;
                            case 1 -> 18;
                            default -> 12;
                        };
                        RenderSystem.m_69478_();
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)blend));
                        ClientInsulationTooltip.renderCell(poseStack, x + 7, y + 1, insul, overlayU, true);
                        RenderSystem.m_69461_();
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        poseStack.m_85837_(6.0, 0.0, 0.0);
                    }
                    continue;
                }
                if (!(insulation instanceof StaticInsulation)) continue;
                StaticInsulation staticInsulation = (StaticInsulation)insulation;
                double cold = staticInsulation.getCold();
                double hot = staticInsulation.getHeat();
                double neutral = cold > 0.0 == hot > 0.0 ? CSMath.minAbs(cold, hot) : 0.0;
                cold -= neutral;
                hot -= neutral;
                for (i = 0; i < CSMath.ceil(Math.abs(cold)) / 2; ++i) {
                    double coldInsul = CSMath.minAbs(CSMath.shrink(cold, (double)(i * 2)), 2.0);
                    ClientInsulationTooltip.renderCell(poseStack, x + 7, y + 1, coldInsul, 12, false);
                    poseStack.m_85837_(6.0, 0.0, 0.0);
                }
                for (i = 0; i < CSMath.ceil(Math.abs(neutral)); ++i) {
                    double neutralInsul = CSMath.minAbs(CSMath.shrink(neutral, (double)i), 1.0) * 2.0;
                    ClientInsulationTooltip.renderCell(poseStack, x + 7, y + 1, neutralInsul, 6, false);
                    poseStack.m_85837_(6.0, 0.0, 0.0);
                }
                for (i = 0; i < CSMath.ceil(Math.abs(hot)) / 2; ++i) {
                    double hotInsul = CSMath.minAbs(CSMath.shrink(hot, (double)(i * 2)), 2.0);
                    ClientInsulationTooltip.renderCell(poseStack, x + 7, y + 1, hotInsul, 18, false);
                    poseStack.m_85837_(6.0, 0.0, 0.0);
                }
            }
        }
        poseStack.m_85849_();
        for (int i = 0; i < insulSlotCount && !overflow; ++i) {
            boolean end;
            boolean bl = end = i == insulSlotCount - 1;
            if (end) {
                ClientInsulationTooltip.blit(poseStack, x + 7 + i * 6, y, 401, 5, 6, 6.0f, 0.0f, 3, 6, 32, 24);
                ClientInsulationTooltip.blit(poseStack, x + 7 + i * 6 + 4, y, 401, 3, 6, 8.0f, 0.0f, 3, 6, 32, 24);
                continue;
            }
            ClientInsulationTooltip.blit(poseStack, x + 7 + i * 6, y, 401, 6, 6, 6.0f, 0.0f, 3, 6, 32, 24);
        }
        switch (type) {
            case CURIO: {
                GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)(y - 1), (int)401, (float)24.0f, (float)16.0f, (int)8, (int)8, (int)32, (int)24);
                break;
            }
            case ITEM: {
                GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)(y - 1), (int)401, (float)24.0f, (float)0.0f, (int)8, (int)8, (int)32, (int)24);
                break;
            }
            case ARMOR: {
                GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)(y - 1), (int)401, (float)24.0f, (float)8.0f, (int)8, (int)8, (int)32, (int)24);
            }
        }
        if (showSign) {
            if (isNegative) {
                GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + 3), (int)(y + 3), (int)401, (float)19.0f, (float)5.0f, (int)5, (int)3, (int)32, (int)24);
            } else {
                GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + 3), (int)(y + 2), (int)401, (float)19.0f, (float)0.0f, (int)5, (int)5, (int)32, (int)24);
            }
        }
    }

    static {
        INNER_BLIT.setAccessible(true);
    }
}

