/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class ConfigPageDifficulty
extends Screen {
    private static final String BLUE = ChatFormatting.BLUE.toString();
    private static final String RED = ChatFormatting.RED.toString();
    private static final String YEL = ChatFormatting.YELLOW.toString();
    private static final String CLEAR = ChatFormatting.RESET.toString();
    private static final String BOLD = ChatFormatting.BOLD.toString();
    private static final String U_LINE = ChatFormatting.UNDERLINE.toString();
    private static final List<Component> SUPER_EASY_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.SUPER_EASY);
    private static final List<Component> EASY_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.EASY);
    private static final List<Component> NORMAL_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.NORMAL);
    private static final List<Component> HARD_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.HARD);
    private static final List<Component> CUSTOM_DESCRIPTION = Collections.singletonList(Component.m_237115_((String)"cold_sweat.config.difficulty.description.custom"));
    static final ResourceLocation CONFIG_BUTTONS_LOCATION = new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png");
    private final Screen parentScreen;

    public ConfigPageDifficulty(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"cold_sweat.config.section.difficulty"));
        this.parentScreen = parentScreen;
    }

    public static List<Component> getListFor(int difficulty) {
        return switch (difficulty) {
            case 0 -> SUPER_EASY_DESCRIPTION;
            case 1 -> EASY_DESCRIPTION;
            case 2 -> NORMAL_DESCRIPTION;
            case 3 -> HARD_DESCRIPTION;
            default -> CUSTOM_DESCRIPTION;
        };
    }

    private static List<Component> generateDescription(ConfigSettings.Difficulty difficulty) {
        return List.of(Component.m_237110_((String)"cold_sweat.config.difficulty.description.min_temp", (Object[])new Object[]{ConfigPageDifficulty.getTemperatureString((Double)difficulty.getSetting("min_temp"), BLUE)}), Component.m_237110_((String)"cold_sweat.config.difficulty.description.max_temp", (Object[])new Object[]{ConfigPageDifficulty.getTemperatureString((Double)difficulty.getSetting("max_temp"), RED)}), ConfigPageDifficulty.getRateComponent(difficulty), Component.m_237110_((String)("cold_sweat.config.difficulty.description.world_temp_" + ((Boolean)difficulty.getSetting("require_thermometer") != false ? "off" : "on")), (Object[])new Object[]{BOLD + U_LINE, CLEAR}), Component.m_237110_((String)("cold_sweat.config.difficulty.description.scaling_" + ((Boolean)difficulty.getSetting("damage_scaling") != false ? "on" : "off")), (Object[])new Object[]{BOLD + U_LINE, CLEAR}), Component.m_237110_((String)("cold_sweat.config.difficulty.description.potions_" + ((Boolean)difficulty.getSetting("ice_resistance_enabled") != false ? "on" : "off")), (Object[])new Object[]{BOLD + U_LINE, CLEAR}));
    }

    private static String getTemperatureString(double temp, String color) {
        DecimalFormat df = new DecimalFormat("#.##");
        return color + df.format(Temperature.convert(temp, Temperature.Units.MC, Temperature.Units.F, true)) + CLEAR + " \u00b0F / " + color + df.format(Temperature.convert(temp, Temperature.Units.MC, Temperature.Units.C, true)) + CLEAR + " \u00b0C";
    }

    private static Component getRateComponent(ConfigSettings.Difficulty difficulty) {
        double rate = (Double)difficulty.getSetting("temp_rate");
        String key = rate < 1.0 ? "cold_sweat.config.difficulty.description.rate.decrease" : (rate == 1.0 ? "cold_sweat.config.difficulty.description.rate.normal" : "cold_sweat.config.difficulty.description.rate.increase");
        return rate == 1.0 ? Component.m_237115_((String)key) : Component.m_237110_((String)key, (Object[])new Object[]{YEL + Math.abs(1.0 - rate) * 100.0 + "%" + CLEAR});
    }

    public static int getDifficultyColor(int difficulty) {
        return switch (difficulty) {
            case 0 -> 0xFFFFFF;
            case 1 -> 16768882;
            case 2 -> 16755024;
            case 3 -> 16731202;
            default -> 10631158;
        };
    }

    public static Component getDifficultyName(int difficulty) {
        return switch (difficulty) {
            case 0 -> Component.m_237115_((String)"cold_sweat.config.difficulty.super_easy.name");
            case 1 -> Component.m_237115_((String)"cold_sweat.config.difficulty.easy.name");
            case 2 -> Component.m_237115_((String)"cold_sweat.config.difficulty.normal.name");
            case 3 -> Component.m_237115_((String)"cold_sweat.config.difficulty.hard.name");
            default -> Component.m_237115_((String)"cold_sweat.config.difficulty.custom.name");
        };
    }

    public int index() {
        return -1;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 26, 150, 20, CommonComponents.f_130655_, button -> this.m_7379_()));
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            this.m_96626_(0);
        }
        int difficulty = ConfigSettings.DIFFICULTY.get();
        ArrayList<MutableComponent> descLines = new ArrayList<MutableComponent>();
        descLines.add(Component.m_237113_((String)""));
        int longestLine = 0;
        for (Component text : ConfigPageDifficulty.getListFor(difficulty)) {
            MutableComponent descLine = Component.m_237113_((String)(" \u2022 " + text.getString() + " "));
            descLines.add(descLine);
            descLines.add(Component.m_237113_((String)""));
            int lineWidth = this.f_96547_.m_92852_((FormattedText)descLine);
            if (lineWidth <= longestLine) continue;
            longestLine = lineWidth;
        }
        int middleX = this.f_96543_ / 2;
        int middleY = this.f_96544_ / 2;
        this.renderTooltip(poseStack, descLines, ItemStack.f_41583_.m_150921_(), middleX - longestLine / 2 - 10, middleY - 16, this.f_96547_);
        ConfigScreen.MOUSE_X = mouseX;
        ConfigScreen.MOUSE_Y = mouseY;
        ConfigPageDifficulty.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONFIG_BUTTONS_LOCATION);
        this.m_93228_(poseStack, this.f_96543_ / 2 - 76, this.f_96544_ / 2 - 53, 12, this.isMouseOverSlider(mouseX, mouseY) ? 134 : 128, 152, 6);
        this.m_93228_(poseStack, this.f_96543_ / 2 - 78 + difficulty * 37, this.f_96544_ / 2 - 58, this.isMouseOverSlider(mouseX, mouseY) ? 0 : 6, 128, 6, 16);
        Component difficultyName = ConfigPageDifficulty.getDifficultyName(difficulty);
        this.f_96547_.m_92763_(poseStack, difficultyName, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)difficultyName) / 2.0f, (float)this.f_96544_ / 2.0f - 84.0f, ConfigPageDifficulty.getDifficultyColor(difficulty));
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        super.m_7379_();
        switch (ConfigSettings.DIFFICULTY.get()) {
            case 0: {
                ConfigSettings.Difficulty.SUPER_EASY.load();
                break;
            }
            case 1: {
                ConfigSettings.Difficulty.EASY.load();
                break;
            }
            case 2: {
                ConfigSettings.Difficulty.NORMAL.load();
                break;
            }
            case 3: {
                ConfigSettings.Difficulty.HARD.load();
            }
        }
        ConfigScreen.saveConfig();
        ConfigScreen.MC.m_91152_(this.parentScreen);
    }

    boolean isMouseOverSlider(double mouseX, double mouseY) {
        return mouseX >= (double)this.f_96543_ / 2.0 - 80.0 && mouseX <= (double)this.f_96543_ / 2.0 + 80.0 && mouseY >= (double)this.f_96544_ / 2.0 - 67.0 && mouseY <= (double)this.f_96544_ / 2.0 - 35.0;
    }

    public void m_86600_() {
        double x = ConfigScreen.MOUSE_X;
        double y = ConfigScreen.MOUSE_Y;
        if (ConfigScreen.IS_MOUSE_DOWN && this.isMouseOverSlider(x, y)) {
            int newDifficulty = (int)Math.round(CSMath.blend(0.0, 4.0, x, (double)this.f_96543_ / 2.0 - 76.0, (double)this.f_96543_ / 2.0 + 76.0));
            if (newDifficulty != ConfigSettings.DIFFICULTY.get()) {
                ConfigScreen.MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)new SoundEvent(new ResourceLocation("minecraft:block.note_block.hat")), (float)1.8f, (float)0.5f));
            }
            ConfigSettings.DIFFICULTY.set(newDifficulty);
        }
    }
}

