/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.config.AbstractConfigPage;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageDifficulty;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageOne;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageThree;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageTwo;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncConfigSettingsMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncPreferredUnitsMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ConfigScreen {
    public static final int TITLE_HEIGHT = 16;
    public static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    public static final int OPTION_SIZE = 25;
    public static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft MC = Minecraft.m_91087_();
    public static DecimalFormat TWO_PLACES = new DecimalFormat("#.##");
    public static boolean IS_MOUSE_DOWN = false;
    public static int MOUSE_X = 0;
    public static int MOUSE_Y = 0;
    static List<Function<Screen, AbstractConfigPage>> PAGES = new ArrayList<Function>(Arrays.asList(ConfigPageOne::new, ConfigPageTwo::new, ConfigPageThree::new));
    public static int FIRST_PAGE = 0;
    public static int LAST_PAGE = PAGES.size() - 1;
    public static int CURRENT_PAGE = 0;
    public static final Supplier<Integer> SHIFT_AMOUNT = () -> Screen.m_96638_() && Screen.m_96637_() ? 100 : (Screen.m_96638_() ? 10 : 1);

    public static Screen getPage(int index, Screen parentScreen) {
        return PAGES.get(CSMath.clamp(index, FIRST_PAGE, LAST_PAGE)).apply(parentScreen);
    }

    public static void saveConfig() {
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (Minecraft.m_91087_().f_91074_ != null) {
            if (!MC.m_91090_()) {
                ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new SyncConfigSettingsMessage(registryAccess));
            } else {
                ConfigSettings.saveValues(registryAccess);
            }
            ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new SyncPreferredUnitsMessage(ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F));
        } else {
            ConfigSettings.saveValues(registryAccess);
        }
        ClientSettingsConfig.getInstance().writeAndSave();
    }

    @SubscribeEvent
    public static void onClicked(ScreenEvent.MouseButtonPressed event) {
        if (event.getButton() == 0 && Minecraft.m_91087_().f_91080_ instanceof ConfigPageDifficulty) {
            IS_MOUSE_DOWN = true;
        }
    }

    @SubscribeEvent
    public static void onReleased(ScreenEvent.MouseButtonReleased event) {
        if (event.getButton() == 0 && Minecraft.m_91087_().f_91080_ instanceof ConfigPageDifficulty) {
            IS_MOUSE_DOWN = false;
        }
    }
}

