/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WaterTempModifier
extends TempModifier {
    public WaterTempModifier() {
        this(0.01);
    }

    public WaterTempModifier(double strength) {
        this.getNBT().m_128347_("Strength", strength);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double maxTemp = ConfigSettings.MAX_TEMP.get();
        double minTemp = ConfigSettings.MIN_TEMP.get();
        double strength = this.getNBT().m_128459_("Strength");
        double returnRate = Math.min(-0.0012, -0.0012 - worldTemp / 640.0);
        double addAmount = WorldHelper.isInWater((Entity)entity) ? 0.05 : (WorldHelper.isRainingAt(entity.f_19853_, entity.m_20183_()) ? 0.0125 : returnRate);
        double maxStrength = CSMath.clamp(Math.abs(CSMath.average(maxTemp, minTemp) - worldTemp) / 2.0, 0.23, 0.5);
        double newStrength = CSMath.clamp(strength + addAmount, 0.0, maxStrength);
        this.getNBT().m_128347_("Strength", newStrength);
        if (strength <= 0.0) {
            this.expires(this.getTicksExisted() - 1);
        }
        return temp -> {
            if (!entity.m_20069_() && Math.random() < strength * 2.0) {
                double randX = (double)entity.m_20205_() * (Math.random() - 0.5);
                double randY = (double)entity.m_20206_() * Math.random();
                double randZ = (double)entity.m_20205_() * (Math.random() - 0.5);
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_() + randX, entity.m_20186_() + randY, entity.m_20189_() + randZ, 0.0, 0.0, 0.0);
            }
            return temp - newStrength;
        };
    }
}

