/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;
import oshi.util.tuples.Triplet;

public class UndergroundTempModifier
extends TempModifier {
    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (entity.f_19853_.m_6042_().f_63856_()) {
            return temp -> temp;
        }
        BlockPos playerPos = new BlockPos(entity.m_146892_());
        Level level = entity.f_19853_;
        ArrayList<Pair> depthTable = new ArrayList<Pair>();
        for (BlockPos pos : WorldHelper.getPositionGrid(entity.m_20183_(), 49, 10)) {
            if (!level.m_46739_(pos)) continue;
            depthTable.add(Pair.of((Object)pos, (Object)Math.sqrt(pos.m_123331_((Vec3i)playerPos))));
        }
        double biomeTempTotal = 0.0;
        int caveBiomeCount = 0;
        for (BlockPos pos : WorldHelper.getPositionCube(entity.m_20183_(), 5, 10)) {
            Holder holder;
            if (!level.m_46739_(pos) || (double)WorldHelper.getHeight(pos, level) <= entity.m_20186_() || !(holder = level.m_7062_().m_204214_(pos)).m_203656_(Tags.Biomes.IS_UNDERGROUND) || holder.m_203543_().isEmpty()) continue;
            Biome biome = (Biome)holder.m_203334_();
            double baseTemp = biome.m_47554_();
            Triplet<Double, Double, Temperature.Units> cTemp = ConfigSettings.BIOME_TEMPS.get(entity.f_19853_.m_5962_()).getOrDefault(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)baseTemp, (Object)baseTemp, (Object)Temperature.Units.MC));
            Triplet<Double, Double, Temperature.Units> cOffset = ConfigSettings.BIOME_OFFSETS.get(entity.f_19853_.m_5962_()).getOrDefault(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)0.0, (Object)0.0, (Object)Temperature.Units.MC));
            double biomeTemp = CSMath.averagePair((Pair<? extends Number, ? extends Number>)Pair.of((Object)((Double)cTemp.getA()), (Object)((Double)cTemp.getB()))) + CSMath.averagePair((Pair<? extends Number, ? extends Number>)Pair.of((Object)((Double)cOffset.getA()), (Object)((Double)cOffset.getB())));
            biomeTempTotal += biomeTemp;
            ++caveBiomeCount;
        }
        if (depthTable.isEmpty() && caveBiomeCount == 0) {
            return temp -> temp;
        }
        int finalCaveBiomeCount = caveBiomeCount;
        double biomeTempAvg = biomeTempTotal / (double)Math.max(1, caveBiomeCount);
        int skylight = entity.f_19853_.m_45517_(LightLayer.SKY, entity.m_20183_());
        return temp -> {
            ArrayList depthTemps = new ArrayList();
            for (Pair pair : depthTable) {
                DepthTempData tempData;
                BlockPos.MutableBlockPos pos = ((BlockPos)pair.getFirst()).m_122032_();
                double distance = (Double)pair.getSecond();
                pos.m_122184_(0, skylight - 4, 0);
                Double depthTemp = null;
                Iterator<DepthTempData> iterator = ConfigSettings.DEPTH_REGIONS.get().iterator();
                while (iterator.hasNext() && (depthTemp = (tempData = iterator.next()).getTemperature((double)temp, (BlockPos)pos, level)) == null) {
                }
                if (depthTemp == null) continue;
                double weight = 1.0 / (distance + 1.0);
                depthTemps.add(new Pair((Object)depthTemp, (Object)weight));
            }
            if (depthTemps.isEmpty()) {
                return temp;
            }
            double weightedDepthTemp = CSMath.weightedAverage(depthTemps);
            return CSMath.blend(weightedDepthTemp, biomeTempAvg, (double)finalCaveBiomeCount, 0.0, (double)depthTable.size());
        };
    }
}

