/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.event.common.TempModifierEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.util.Temperature;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class TempModifier {
    private CompoundTag nbt = new CompoundTag();
    private int expireTicks = -1;
    private int ticksExisted = 0;
    private int tickRate = 1;
    private double lastInput = 0.0;
    private double lastOutput = 0.0;
    private Function<Double, Double> function = temp -> temp;

    protected abstract Function<Double, Double> calculate(LivingEntity var1, Temperature.Trait var2);

    public final double update(double temp, LivingEntity entity, Temperature.Trait trait) {
        TempModifierEvent.Calculate.Override override = new TempModifierEvent.Calculate.Override(this, entity, temp, trait);
        MinecraftForge.EVENT_BUS.post((Event)override);
        if (override.isCanceled()) {
            this.function = t -> override.getTemperature();
            return override.getTemperature();
        }
        TempModifierEvent.Calculate.Modify modify = new TempModifierEvent.Calculate.Modify(this, entity, override.getTemperature(), this.calculate(entity, trait), trait);
        MinecraftForge.EVENT_BUS.post((Event)modify);
        this.function = modify.getFunction();
        return this.apply(modify.getTemperature());
    }

    public final double apply(double temp) {
        this.lastInput = temp;
        this.lastOutput = this.function.apply(temp);
        return this.lastOutput;
    }

    public final TempModifier expires(int ticks) {
        this.expireTicks = ticks;
        return this;
    }

    public final int getExpireTime() {
        return this.expireTicks;
    }

    public final int getTicksExisted() {
        return this.ticksExisted;
    }

    public final int setTicksExisted(int ticks) {
        this.ticksExisted = ticks;
        return this.ticksExisted;
    }

    public final TempModifier tickRate(int ticks) {
        this.tickRate = Math.max(1, ticks);
        return this;
    }

    public final int getTickRate() {
        return this.tickRate;
    }

    public final double getLastInput() {
        return this.lastInput;
    }

    public final double getLastOutput() {
        return this.lastOutput;
    }

    public final CompoundTag getNBT() {
        return this.nbt;
    }

    public void setNBT(CompoundTag data) {
        this.nbt = data;
    }

    public String toString() {
        return TempModifierRegistry.getKey(this).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TempModifier)) return false;
        TempModifier mod = (TempModifier)obj;
        if (!this.getClass().equals(mod.getClass())) return false;
        if (!mod.getNBT().equals((Object)this.getNBT())) return false;
        return true;
    }
}

