/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Triplet;

public class BlockTempModifier
extends TempModifier {
    Map<ChunkPos, ChunkAccess> chunks = new FastMap<ChunkPos, ChunkAccess>(16);

    public BlockTempModifier() {
    }

    public BlockTempModifier(int range) {
        this.getNBT().m_128405_("RangeOverride", range);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        FastMap<BlockTemp, Double> blockTempEffects = new FastMap<BlockTemp, Double>(128);
        FastMap<BlockPos, BlockState> stateCache = new FastMap<BlockPos, BlockState>(4096);
        ArrayList<Triplet> triggers = new ArrayList<Triplet>(128);
        Level level = entity.f_19853_;
        int range = this.getNBT().m_128425_("RangeOverride", 3) ? this.getNBT().m_128451_("RangeOverride") : ConfigSettings.BLOCK_RANGE.get().intValue();
        int entX = entity.m_20183_().m_123341_();
        int entY = entity.m_20183_().m_123342_();
        int entZ = entity.m_20183_().m_123343_();
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        boolean shouldTickAdvancements = this.getTicksExisted() % 20 == 0;
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ChunkPos chunkPos = new ChunkPos(entX + x >> 4, entZ + z >> 4);
                ChunkAccess chunk = this.chunks.get(chunkPos);
                if (chunk == null) {
                    chunk = WorldHelper.getChunk((LevelAccessor)level, chunkPos);
                    this.chunks.put(chunkPos, chunk);
                }
                if (chunk == null) continue;
                for (int y = -range; y < range; ++y) {
                    try {
                        Collection<BlockTemp> blockTemps;
                        blockpos.m_122178_(entX + x, entY + y, entZ + z);
                        BlockState state = (BlockState)stateCache.get(blockpos);
                        if (state == null) {
                            LevelChunkSection section = WorldHelper.getChunkSection(chunk, blockpos.m_123342_());
                            state = section.m_62982_(blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF);
                            stateCache.put(blockpos.m_7949_(), state);
                        }
                        if (state.m_60767_() == Material.f_76296_ || (blockTemps = BlockTempRegistry.getBlockTempsFor(state)).isEmpty() || blockTemps.size() == 1 && blockTemps.contains(BlockTempRegistry.DEFAULT_BLOCK_TEMP) || !BlockTempModifier.areAnyBlockTempsInRange(blockTempEffects, blockTemps)) continue;
                        Vec3 pos = Vec3.m_82512_((Vec3i)blockpos);
                        Vec3 playerClosest = WorldHelper.getClosestPointOnEntity(entity, pos);
                        int[] blocks = new int[1];
                        Vec3 ray = pos.m_82546_(playerClosest);
                        Direction direction = Direction.m_122366_((double)ray.f_82479_, (double)ray.f_82480_, (double)ray.f_82481_);
                        WorldHelper.forBlocksInRay(playerClosest, pos, level, chunk, stateCache, (rayState, bpos) -> {
                            if (!bpos.equals((Object)blockpos) && WorldHelper.isSpreadBlocked((LevelAccessor)level, rayState, bpos, direction, direction)) {
                                blocks[0] = blocks[0] + 1;
                            }
                        }, 3);
                        double distance = CSMath.getDistance(playerClosest, pos);
                        for (BlockTemp blockTemp : blockTemps) {
                            double tempToAdd = blockTemp.getTemperature(level, entity, state, (BlockPos)blockpos, distance);
                            double blockTempTotal = blockTempEffects.getOrDefault(blockTemp, 0.0) + tempToAdd / (double)(blocks[0] + 1);
                            if (blockTempTotal < blockTemp.minEffect() || blockTempTotal > blockTemp.maxEffect()) continue;
                            blockTempEffects.put(blockTemp, CSMath.clamp(blockTempTotal, blockTemp.minEffect(), blockTemp.maxEffect()));
                            if (!shouldTickAdvancements) continue;
                            triggers.add(new Triplet((Object)blockpos, (Object)blockTemp, (Object)distance));
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (shouldTickAdvancements) {
                for (Triplet trigger : triggers) {
                    ModAdvancementTriggers.BLOCK_AFFECTS_TEMP.trigger(player, (BlockPos)trigger.getA(), (Double)trigger.getC(), (Double)blockTempEffects.get(trigger.getB()));
                }
            }
        }
        while (this.chunks.size() >= 16) {
            this.chunks.remove(this.chunks.keySet().iterator().next());
        }
        return temp -> {
            for (Map.Entry effect : blockTempEffects.entrySet()) {
                BlockTemp be = (BlockTemp)effect.getKey();
                double min = be.minTemperature();
                double max = be.maxTemperature();
                if (!CSMath.betweenInclusive(temp, min, max)) continue;
                temp = CSMath.clamp(temp + (Double)effect.getValue(), min, max);
            }
            return temp;
        };
    }

    private static boolean areAnyBlockTempsInRange(Map<BlockTemp, Double> blockTempEffects, Collection<BlockTemp> blockTemps) {
        boolean isInTempRange = blockTempEffects.isEmpty();
        if (!isInTempRange) {
            for (Map.Entry<BlockTemp, Double> entry : blockTempEffects.entrySet()) {
                BlockTemp key = entry.getKey();
                Double value = entry.getValue();
                if (blockTemps.contains(key) && !CSMath.betweenInclusive(value, key.minEffect(), key.maxEffect())) continue;
                isInTempRange = true;
                break;
            }
        }
        return isInTempRange;
    }
}

