/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;

public class BlockInsulationTempModifier
extends TempModifier {
    public BlockInsulationTempModifier() {
        this(0, 0);
    }

    public BlockInsulationTempModifier(int cooling, int warming) {
        this.getNBT().m_128405_("Cooling", cooling);
        this.getNBT().m_128405_("Warming", warming);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double min = ConfigSettings.MIN_TEMP.get();
        double max = ConfigSettings.MAX_TEMP.get();
        double mid = (min + max) / 2.0;
        double hearthStrength = ConfigSettings.HEARTH_STRENGTH.get();
        double cooling = (double)this.getNBT().m_128451_("Cooling") * hearthStrength;
        double warming = (double)this.getNBT().m_128451_("Warming") * hearthStrength;
        return temp -> {
            if (temp > mid) {
                return CSMath.blend(temp, mid, cooling, 0.0, 10.0);
            }
            if (temp < mid) {
                return CSMath.blend(temp, mid, warming, 0.0, 10.0);
            }
            return temp;
        };
    }
}

