/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.registry;

import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTempConfig;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTempRegistry {
    public static final LinkedList<BlockTemp> BLOCK_TEMPS = new LinkedList();
    public static final Multimap<Block, BlockTemp> MAPPED_BLOCKS = new FastMultiMap<Block, BlockTemp>();
    public static final BlockTemp DEFAULT_BLOCK_TEMP = new BlockTemp(new Block[0]){

        @Override
        public double getTemperature(Level level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
            return 0.0;
        }
    };

    public static void register(BlockTemp blockTemp) {
        blockTemp.getAffectedBlocks().forEach(block -> {
            Collection blockTemps = MAPPED_BLOCKS.get(block);
            if (!blockTemps.isEmpty()) {
                if (blockTemp instanceof BlockTempConfig) {
                    BlockTempConfig cfg = (BlockTempConfig)blockTemp;
                    for (BlockTemp temp : blockTemps) {
                        BlockTempConfig cfg2;
                        if (!(temp instanceof BlockTempConfig) || !(cfg2 = (BlockTempConfig)temp).comparePredicates(cfg)) continue;
                        ColdSweat.LOGGER.error("Skipping duplicate BlockTemp for \"{}\" as it already has one with the same predicates: \n{}", (Object)block.m_49954_().getString(), cfg2.getPredicates());
                        return;
                    }
                }
                blockTemps.add(blockTemp);
            } else {
                blockTemps.addAll(new ArrayList<BlockTemp>(List.of(blockTemp)));
            }
        });
        BLOCK_TEMPS.add(blockTemp);
    }

    public static void flush() {
        MAPPED_BLOCKS.clear();
        BLOCK_TEMPS.clear();
    }

    public static Collection<BlockTemp> getBlockTempsFor(BlockState blockstate) {
        if (blockstate.m_60795_()) {
            return List.of(DEFAULT_BLOCK_TEMP);
        }
        Block block = blockstate.m_60734_();
        ArrayList<BlockTemp> blockTemps = MAPPED_BLOCKS.get((Object)block);
        if (blockTemps.isEmpty()) {
            blockTemps = new ArrayList<BlockTemp>(BLOCK_TEMPS.stream().filter(bt -> bt.hasBlock(block)).toList());
            if (blockTemps.isEmpty()) {
                blockTemps.add(DEFAULT_BLOCK_TEMP);
            }
            MAPPED_BLOCKS.putAll((Object)block, blockTemps);
            return blockTemps;
        }
        return blockTemps;
    }
}

