/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation.slot;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public abstract class ScalingFormula {
    Type scaling;

    protected ScalingFormula(Type scaling) {
        this.scaling = scaling;
    }

    public abstract int getSlots(EquipmentSlot var1, ItemStack var2);

    public abstract List<? extends Number> getValues();

    public Type getType() {
        return this.scaling;
    }

    public static enum Type implements StringRepresentable
    {
        STATIC("static"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown insulation scaling: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(Type::byName, Type::m_7912_);
        }
    }

    public static class Dynamic
    extends ScalingFormula {
        double factor;
        double max;

        public Dynamic(Type scaling, double factor, double max) {
            super(scaling);
            this.factor = factor;
            this.max = max;
        }

        @Override
        public int getSlots(EquipmentSlot slot, ItemStack stack) {
            double protection = stack.m_41638_(slot).get((Object)Attributes.f_22284_).stream().findFirst().map(mod -> mod.m_22218_()).orElse(0.0);
            return switch (this.scaling) {
                case Type.LINEAR -> (int)CSMath.clamp(Math.floor(protection * this.factor), 0.0, this.max);
                case Type.EXPONENTIAL -> (int)CSMath.clamp(Math.floor(Math.pow(protection, this.factor)), 0.0, this.max);
                case Type.LOGARITHMIC -> (int)CSMath.clamp(Math.floor(Math.sqrt(protection) * this.factor), 0.0, this.max);
                default -> 0;
            };
        }

        @Override
        public List<? extends Number> getValues() {
            return List.of(Double.valueOf(this.factor), Double.valueOf(this.max));
        }
    }

    public static class Static
    extends ScalingFormula {
        Map<EquipmentSlot, Integer> slots = new EnumMap<EquipmentSlot, Integer>(EquipmentSlot.class);

        public Static(int head, int body, int legs, int feet) {
            super(Type.STATIC);
            this.slots.put(EquipmentSlot.HEAD, head);
            this.slots.put(EquipmentSlot.CHEST, body);
            this.slots.put(EquipmentSlot.LEGS, legs);
            this.slots.put(EquipmentSlot.FEET, feet);
        }

        @Override
        public int getSlots(EquipmentSlot slot, ItemStack stack) {
            return this.slots.getOrDefault(slot, 0);
        }

        @Override
        public List<? extends Number> getValues() {
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(0, this.slots.get(EquipmentSlot.HEAD));
            values.add(1, this.slots.get(EquipmentSlot.CHEST));
            values.add(2, this.slots.get(EquipmentSlot.LEGS));
            values.add(3, this.slots.get(EquipmentSlot.FEET));
            return values;
        }
    }
}

