/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.world;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.BlockDataUpdateMessage;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.core.network.message.PlaySoundMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncForgeDataMessage;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class WorldHelper {
    public static int getHeight(BlockPos pos, Level level) {
        int seaLevel = level.m_5736_();
        if (!level.m_46749_(pos)) {
            return seaLevel;
        }
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, pos);
        if (chunk == null) {
            return seaLevel;
        }
        return chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_() & 0xF, pos.m_123343_() & 0xF);
    }

    public static ResourceLocation getBiomeID(Biome biome) {
        ResourceLocation biomeID = ForgeRegistries.BIOMES.getKey((Object)biome);
        if (biomeID == null) {
            biomeID = WorldHelper.getRegistry(Registry.f_122885_).m_7981_((Object)biome);
        }
        return biomeID;
    }

    public static Biome getBiome(ResourceLocation biomeID) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeID);
        if (biome == null) {
            biome = (Biome)WorldHelper.getRegistry(Registry.f_122885_).m_7745_(biomeID);
        }
        return biome;
    }

    public static ResourceLocation getDimensionTypeID(DimensionType dimType) {
        return WorldHelper.getRegistry(Registry.f_122818_).m_7981_((Object)dimType);
    }

    public static DimensionType getDimensionType(ResourceLocation dimID) {
        return (DimensionType)WorldHelper.getRegistry(Registry.f_122818_).m_7745_(dimID);
    }

    public static List<BlockPos> getPositionGrid(BlockPos pos, int samples, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int sampleRoot = (int)Math.sqrt(samples);
        int radius = sampleRoot * interval / 2;
        for (int x = -radius; x < radius; x += interval) {
            for (int z = -radius; z < radius; z += interval) {
                posList.add(pos.m_7918_(x + interval / 2, 0, z + interval / 2));
            }
        }
        return posList;
    }

    public static List<BlockPos> getPositionCube(BlockPos pos, int size, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int radius = size * interval / 2;
        for (int x = -radius; x < radius; x += interval) {
            for (int y = -radius; y < radius; y += interval) {
                for (int z = -radius; z < radius; z += interval) {
                    posList.add(pos.m_7918_(x + interval / 2, y + interval / 2, z + interval / 2));
                }
            }
        }
        return posList;
    }

    public static boolean canSeeSky(LevelAccessor level, BlockPos pos, int maxDistance) {
        BlockPos.MutableBlockPos pos2 = pos.m_122032_();
        int iterations = Math.min(maxDistance, level.m_151558_() - pos.m_123342_());
        ChunkAccess chunk = WorldHelper.getChunk(level, pos);
        if (chunk == null) {
            return true;
        }
        for (int i = 0; i < iterations; ++i) {
            BlockState state = chunk.m_8055_((BlockPos)pos2);
            VoxelShape shape = state.m_60651_((BlockGetter)level, pos, CollisionContext.m_82749_());
            if (Block.m_49916_((VoxelShape)shape)) {
                return false;
            }
            if (WorldHelper.isFullSide(CSMath.flattenShape(Direction.Axis.Y, shape), Direction.UP)) {
                return false;
            }
            pos2.m_122184_(0, 1, 0);
        }
        return true;
    }

    public static boolean isSpreadBlocked(LevelAccessor level, BlockState state, BlockPos pos, Direction toDir, Direction fromDir) {
        Block block = state.m_60734_();
        if (state.m_60795_() || ConfigSettings.HEARTH_SPREAD_WHITELIST.get().contains(block) || block == ModBlocks.HEARTH_BOTTOM || block == ModBlocks.HEARTH_TOP) {
            return false;
        }
        if (ConfigSettings.HEARTH_SPREAD_BLACKLIST.get().contains(block)) {
            return true;
        }
        VoxelShape shape = state.m_60651_((BlockGetter)level, pos, CollisionContext.m_82749_());
        if (Block.m_49916_((VoxelShape)shape)) {
            return true;
        }
        return WorldHelper.isFullSide(shape.m_83263_(fromDir.m_122424_()), fromDir) || WorldHelper.isFullSide(CSMath.flattenShape(toDir.m_122434_(), shape), toDir);
    }

    public static boolean isFullSide(VoxelShape shape, Direction dir) {
        if (shape.m_83281_()) {
            return false;
        }
        double[] area = new double[1];
        switch (dir.m_122434_()) {
            case X: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(y2 - y1) * Math.abs(z2 - z1);
                });
                break;
            }
            case Y: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(z2 - z1);
                });
                break;
            }
            case Z: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(y2 - y1);
                });
            }
        }
        return area[0] >= 1.0;
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, BlockPos pos) {
        return WorldHelper.getChunk(level, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, ChunkPos pos) {
        return WorldHelper.getChunk(level, pos.f_45578_, pos.f_45579_);
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, int chunkX, int chunkZ) {
        return level.m_7726_().m_7131_(chunkX, chunkZ);
    }

    public static LevelChunkSection getChunkSection(ChunkAccess chunk, int y) {
        LevelChunkSection[] sections = chunk.m_7103_();
        return sections[CSMath.clamp(chunk.m_151564_(y), 0, sections.length - 1)];
    }

    @Nullable
    public static Structure getStructureAt(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        StructureManager structureManager = serverLevel.m_215010_();
        for (Map.Entry entry : structureManager.m_220522_(pos).entrySet()) {
            Structure structure = (Structure)entry.getKey();
            LongSet strucCoordinates = (LongSet)entry.getValue();
            LongIterator longIterator = strucCoordinates.iterator();
            while (longIterator.hasNext()) {
                long coordinate = (Long)longIterator.next();
                SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)new ChunkPos(coordinate), (int)level.m_151560_());
                StructureStart structurestart = structureManager.m_220512_(sectionpos, structure, (StructureAccess)level.m_46819_(sectionpos.m_123170_(), sectionpos.m_123222_(), ChunkStatus.f_62315_));
                if (structurestart == null || !structurestart.m_73603_() || !structureManager.m_220497_(pos, structurestart)) continue;
                return structure;
            }
        }
        return null;
    }

    public static void playEntitySound(SoundEvent sound, Entity entity, SoundSource source, float volume, float pitch) {
        if (!entity.m_20067_()) {
            if (entity.f_19853_.f_46443_) {
                ClientOnlyHelper.playEntitySound(sound, source, volume, pitch, entity);
            } else {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new PlaySoundMessage(ForgeRegistries.SOUND_EVENTS.getKey((Object)sound).toString(), source, volume, pitch, entity.m_19879_()));
            }
        }
    }

    public static boolean isInWater(Entity entity) {
        BlockPos pos = entity.m_20183_();
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)entity.f_19853_, pos);
        if (chunk == null) {
            return false;
        }
        return entity.m_20069_() || chunk.m_8055_(pos).m_60734_() == Blocks.f_50628_;
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        DynamicHolder<Biome> biome = DynamicHolder.create(() -> (Biome)level.m_7062_().m_204214_(pos).m_203334_());
        return level.m_46471_() && biome.get().m_47530_() == Biome.Precipitation.RAIN && biome.get().m_198906_(pos) && WorldHelper.canSeeSky((LevelAccessor)level, pos.m_7494_(), 256) || CompatManager.isRainingAt(level, pos);
    }

    public static void forBlocksInRay(Vec3 from, Vec3 to, Level level, ChunkAccess chunk, Map<BlockPos, BlockState> stateCache, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        block5: {
            if (from.equals((Object)to)) break block5;
            Vec3 ray = to.m_82546_(from);
            Vec3 normalRay = ray.m_82541_();
            BlockPos.MutableBlockPos pos = new BlockPos(from).m_122032_();
            ChunkAccess workingChunk = chunk;
            int i = 0;
            while ((double)i < ray.m_82553_()) {
                block6: {
                    BlockState state;
                    block7: {
                        Vec3 vec = from.m_82549_(normalRay.m_82490_((double)i));
                        if (new BlockPos(vec).equals((Object)pos)) break block6;
                        pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                        state = stateCache.get(pos);
                        if (state != null) break block7;
                        if (workingChunk == null || !workingChunk.m_7697_().equals((Object)new ChunkPos((BlockPos)pos))) {
                            workingChunk = WorldHelper.getChunk((LevelAccessor)level, (BlockPos)pos);
                        }
                        if (workingChunk == null) break block6;
                        state = workingChunk.m_8055_((BlockPos)pos);
                        stateCache.put(pos.m_7949_(), state);
                    }
                    if (!state.m_60795_() && --maxHits <= 0) break;
                    rayTracer.accept(state, (BlockPos)pos);
                }
                ++i;
            }
        }
    }

    public static Entity raycastEntity(Vec3 from, Vec3 to, Level level, Predicate<Entity> filter) {
        if (!from.equals((Object)to)) {
            Vec3 ray = to.m_82546_(from);
            Vec3 normalRay = ray.m_82541_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i < ray.m_82553_()) {
                Vec3 vec = from.m_82549_(normalRay.m_82490_((double)i));
                if (!new BlockPos(vec).equals((Object)pos)) {
                    pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                    List entities = level.m_6443_(Entity.class, new AABB((BlockPos)pos), filter);
                    if (!entities.isEmpty()) {
                        return (Entity)entities.get(0);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void spawnParticle(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (!level.f_46443_) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)WorldHelper.getChunk((LevelAccessor)level, (int)x >> 4, (int)z >> 4)), (Object)particles);
        } else {
            level.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticleBatch(Level level, ParticleOptions particle, double x, double y, double z, double xSpread, double ySpread, double zSpread, double count, double speed) {
        Random rand = new Random();
        if (!level.f_46443_) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            int i = 0;
            while ((double)i < count) {
                Vec3 vec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_().m_82490_(speed);
                particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.f_82479_, vec.f_82480_, vec.f_82481_));
                ++i;
            }
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)particles);
        } else {
            int i = 0;
            while ((double)i < count) {
                Vec3 vec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_().m_82490_(speed);
                level.m_7106_(particle, x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.f_82479_, vec.f_82480_, vec.f_82481_);
                ++i;
            }
        }
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack) {
        return WorldHelper.entityDropItem(entity, stack, 6000);
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = entity.m_5552_(stack, entity.m_20206_());
        if (item != null) {
            item.m_20256_(item.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            Field age = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"f_31985_");
            age.setAccessible(true);
            try {
                age.set(item, 6000 - lifeTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    public static void syncEntityForgeData(Entity entity, ServerPlayer destination) {
        ColdSweatPacketHandler.INSTANCE.send(destination != null ? PacketDistributor.PLAYER.with(() -> destination) : PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncForgeDataMessage(entity));
    }

    public static void syncBlockEntityData(BlockEntity be) {
        if (be.m_58904_() == null || be.m_58904_().f_46443_) {
            return;
        }
        ChunkAccess ichunk = WorldHelper.getChunk((LevelAccessor)be.m_58904_(), be.m_58899_());
        if (ichunk instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)ichunk;
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new BlockDataUpdateMessage(be));
        }
    }

    public static ServerLevel getServerLevel(Level level) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(level.m_46472_());
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> registry) {
        return WorldHelper.getServer().m_206579_().m_175515_(registry);
    }
}

