/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.util.exceptions.SerializationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;

public class DynamicHolder<T> {
    private T value;
    private final Supplier<T> valueCreator;
    private Function<T, CompoundTag> encoder;
    private Function<CompoundTag, T> decoder;
    private Consumer<T> saver;
    private boolean synced = false;

    public DynamicHolder(Supplier<T> valueCreator) {
        this.valueCreator = valueCreator;
    }

    public static <V> DynamicHolder<V> create(Supplier<V> valueCreator) {
        return new DynamicHolder<V>(valueCreator);
    }

    public static <V> DynamicHolder<V> createSynced(Supplier<V> valueCreator, Function<V, CompoundTag> encoder, Function<CompoundTag, V> decoder, Consumer<V> saver) {
        DynamicHolder<V> loader = new DynamicHolder<V>(valueCreator);
        loader.encoder = encoder;
        loader.decoder = decoder;
        loader.saver = saver;
        loader.synced = true;
        return loader;
    }

    public T get() {
        if (this.value == null) {
            this.load();
        }
        return this.value;
    }

    public void set(Object value) {
        if (!this.value.getClass().isInstance(value)) {
            throw new ClassCastException(String.format("Cannot cast value of type %s to DynamicHolder of type %s", value.getClass(), this.value.getClass()));
        }
        this.value = value;
    }

    public void load() {
        this.value = this.valueCreator.get();
    }

    public CompoundTag encode() {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Tried to encode non-synced DynamicHolder", null));
        }
        try {
            return this.encoder.apply(this.get());
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Failed to encode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void decode(CompoundTag tag) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to decode non-synced DynamicHolder", null));
        }
        try {
            this.value = this.decoder.apply(tag);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to decode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void save() {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to save non-synced DynamicHolder", null));
        }
        try {
            this.saver.accept(this.get());
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to save DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public boolean isSynced() {
        return this.synced;
    }
}

