/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.event.capability.EntityTempManager;
import com.momosoftworks.coldsweat.common.event.capability.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public class MixinItemTooltip {
    private static List<Component> TOOLTIP = null;
    private static Map.Entry<Attribute, AttributeModifier> ENTRY = null;
    private static AttributeModifier MODIFIER = null;

    @Inject(method={"getTooltipLines"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack$TooltipPart;MODIFIERS:Lnet/minecraft/world/item/ItemStack$TooltipPart;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectBeforeAttributes(Player player, TooltipFlag advanced, CallbackInfoReturnable<List<Component>> cir, List<Component> tooltip) {
        ItemStack stack = (ItemStack)this;
        Optional.ofNullable(ConfigSettings.INSULATION_ITEMS.get().get(stack.m_41720_())).ifPresent(insulator -> {
            if (insulator.test((Entity)Minecraft.m_91087_().f_91074_, stack) && !insulator.attributes().getMap().isEmpty()) {
                tooltip.add(CommonComponents.f_237098_);
                tooltip.add((Component)Component.m_237115_((String)"item.modifiers.insulation").m_130940_(ChatFormatting.GRAY));
                TooltipHandler.addModifierTooltipLines(tooltip, insulator.attributes());
            }
        });
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    private Multimap<Attribute, AttributeModifier> getItemAttributes(ItemStack stack, EquipmentSlot slot) {
        if (LivingEntity.m_147233_((ItemStack)stack) != slot) {
            return stack.m_41638_(slot);
        }
        HashMultimap map = HashMultimap.create((Multimap)stack.m_41638_(slot));
        Optional.ofNullable(ConfigSettings.INSULATING_ARMORS.get().get(stack.m_41720_())).ifPresent(arg_0 -> MixinItemTooltip.lambda$getItemAttributes$1(stack, (Multimap)map, arg_0));
        ItemInsulationManager.getInsulationCap(stack).ifPresent(arg_0 -> MixinItemTooltip.lambda$getItemAttributes$4((Multimap)map, arg_0));
        return map;
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")}, slice={@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9))}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setupCustomAttributeDisplay(Player pPlayer, TooltipFlag pIsAdvanced, CallbackInfoReturnable<List<Component>> cir, List<Component> tooltip, MutableComponent name, int hideFlags, EquipmentSlot[] var6, int var7, int var8, EquipmentSlot equipmentslot, Multimap<Attribute, AttributeModifier> attributeMap, Iterator<AttributeModifier> entryIterator, Map.Entry<Attribute, AttributeModifier> entry, AttributeModifier modifier, double d0, boolean flag, double d1) {
        TOOLTIP = tooltip;
        ENTRY = entry;
        MODIFIER = modifier;
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9)))
    private <E> E stopCustomAttributeVanilla(E obj) {
        if (obj instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)obj;
            List siblings = component.m_7360_();
            if (TOOLTIP != null && ENTRY != null && MODIFIER != null && EntityTempManager.isTemperatureAttribute(ENTRY.getKey())) {
                MutableComponent newline = TooltipHandler.getFormattedAttributeModifier(ENTRY.getKey(), MODIFIER.m_22218_(), MODIFIER.m_22217_());
                for (Component sibling : siblings) {
                    newline = newline.m_7220_(sibling);
                }
                return (E)newline;
            }
        }
        return obj;
    }

    private static /* synthetic */ void lambda$getItemAttributes$4(Multimap map, IInsulatableCap cap) {
        cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> Optional.ofNullable(ConfigSettings.INSULATION_ITEMS.get().get(item.m_41720_())).ifPresent(insulator -> {
            if (insulator.test((Entity)Minecraft.m_91087_().f_91074_, (ItemStack)item)) {
                map.putAll(insulator.attributes().getMap());
            }
        }));
    }

    private static /* synthetic */ void lambda$getItemAttributes$1(ItemStack stack, Multimap map, Insulator insulator) {
        if (insulator.test((Entity)Minecraft.m_91087_().f_91074_, stack)) {
            map.putAll(insulator.attributes().getMap());
        }
    }
}

