/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.HandleSoulLampAnim;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class MixinHumanoidModel {
    HumanoidModel model = (HumanoidModel)this;
    @Final
    @Shadow
    public ModelPart f_102811_;
    @Final
    @Shadow
    public ModelPart f_102812_;

    @Inject(method={"poseRightArm"}, at={@At(value="TAIL")})
    public void poseRightArm(LivingEntity entity, CallbackInfo ci) {
        boolean holdingLamp = EntityHelper.holdingLamp(entity, HumanoidArm.RIGHT);
        Pair<Float, Float> armRot = HandleSoulLampAnim.RIGHT_ARM_ROTATIONS.getOrDefault(entity, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        float rightArmRot = CSMath.toRadians(CSMath.blend(((Float)armRot.getSecond()).floatValue(), ((Float)armRot.getFirst()).floatValue(), Minecraft.m_91087_().m_91296_(), 0.0f, 1.0f));
        if (!CSMath.betweenInclusive(rightArmRot, -0.01, 0.01)) {
            switch (this.model.f_102816_) {
                case EMPTY: {
                    this.f_102811_.f_104203_ -= rightArmRot;
                    this.f_102811_.f_104205_ = this.f_102811_.f_104205_ - (holdingLamp ? 0.05f : 0.0f);
                    this.f_102811_.f_104204_ = 0.0f;
                    break;
                }
                case ITEM: {
                    this.f_102811_.f_104203_ = (holdingLamp ? this.f_102811_.f_104203_ * 0.15f - 0.35f : this.f_102811_.f_104203_) - rightArmRot;
                    this.f_102811_.f_104205_ = this.f_102811_.f_104205_ - (holdingLamp ? 0.05f : 0.0f);
                    this.f_102811_.f_104204_ = 0.0f;
                }
            }
        }
    }

    @Inject(method={"poseLeftArm"}, at={@At(value="TAIL")})
    public void poseLeftArm(LivingEntity entity, CallbackInfo ci) {
        boolean holdingLamp = EntityHelper.holdingLamp(entity, HumanoidArm.LEFT);
        Pair<Float, Float> armRot = HandleSoulLampAnim.LEFT_ARM_ROTATIONS.getOrDefault(entity, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        float leftArmRot = CSMath.blend(CSMath.toRadians(((Float)armRot.getSecond()).floatValue()), CSMath.toRadians(((Float)armRot.getFirst()).floatValue()), Minecraft.m_91087_().m_91296_(), 0.0f, 1.0f);
        if (!CSMath.betweenInclusive(leftArmRot, -0.01, 0.01)) {
            switch (this.model.f_102815_) {
                case EMPTY: {
                    this.f_102812_.f_104203_ -= leftArmRot;
                    this.f_102812_.f_104205_ = this.f_102812_.f_104205_ + (holdingLamp ? 0.05f : 0.0f);
                    this.f_102812_.f_104204_ = 0.0f;
                    break;
                }
                case ITEM: {
                    this.f_102812_.f_104203_ = (holdingLamp ? this.f_102812_.f_104203_ * 0.15f - 0.35f : this.f_102812_.f_104203_) - leftArmRot;
                    this.f_102812_.f_104205_ = this.f_102812_.f_104205_ + (holdingLamp ? 0.05f : 0.0f);
                    this.f_102812_.f_104204_ = 0.0f;
                }
            }
        }
    }
}

