/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.configuration;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeCodecs;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public record InsulatorData(Insulation.Slot slot, Insulation insulation, ItemRequirement data, EntityRequirement predicate, Optional<AttributeModifierMap> attributes, Optional<List<String>> requiredMods) implements NbtSerializable
{
    public static final Codec<InsulatorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Insulation.Slot.CODEC.fieldOf("type").forGetter(InsulatorData::slot), (App)Codec.either(StaticInsulation.CODEC, AdaptiveInsulation.CODEC).xmap(either -> either.left().isPresent() ? (Insulation)either.left().get() : (Insulation)either.right().get(), insulation -> {
        if (insulation instanceof StaticInsulation) {
            return Either.left((Object)((StaticInsulation)insulation));
        }
        if (insulation instanceof AdaptiveInsulation) {
            return Either.right((Object)((AdaptiveInsulation)insulation));
        }
        return null;
    }).fieldOf("insulation").forGetter(InsulatorData::insulation), (App)ItemRequirement.CODEC.fieldOf("data").forGetter(InsulatorData::data), (App)EntityRequirement.getCodec().optionalFieldOf("predicate", (Object)EntityRequirement.NONE).forGetter(InsulatorData::predicate), (App)AttributeModifierMap.CODEC.optionalFieldOf("attributes").forGetter(InsulatorData::attributes), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(InsulatorData::requiredMods)).apply((Applicative)instance, InsulatorData::new));

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ListTag items = new ListTag();
        ListTag tags = new ListTag();
        tag.m_128365_("items", (Tag)items);
        tag.m_128365_("tags", (Tag)tags);
        tag.m_128359_("type", this.slot.name());
        tag.m_128365_("insulation", (Tag)this.insulation.serialize());
        tag.m_128365_("data", (Tag)this.data.serialize());
        tag.m_128365_("predicate", (Tag)this.predicate.serialize());
        if (this.attributes.isPresent()) {
            Multimap<Attribute, AttributeModifier> attributes1 = this.attributes.get().getMap();
            CompoundTag attributesTag = new CompoundTag();
            attributes1.forEach((attribute, modifier) -> attributesTag.m_128365_(ForgeRegistries.ATTRIBUTES.getKey(attribute).toString(), (Tag)AttributeCodecs.MODIFIER_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, modifier).result().orElseThrow()));
            tag.m_128365_("attributes", (Tag)attributesTag);
        }
        ListTag mods = new ListTag();
        this.requiredMods.ifPresent(mods1 -> mods1.forEach(mod -> mods.add((Object)StringTag.m_129297_((String)mod))));
        tag.m_128365_("required_mods", (Tag)mods);
        return tag;
    }

    public static InsulatorData deserialize(CompoundTag nbt) {
        Insulation.Slot slot = Insulation.Slot.valueOf(nbt.m_128461_("type"));
        Insulation insulation = Insulation.deserialize(nbt.m_128469_("insulation"));
        ItemRequirement requirement = ItemRequirement.deserialize(nbt.m_128469_("data"));
        EntityRequirement predicate = EntityRequirement.deserialize(nbt.m_128469_("predicate"));
        Optional<AttributeModifierMap> attributes = Optional.of(nbt.m_128469_("attributes")).map(attributesTag -> {
            HashMap attributes1 = new HashMap();
            attributesTag.m_128431_().forEach(key -> {
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(key));
                AttributeModifier modifier = (AttributeModifier)((Pair)AttributeCodecs.MODIFIER_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)attributesTag.m_128423_(key)).result().orElseThrow()).getFirst();
                attributes1.put(attribute, modifier);
            });
            return attributes1;
        }).map(AttributeModifierMap::new);
        Optional<List<String>> mods = Optional.of(nbt.m_128437_("required_mods", 8)).map(listTag -> {
            ArrayList<String> mods1 = new ArrayList<String>();
            for (int i = 0; i < listTag.size(); ++i) {
                mods1.add(listTag.m_128778_(i));
            }
            return mods1;
        });
        return new InsulatorData(slot, insulation, requirement, predicate, attributes, mods);
    }
}

