/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.requirement.EffectsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityFlagsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EquipmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.PlayerDataRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record EntityRequirement(Optional<EntityType<?>> type, Optional<LocationRequirement> location, Optional<LocationRequirement> steppingOn, Optional<EffectsRequirement> effects, Optional<NbtRequirement> nbt, Optional<EntityFlagsRequirement> flags, Optional<EquipmentRequirement> equipment, Optional<PlayerDataRequirement> playerData, Optional<EntityRequirement> vehicle, Optional<EntityRequirement> passenger, Optional<EntityRequirement> target) {
    public static EntityRequirement NONE = new EntityRequirement(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static Codec<EntityRequirement> SIMPLE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().optionalFieldOf("type").forGetter(requirement -> requirement.type), (App)LocationRequirement.CODEC.optionalFieldOf("location").forGetter(requirement -> requirement.location), (App)LocationRequirement.CODEC.optionalFieldOf("stepping_on").forGetter(requirement -> requirement.steppingOn), (App)EffectsRequirement.CODEC.optionalFieldOf("effects").forGetter(requirement -> requirement.effects), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(requirement -> requirement.nbt), (App)EntityFlagsRequirement.CODEC.optionalFieldOf("flags").forGetter(requirement -> requirement.flags), (App)EquipmentRequirement.CODEC.optionalFieldOf("equipment").forGetter(requirement -> requirement.equipment)).apply((Applicative)instance, (type, location, standingOn, effects, nbt, flags, equipment) -> new EntityRequirement((Optional<EntityType<?>>)type, (Optional<LocationRequirement>)location, (Optional<LocationRequirement>)standingOn, (Optional<EffectsRequirement>)effects, (Optional<NbtRequirement>)nbt, (Optional<EntityFlagsRequirement>)flags, (Optional<EquipmentRequirement>)equipment, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())));
    private static final List<Codec<EntityRequirement>> REQUIREMENT_CODEC_STACK = new ArrayList<Codec<EntityRequirement>>(List.of(SIMPLE_CODEC));

    public static Codec<EntityRequirement> getCodec() {
        return REQUIREMENT_CODEC_STACK.get(REQUIREMENT_CODEC_STACK.size() - 1);
    }

    private static void addCodecStack() {
        Codec<EntityRequirement> latestCodec = REQUIREMENT_CODEC_STACK.get(REQUIREMENT_CODEC_STACK.size() - 1);
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().optionalFieldOf("type").forGetter(requirement -> requirement.type), (App)LocationRequirement.CODEC.optionalFieldOf("location").forGetter(requirement -> requirement.location), (App)LocationRequirement.CODEC.optionalFieldOf("stepping_on").forGetter(requirement -> requirement.steppingOn), (App)EffectsRequirement.CODEC.optionalFieldOf("effects").forGetter(requirement -> requirement.effects), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(requirement -> requirement.nbt), (App)EntityFlagsRequirement.CODEC.optionalFieldOf("flags").forGetter(requirement -> requirement.flags), (App)EquipmentRequirement.CODEC.optionalFieldOf("equipment").forGetter(requirement -> requirement.equipment), (App)PlayerDataRequirement.getCodec(latestCodec).optionalFieldOf("player_data").forGetter(requirement -> requirement.playerData), (App)latestCodec.optionalFieldOf("vehicle").forGetter(requirement -> requirement.vehicle), (App)latestCodec.optionalFieldOf("passenger").forGetter(requirement -> requirement.passenger), (App)latestCodec.optionalFieldOf("target").forGetter(requirement -> requirement.target)).apply((Applicative)instance, EntityRequirement::new));
        REQUIREMENT_CODEC_STACK.add((Codec<EntityRequirement>)codec);
    }

    public boolean test(Entity entity) {
        if (entity == null) {
            return true;
        }
        if (Objects.equals(this, NONE)) {
            return true;
        }
        if (this.type.isPresent() && !this.type.get().equals((Object)entity.m_6095_())) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().test(entity.f_19853_, entity.m_20182_())) {
            return false;
        }
        if (this.steppingOn.isPresent() && !this.steppingOn.get().test(entity.f_19853_, entity.m_20182_().m_82520_(0.0, -0.5, 0.0))) {
            return false;
        }
        if (this.effects.isPresent() && !this.effects.get().test(entity)) {
            return false;
        }
        if (this.nbt.isPresent() && !this.nbt.get().test(entity)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().test(entity)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().test(entity)) {
            return false;
        }
        if (this.playerData.isPresent() && !this.playerData.get().test(entity)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().test(entity.m_20202_())) {
            return false;
        }
        if (this.passenger.isPresent() && !this.passenger.get().test(entity.m_20197_().isEmpty() ? null : (Entity)entity.m_20197_().get(0))) {
            return false;
        }
        if (this.target.isPresent()) {
            if (!(entity instanceof Monster)) {
                return false;
            }
            Monster monster = (Monster)entity;
            if (!this.target.get().test((Entity)monster.m_5448_())) {
                return false;
            }
        }
        return true;
    }

    public CompoundTag serialize() {
        try {
            CompoundTag tag = new CompoundTag();
            this.type.ifPresent(type -> tag.m_128359_("type", ForgeRegistries.ENTITY_TYPES.getKey(type).toString()));
            this.location.ifPresent(location -> tag.m_128365_("location", (Tag)location.serialize()));
            this.steppingOn.ifPresent(standingOn -> tag.m_128365_("standing_on", (Tag)standingOn.serialize()));
            this.effects.ifPresent(effects -> tag.m_128365_("effects", (Tag)effects.serialize()));
            this.nbt.ifPresent(nbt -> tag.m_128365_("nbt", (Tag)nbt.serialize()));
            this.flags.ifPresent(flags -> tag.m_128365_("flags", (Tag)flags.serialize()));
            this.equipment.ifPresent(equipment -> tag.m_128365_("equipment", (Tag)equipment.serialize()));
            this.playerData.ifPresent(playerData -> tag.m_128365_("player_data", (Tag)playerData.serialize()));
            this.vehicle.ifPresent(vehicle -> tag.m_128365_("vehicle", (Tag)vehicle.serialize()));
            this.passenger.ifPresent(passenger -> tag.m_128365_("passenger", (Tag)passenger.serialize()));
            this.target.ifPresent(target -> tag.m_128365_("target", (Tag)target.serialize()));
            return tag;
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Error serializing entity requirement: {}", (Object)e.getMessage());
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    public static EntityRequirement deserialize(CompoundTag tag) {
        try {
            Optional<EntityType<?>> type = tag.m_128441_("type") ? Optional.of((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(tag.m_128461_("type")))) : Optional.empty();
            Optional<LocationRequirement> location = tag.m_128441_("location") ? Optional.of(LocationRequirement.deserialize(tag.m_128469_("location"))) : Optional.empty();
            Optional<LocationRequirement> standingOn = tag.m_128441_("standing_on") ? Optional.of(LocationRequirement.deserialize(tag.m_128469_("standing_on"))) : Optional.empty();
            Optional<EffectsRequirement> effects = tag.m_128441_("effects") ? Optional.of(EffectsRequirement.deserialize(tag.m_128469_("effects"))) : Optional.empty();
            Optional<NbtRequirement> nbt = tag.m_128441_("nbt") ? Optional.of(NbtRequirement.deserialize(tag.m_128469_("nbt"))) : Optional.empty();
            Optional<EntityFlagsRequirement> flags = tag.m_128441_("flags") ? Optional.of(EntityFlagsRequirement.deserialize(tag.m_128469_("flags"))) : Optional.empty();
            Optional<EquipmentRequirement> equipment = tag.m_128441_("equipment") ? Optional.of(EquipmentRequirement.deserialize(tag.m_128469_("equipment"))) : Optional.empty();
            Optional<PlayerDataRequirement> playerData = tag.m_128441_("player_data") ? Optional.of(PlayerDataRequirement.deserialize(tag.m_128469_("player_data"))) : Optional.empty();
            Optional<EntityRequirement> vehicle = tag.m_128441_("vehicle") ? Optional.of(EntityRequirement.deserialize(tag.m_128469_("vehicle"))) : Optional.empty();
            Optional<EntityRequirement> passenger = tag.m_128441_("passenger") ? Optional.of(EntityRequirement.deserialize(tag.m_128469_("passenger"))) : Optional.empty();
            Optional<EntityRequirement> target = tag.m_128441_("target") ? Optional.of(EntityRequirement.deserialize(tag.m_128469_("target"))) : Optional.empty();
            return new EntityRequirement(type, location, standingOn, effects, nbt, flags, equipment, playerData, vehicle, passenger, target);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Error deserializing entity requirement: {}", (Object)e.getMessage());
            e.printStackTrace();
            return NONE;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityRequirement that = (EntityRequirement)obj;
        return this.type.equals(that.type) && this.location.equals(that.location) && this.steppingOn.equals(that.steppingOn) && this.effects.equals(that.effects) && this.nbt.equals(that.nbt) && this.flags.equals(that.flags) && this.equipment.equals(that.equipment) && this.playerData.equals(that.playerData) && this.vehicle.equals(that.vehicle) && this.passenger.equals(that.passenger) && this.target.equals(that.target);
    }

    @Override
    public String toString() {
        return "Entity{type=" + this.type + ", location=" + this.location + ", standingOn=" + this.steppingOn + ", effects=" + this.effects + ", nbt=" + this.nbt + ", flags=" + this.flags + ", equipment=" + this.equipment + ", playerData=" + this.playerData + ", vehicle=" + this.vehicle + ", passenger=" + this.passenger + ", target=" + this.target + "}";
    }

    static {
        for (int i = 0; i < 16; ++i) {
            EntityRequirement.addCodecStack();
        }
    }
}

