/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;

public record BlockRequirement(Optional<List<Block>> blocks, Optional<TagKey<Block>> tag, Optional<StateRequirement> state, Optional<NbtRequirement> nbt) {
    public static final Codec<BlockRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.BLOCKS.getCodec().listOf().optionalFieldOf("blocks").forGetter(predicate -> predicate.blocks), (App)TagKey.m_203877_((ResourceKey)Registry.f_122901_).optionalFieldOf("tag").forGetter(predicate -> predicate.tag), (App)StateRequirement.CODEC.optionalFieldOf("state").forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, BlockRequirement::new));

    public boolean test(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_46749_(pPos)) {
            return false;
        }
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (this.tag.isPresent() && !blockstate.m_204336_(this.tag.get())) {
            return false;
        }
        if (this.blocks.isPresent() && !this.blocks.get().contains(blockstate.m_60734_())) {
            return false;
        }
        if (this.state.isPresent() && !this.state.get().matches(blockstate)) {
            return false;
        }
        if (this.nbt.isPresent()) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            return blockentity != null && this.nbt.get().test((Tag)blockentity.m_187480_());
        }
        return true;
    }

    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        this.blocks.ifPresent(blocks -> compound.m_128365_("blocks", (Tag)NBTHelper.listTagOf(blocks.stream().map(block -> ForgeRegistries.BLOCKS.getKey(block).toString()).toList())));
        this.tag.ifPresent(tag -> compound.m_128359_("tag", tag.f_203868_().toString()));
        this.state.ifPresent(state -> compound.m_128365_("state", (Tag)state.serialize()));
        this.nbt.ifPresent(nbt -> compound.m_128365_("nbt", (Tag)nbt.serialize()));
        return compound;
    }

    public static BlockRequirement deserialize(CompoundTag tag) {
        Optional<List<Block>> blocks = tag.m_128441_("blocks") ? Optional.of(NBTHelper.listTagOf(tag.m_128437_("blocks", 8)).stream().map(string -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string.m_7916_()))).collect(Collectors.toList())) : Optional.empty();
        Optional<TagKey<Block>> tagKey = tag.m_128441_("tag") ? Optional.of(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(tag.m_128461_("tag")))) : Optional.empty();
        Optional<StateRequirement> state = tag.m_128441_("state") ? Optional.of(StateRequirement.deserialize(tag.m_128469_("state"))) : Optional.empty();
        Optional<NbtRequirement> nbt = tag.m_128441_("nbt") ? Optional.of(NbtRequirement.deserialize(tag.m_128469_("nbt"))) : Optional.empty();
        return new BlockRequirement(blocks, tagKey, state, nbt);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockRequirement that = (BlockRequirement)obj;
        if (!this.blocks.equals(that.blocks)) {
            return false;
        }
        if (!this.tag.equals(that.tag)) {
            return false;
        }
        if (!this.state.equals(that.state)) {
            return false;
        }
        return this.nbt.equals(that.nbt);
    }

    public record StateRequirement(List<Either<StateProperty, RangedProperty>> properties) {
        public static final Codec<StateRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(StateProperty.CODEC, RangedProperty.CODEC).listOf().fieldOf("properties").forGetter(StateRequirement::properties)).apply((Applicative)instance, StateRequirement::new));

        public CompoundTag serialize() {
            CompoundTag compound = new CompoundTag();
            ListTag list = new ListTag();
            this.properties.forEach(property -> list.add((Object)((Tag)property.map(StateProperty::serialize, RangedProperty::serialize))));
            compound.m_128365_("properties", (Tag)list);
            return compound;
        }

        public static StateRequirement deserialize(CompoundTag tag) {
            List<Either<StateProperty, RangedProperty>> properties = NBTHelper.listTagOf(tag.m_128437_("properties", 10)).stream().map(tg -> {
                CompoundTag compound = (CompoundTag)tg;
                if (compound.m_128441_("value")) {
                    return Either.left((Object)StateProperty.deserialize(compound));
                }
                return Either.right((Object)RangedProperty.deserialize(compound));
            }).toList();
            return new StateRequirement(properties);
        }

        public boolean matches(BlockState pState) {
            return this.matches(pState.m_60734_().m_49965_(), pState);
        }

        public boolean matches(FluidState pState) {
            return this.matches(pState.m_76152_().m_76144_(), pState);
        }

        public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> pProperties, S pTargetProperty) {
            for (Either<StateProperty, RangedProperty> property : this.properties) {
                if (((Boolean)property.map(stateProperty -> stateProperty.match(pProperties, pTargetProperty), rangedProperty -> rangedProperty.match(pProperties, pTargetProperty))).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StateRequirement that = (StateRequirement)obj;
            return this.properties.equals(that.properties);
        }
    }

    public record RangedProperty(String name, String min, String max) {
        public static final Codec<RangedProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(property -> property.name), (App)Codec.STRING.fieldOf("min").forGetter(property -> property.min), (App)Codec.STRING.fieldOf("max").forGetter(property -> property.max)).apply((Applicative)instance, RangedProperty::new));

        public CompoundTag serialize() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("name", this.name);
            compound.m_128359_("min", this.min);
            compound.m_128359_("max", this.max);
            return compound;
        }

        public static RangedProperty deserialize(CompoundTag tag) {
            return new RangedProperty(tag.m_128461_("name"), tag.m_128461_("min"), tag.m_128461_("max"));
        }

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> pProperties, S pTargetProperty) {
            Property property = pProperties.m_61081_(this.name);
            return property != null && this.match(pTargetProperty, property);
        }

        private <T extends Comparable<T>> boolean match(StateHolder<?, ?> pProperties, Property<T> pPropertyTarget) {
            Optional optional1;
            Optional optional;
            Comparable t = pProperties.m_61143_(pPropertyTarget);
            if (this.min != null && ((optional = pPropertyTarget.m_6215_(this.min)).isEmpty() || t.compareTo((Comparable)optional.get()) < 0)) {
                return false;
            }
            return this.max == null || !(optional1 = pPropertyTarget.m_6215_(this.max)).isEmpty() && t.compareTo((Comparable)optional1.get()) <= 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RangedProperty that = (RangedProperty)obj;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!this.min.equals(that.min)) {
                return false;
            }
            return this.max.equals(that.max);
        }
    }

    public record StateProperty(String name, String value) {
        public static final Codec<StateProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(property -> property.name), (App)Codec.STRING.fieldOf("value").forGetter(property -> property.value)).apply((Applicative)instance, StateProperty::new));

        public CompoundTag serialize() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("name", this.name);
            compound.m_128359_("value", this.value);
            return compound;
        }

        public static StateProperty deserialize(CompoundTag tag) {
            return new StateProperty(tag.m_128461_("name"), tag.m_128461_("value"));
        }

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> pProperties, S pPropertyToMatch) {
            Property property = pProperties.m_61081_(this.name);
            return property != null && this.match(pPropertyToMatch, property);
        }

        private <V extends Comparable<V>> boolean match(StateHolder<?, ?> properties, Property<V> property) {
            Comparable stateValue = properties.m_61143_(property);
            Optional propValue = property.m_6215_(this.value);
            return propValue.isPresent() && stateValue.compareTo((Comparable)propValue.get()) == 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StateProperty that = (StateProperty)obj;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.value.equals(that.value);
        }
    }
}

