/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.WorldSettingsConfig;
import com.momosoftworks.coldsweat.config.type.InsulatingMount;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.ObjectBuilder;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import oshi.util.tuples.Triplet;

public class ConfigSettings {
    public static final Map<String, DynamicHolder<?>> CONFIG_SETTINGS;
    public static Difficulty DEFAULT_DIFFICULTY;
    public static final DynamicHolder<Integer> DIFFICULTY;
    public static final DynamicHolder<Double> MAX_TEMP;
    public static final DynamicHolder<Double> MIN_TEMP;
    public static final DynamicHolder<Double> TEMP_RATE;
    public static final DynamicHolder<Double> TEMP_DAMAGE;
    public static final DynamicHolder<Boolean> FIRE_RESISTANCE_ENABLED;
    public static final DynamicHolder<Boolean> ICE_RESISTANCE_ENABLED;
    public static final DynamicHolder<Boolean> DAMAGE_SCALING;
    public static final DynamicHolder<Boolean> REQUIRE_THERMOMETER;
    public static final DynamicHolder<Integer> GRACE_LENGTH;
    public static final DynamicHolder<Boolean> GRACE_ENABLED;
    public static final DynamicHolder<Map<Biome, Triplet<Double, Double, Temperature.Units>>> BIOME_TEMPS;
    public static final DynamicHolder<Map<Biome, Triplet<Double, Double, Temperature.Units>>> BIOME_OFFSETS;
    public static final DynamicHolder<Map<DimensionType, Pair<Double, Temperature.Units>>> DIMENSION_TEMPS;
    public static final DynamicHolder<Map<DimensionType, Pair<Double, Temperature.Units>>> DIMENSION_OFFSETS;
    public static final DynamicHolder<Map<Structure, Pair<Double, Temperature.Units>>> STRUCTURE_TEMPS;
    public static final DynamicHolder<Map<Structure, Pair<Double, Temperature.Units>>> STRUCTURE_OFFSETS;
    public static final DynamicHolder<Double> CAVE_INSULATION;
    public static final DynamicHolder<Double[]> SUMMER_TEMPS;
    public static final DynamicHolder<Double[]> AUTUMN_TEMPS;
    public static final DynamicHolder<Double[]> WINTER_TEMPS;
    public static final DynamicHolder<Double[]> SPRING_TEMPS;
    public static final DynamicHolder<Integer> BLOCK_RANGE;
    public static final DynamicHolder<Boolean> COLD_SOUL_FIRE;
    public static final DynamicHolder<List<Block>> HEARTH_SPREAD_WHITELIST;
    public static final DynamicHolder<List<Block>> HEARTH_SPREAD_BLACKLIST;
    public static final DynamicHolder<Double> HEARTH_STRENGTH;
    public static final DynamicHolder<List<Block>> SLEEP_CHECK_IGNORE_BLOCKS;
    public static final DynamicHolder<Map<Item, Insulator>> INSULATION_ITEMS;
    public static final DynamicHolder<Map<Item, Insulator>> INSULATING_ARMORS;
    public static final DynamicHolder<Map<Item, Insulator>> INSULATING_CURIOS;
    public static final DynamicHolder<Integer[]> INSULATION_SLOTS;
    public static final DynamicHolder<List<Item>> INSULATION_BLACKLIST;
    public static final DynamicHolder<Boolean> CHECK_SLEEP_CONDITIONS;
    public static final DynamicHolder<Map<Item, PredicateItem>> FOOD_TEMPERATURES;
    public static final DynamicHolder<Integer> WATERSKIN_STRENGTH;
    public static final DynamicHolder<List<DimensionType>> LAMP_DIMENSIONS;
    public static final DynamicHolder<Map<Item, PredicateItem>> BOILER_FUEL;
    public static final DynamicHolder<Map<Item, PredicateItem>> ICEBOX_FUEL;
    public static final DynamicHolder<Map<Item, PredicateItem>> HEARTH_FUEL;
    public static final DynamicHolder<Map<Item, PredicateItem>> SOULSPRING_LAMP_FUEL;
    public static final DynamicHolder<Boolean> HEARTH_POTIONS_ENABLED;
    public static final DynamicHolder<List<MobEffect>> HEARTH_POTION_BLACKLIST;
    public static final DynamicHolder<Triplet<Integer, Integer, Double>> FUR_TIMINGS;
    public static final DynamicHolder<Multimap<Biome, SpawnBiomeData>> ENTITY_SPAWN_BIOMES;
    public static final DynamicHolder<Map<EntityType<?>, InsulatingMount>> INSULATED_ENTITIES;
    public static final DynamicHolder<Boolean> CELSIUS;
    public static final DynamicHolder<Integer> TEMP_OFFSET;
    public static final DynamicHolder<Double> TEMP_SMOOTHING;
    public static final DynamicHolder<Vec2i> BODY_ICON_POS;
    public static final DynamicHolder<Boolean> BODY_ICON_ENABLED;
    public static final DynamicHolder<Vec2i> BODY_READOUT_POS;
    public static final DynamicHolder<Boolean> BODY_READOUT_ENABLED;
    public static final DynamicHolder<Vec2i> WORLD_GAUGE_POS;
    public static final DynamicHolder<Boolean> WORLD_GAUGE_ENABLED;
    public static final DynamicHolder<Boolean> CUSTOM_HOTBAR_LAYOUT;
    public static final DynamicHolder<Boolean> ICON_BOBBING;
    public static final DynamicHolder<Boolean> HEARTH_DEBUG;
    public static final DynamicHolder<Boolean> SHOW_CONFIG_BUTTON;
    public static final DynamicHolder<Vec2i> CONFIG_BUTTON_POS;
    public static final DynamicHolder<Boolean> DISTORTION_EFFECTS;
    public static final DynamicHolder<Boolean> HIGH_CONTRAST;
    public static final DynamicHolder<Boolean> SHOW_CREATIVE_WARNING;

    public static <T> DynamicHolder<T> addSyncedSetting(String id, Supplier<T> supplier, Function<T, CompoundTag> writer, Function<CompoundTag, T> reader, Consumer<T> saver) {
        DynamicHolder<T> loader = DynamicHolder.createSynced(supplier, writer, reader, saver);
        CONFIG_SETTINGS.put(id, loader);
        return loader;
    }

    public static <T> DynamicHolder<T> addSetting(String id, Supplier<T> supplier) {
        DynamicHolder<T> loader = DynamicHolder.create(supplier);
        CONFIG_SETTINGS.put(id, loader);
        return loader;
    }

    public static <T> DynamicHolder<T> addClientSetting(String id, Supplier<T> supplier) {
        return FMLEnvironment.dist == Dist.CLIENT ? ConfigSettings.addSetting(id, supplier) : new DynamicHolder<T>(() -> null);
    }

    public static Map<String, CompoundTag> encode() {
        HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
        CONFIG_SETTINGS.forEach((key, value) -> {
            if (value.isSynced()) {
                map.put((String)key, value.encode());
            }
        });
        return map;
    }

    public static void decode(String key, CompoundTag tag) {
        CONFIG_SETTINGS.computeIfPresent(key, (k, value) -> {
            value.decode(tag);
            return value;
        });
    }

    public static void saveValues() {
        CONFIG_SETTINGS.values().forEach(value -> {
            if (value.isSynced()) {
                value.save();
            }
        });
    }

    public static void load() {
        CONFIG_SETTINGS.values().forEach(DynamicHolder::load);
    }

    public static Pair<Double, Double> getBiomeTemperature(Holder<Biome> biome) {
        double biomeTemp = ((Biome)biome.m_203334_()).m_47554_();
        Triplet tempConfig = CSMath.orElse(BIOME_TEMPS.get().get(biome.m_203334_()), ObjectBuilder.build(() -> {
            Triplet<Double, Double, Temperature.Units> offset = BIOME_OFFSETS.get().get(biome.m_203334_());
            if (offset == null) {
                return null;
            }
            return new Triplet((Object)(biomeTemp + (Double)offset.getA()), (Object)(biomeTemp + (Double)offset.getB()), (Object)Temperature.Units.MC);
        }), new Triplet((Object)biomeTemp, (Object)biomeTemp, (Object)Temperature.Units.MC));
        return Pair.of((Object)((Double)tempConfig.getA()), (Object)((Double)tempConfig.getB()));
    }

    private static /* synthetic */ Double[] lambda$static$177() {
        return new Double[3];
    }

    private static /* synthetic */ Double[] lambda$static$176() {
        return WorldSettingsConfig.getInstance().getSpringTemps();
    }

    private static /* synthetic */ Double[] lambda$static$175() {
        return new Double[3];
    }

    private static /* synthetic */ Double[] lambda$static$174() {
        return WorldSettingsConfig.getInstance().getWinterTemps();
    }

    private static /* synthetic */ Double[] lambda$static$173() {
        return new Double[3];
    }

    private static /* synthetic */ Double[] lambda$static$172() {
        return WorldSettingsConfig.getInstance().getAutumnTemps();
    }

    private static /* synthetic */ Double[] lambda$static$171() {
        return new Double[3];
    }

    private static /* synthetic */ Double[] lambda$static$170() {
        return WorldSettingsConfig.getInstance().getSummerTemps();
    }

    private static /* synthetic */ Boolean lambda$static$169() {
        return ClientSettingsConfig.getInstance().showCreativeWarning();
    }

    private static /* synthetic */ Boolean lambda$static$168() {
        return ClientSettingsConfig.getInstance().isHighContrast();
    }

    private static /* synthetic */ Boolean lambda$static$167() {
        return ClientSettingsConfig.getInstance().areDistortionsEnabled();
    }

    private static /* synthetic */ Vec2i lambda$static$166() {
        return new Vec2i(ClientSettingsConfig.getInstance().getConfigButtonPos().get(0), ClientSettingsConfig.getInstance().getConfigButtonPos().get(1));
    }

    private static /* synthetic */ Boolean lambda$static$165() {
        return ClientSettingsConfig.getInstance().showConfigButton();
    }

    private static /* synthetic */ Boolean lambda$static$164() {
        return ClientSettingsConfig.getInstance().isHearthDebug();
    }

    private static /* synthetic */ Boolean lambda$static$163() {
        return ClientSettingsConfig.getInstance().isIconBobbing();
    }

    private static /* synthetic */ Boolean lambda$static$162() {
        return ClientSettingsConfig.getInstance().isCustomHotbarLayout();
    }

    private static /* synthetic */ Boolean lambda$static$161() {
        return ClientSettingsConfig.getInstance().isWorldGaugeEnabled();
    }

    private static /* synthetic */ Vec2i lambda$static$160() {
        return new Vec2i(ClientSettingsConfig.getInstance().getWorldGaugeX(), ClientSettingsConfig.getInstance().getWorldGaugeY());
    }

    private static /* synthetic */ Boolean lambda$static$159() {
        return ClientSettingsConfig.getInstance().isBodyReadoutEnabled();
    }

    private static /* synthetic */ Vec2i lambda$static$158() {
        return new Vec2i(ClientSettingsConfig.getInstance().getBodyReadoutX(), ClientSettingsConfig.getInstance().getBodyReadoutY());
    }

    private static /* synthetic */ Boolean lambda$static$157() {
        return ClientSettingsConfig.getInstance().isBodyIconEnabled();
    }

    private static /* synthetic */ Vec2i lambda$static$156() {
        return new Vec2i(ClientSettingsConfig.getInstance().getBodyIconX(), ClientSettingsConfig.getInstance().getBodyIconY());
    }

    private static /* synthetic */ Double lambda$static$155() {
        return ClientSettingsConfig.getInstance().getTempSmoothing();
    }

    private static /* synthetic */ Integer lambda$static$154() {
        return ClientSettingsConfig.getInstance().getTempOffset();
    }

    private static /* synthetic */ Boolean lambda$static$153() {
        return ClientSettingsConfig.getInstance().isCelsius();
    }

    private static /* synthetic */ Double lambda$static$152() {
        return WorldSettingsConfig.getInstance().getHearthStrength();
    }

    private static /* synthetic */ void lambda$static$151(List saver) {
        WorldSettingsConfig.getInstance().setHearthSpreadBlacklist(saver.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).toList());
    }

    private static /* synthetic */ List lambda$static$150(CompoundTag decoder) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (Tag entry : decoder.m_128437_("HearthBlacklist", 8)) {
            list.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_7916_())));
        }
        return list;
    }

    private static /* synthetic */ CompoundTag lambda$static$149(List encoder) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Block entry : encoder) {
            list.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)entry).toString()));
        }
        tag.m_128365_("HearthBlacklist", (Tag)list);
        return tag;
    }

    private static /* synthetic */ List lambda$static$148() {
        return ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getHearthSpreadBlacklist().toArray(new String[0]));
    }

    private static /* synthetic */ void lambda$static$147(List saver) {
        WorldSettingsConfig.getInstance().setHearthSpreadWhitelist(saver.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).toList());
    }

    private static /* synthetic */ List lambda$static$146(CompoundTag decoder) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (Tag entry : decoder.m_128437_("HearthWhitelist", 8)) {
            list.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_7916_())));
        }
        return list;
    }

    private static /* synthetic */ CompoundTag lambda$static$145(List encoder) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Block entry : encoder) {
            list.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)entry).toString()));
        }
        tag.m_128365_("HearthWhitelist", (Tag)list);
        return tag;
    }

    private static /* synthetic */ List lambda$static$144() {
        return ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getHearthSpreadWhitelist().toArray(new String[0]));
    }

    private static /* synthetic */ Boolean lambda$static$143() {
        return WorldSettingsConfig.getInstance().isSoulFireCold();
    }

    private static /* synthetic */ void lambda$static$142(Integer saver) {
        WorldSettingsConfig.getInstance().setBlockRange(saver);
    }

    private static /* synthetic */ Integer lambda$static$141(CompoundTag decoder) {
        return decoder.m_128451_("BlockRange");
    }

    private static /* synthetic */ CompoundTag lambda$static$140(Integer encoder) {
        return ConfigHelper.serializeNbtInt(encoder, "BlockRange");
    }

    private static /* synthetic */ Integer lambda$static$139() {
        return WorldSettingsConfig.getInstance().getBlockRange();
    }

    private static /* synthetic */ Map lambda$static$138() {
        return EntitySettingsConfig.getInstance().getInsulatedEntities().stream().map(entry -> {
            ArrayList entries = new ArrayList();
            String entityID = (String)entry.get(0);
            double coldInsul = ((Number)entry.get(1)).doubleValue();
            double hotInsul = entry.size() < 3 ? coldInsul : ((Number)entry.get(2)).doubleValue();
            for (EntityType<?> entityType : ConfigHelper.getEntityTypes(entityID)) {
                entries.add(Map.entry(entityType, new InsulatingMount(entityType, coldInsul, hotInsul, EntityRequirement.NONE)));
            }
            return entries;
        }).flatMap(Collection::stream).distinct().filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
            ColdSweat.LOGGER.warn("Duplicate entity entry for \"{}\" found in config. Using the first entry.", (Object)ForgeRegistries.ENTITY_TYPES.getKey(a.entityType()).toString());
            return a;
        }));
    }

    private static /* synthetic */ Multimap lambda$static$134() {
        HashMultimap map = HashMultimap.create();
        Consumer<List> configReader = arg_0 -> ConfigSettings.lambda$static$133((Multimap)map, arg_0);
        configReader.accept(EntitySettingsConfig.getInstance().getChameleonSpawnBiomes());
        configReader.accept(EntitySettingsConfig.getInstance().getGoatSpawnBiomes());
        return map;
    }

    private static /* synthetic */ void lambda$static$133(Multimap map, List configBiomes) {
        for (List entry : configBiomes) {
            Either biomeEither;
            String biomeId = (String)entry.get(0);
            List<Biome> biomes = ConfigHelper.getBiomes(biomeId);
            if (biomeId.charAt(0) == '#') {
                biomeEither = Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(biomeId.substring(1))));
            } else {
                Biome biome = ConfigHelper.getBiome(new ResourceLocation(biomeId));
                if (biome == null) continue;
                biomeEither = Either.right((Object)biome);
            }
            for (Biome biome : biomes) {
                SpawnBiomeData spawnData = new SpawnBiomeData(List.of(biomeEither), MobCategory.CREATURE, ((Number)entry.get(1)).intValue(), List.of(Either.right(ModEntities.CHAMELEON)), Optional.empty());
                map.put((Object)biome, (Object)spawnData);
            }
        }
    }

    private static /* synthetic */ void lambda$static$132(Triplet saver) {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add((Number)saver.getA());
        list.add((Number)saver.getB());
        list.add((Number)saver.getC());
        EntitySettingsConfig.getInstance().setGoatFurStats(list);
    }

    private static /* synthetic */ Triplet lambda$static$131(CompoundTag decoder) {
        int interval = decoder.m_128451_("Interval");
        int cooldown = decoder.m_128451_("Cooldown");
        double chance = decoder.m_128459_("Chance");
        return new Triplet((Object)interval, (Object)cooldown, (Object)chance);
    }

    private static /* synthetic */ CompoundTag lambda$static$130(Triplet encoder) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Interval", (Tag)IntTag.m_128679_((int)((Integer)encoder.getA())));
        tag.m_128365_("Cooldown", (Tag)IntTag.m_128679_((int)((Integer)encoder.getB())));
        tag.m_128365_("Chance", (Tag)DoubleTag.m_128500_((double)((Double)encoder.getC())));
        return tag;
    }

    private static /* synthetic */ Triplet lambda$static$129() {
        List<?> entry = EntitySettingsConfig.getInstance().getGoatFurStats();
        return new Triplet((Object)((Number)entry.get(0)).intValue(), (Object)((Number)entry.get(1)).intValue(), (Object)((Number)entry.get(2)).doubleValue());
    }

    private static /* synthetic */ List lambda$static$128() {
        return new ArrayList(ItemSettingsConfig.getInstance().getValidSoulLampDimensions().stream().map(entry -> CSMath.getIfNotNull(WorldHelper.getServer(), server -> (DimensionType)server.m_206579_().m_175515_(Registry.f_122818_).m_7745_(new ResourceLocation(entry)), null)).collect(ArrayList::new, List::add, List::addAll));
    }

    private static /* synthetic */ Integer lambda$static$125() {
        return ItemSettingsConfig.getInstance().getWaterskinStrength();
    }

    private static /* synthetic */ void lambda$static$124(Map saver) {
        ConfigHelper.writeItemMap(saver, list -> ItemSettingsConfig.getInstance().setFoodTemperatures((List<? extends List<?>>)list), food -> List.of(food.value(), food.data().nbt().tag().toString()));
    }

    private static /* synthetic */ Map lambda$static$121(CompoundTag decoder) {
        return ConfigHelper.deserializeItemMap(decoder, "FoodTemperatures", nbt -> PredicateItem.deserialize(nbt));
    }

    private static /* synthetic */ CompoundTag lambda$static$119(Map encoder) {
        return ConfigHelper.serializeItemMap(encoder, "FoodTemperatures", food -> food.serialize());
    }

    private static /* synthetic */ Map lambda$static$117() {
        return ConfigHelper.readItemMap(ItemSettingsConfig.getInstance().getFoodTemperatures(), (item, args) -> {
            double value = ((Number)args.get(0)).doubleValue();
            NbtRequirement nbtRequirement = args.size() > 2 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)args.get(2))) : new NbtRequirement(new CompoundTag());
            ItemRequirement itemRequirement = new ItemRequirement(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbtRequirement);
            return new PredicateItem(value, itemRequirement, EntityRequirement.NONE);
        });
    }

    private static /* synthetic */ List lambda$static$115() {
        return ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getSleepOverrideBlocks().toArray(new String[0]));
    }

    private static /* synthetic */ Boolean lambda$static$114() {
        return WorldSettingsConfig.getInstance().isSleepChecked();
    }

    private static /* synthetic */ List lambda$static$113() {
        return ItemSettingsConfig.getInstance().getInsulationBlacklist().stream().map(entry -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll);
    }

    private static /* synthetic */ void lambda$static$111(Integer[] saver) {
        ItemSettingsConfig.getInstance().setArmorInsulationSlots(Arrays.asList(saver[0], saver[1], saver[2], saver[3]));
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum Difficulty {
        SUPER_EASY(Map.of("min_temp", () -> Temperature.convert(40.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(120.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 0.5, "require_thermometer", () -> false, "fire_resistance_enabled", () -> true, "ice_resistance_enabled", () -> true, "damage_scaling", () -> false)),
        EASY(Map.of("min_temp", () -> Temperature.convert(45.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(110.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 0.75, "require_thermometer", () -> false, "fire_resistance_enabled", () -> true, "ice_resistance_enabled", () -> true, "damage_scaling", () -> false)),
        NORMAL(Map.of("min_temp", () -> Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 1.0, "require_thermometer", () -> true, "fire_resistance_enabled", () -> true, "ice_resistance_enabled", () -> true, "damage_scaling", () -> true)),
        HARD(Map.of("min_temp", () -> Temperature.convert(60.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(90.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 1.5, "require_thermometer", () -> true, "fire_resistance_enabled", () -> false, "ice_resistance_enabled", () -> false, "damage_scaling", () -> true)),
        CUSTOM(Map.of());

        private final Map<String, Supplier<?>> settings;

        private Difficulty(Map<String, Supplier<?>> settings) {
            this.settings = settings;
        }

        public <T> T getSetting(String id) {
            return (T)this.settings.get(id).get();
        }

        public <T> T getOrDefault(String id, T defaultValue) {
            return (T)this.settings.getOrDefault(id, () -> defaultValue).get();
        }

        public void load() {
            this.settings.forEach((id, loader) -> CONFIG_SETTINGS.get(id).set(loader.get()));
        }
    }
}

