/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HearthSaveDataHandler {
    public static final Set<Pair<BlockPos, ResourceLocation>> HEARTH_POSITIONS = new HashSet<Pair<BlockPos, ResourceLocation>>();
    public static final Set<Pair<BlockPos, ResourceLocation>> DISABLED_HEARTHS = new HashSet<Pair<BlockPos, ResourceLocation>>();

    @SubscribeEvent
    public static void saveDisabledHearths(PlayerEvent.PlayerLoggedOutEvent event) {
        event.getEntity().getPersistentData().m_128365_("disabledHearths", (Tag)HearthSaveDataHandler.serializeDisabledHearths());
    }

    public static CompoundTag serializeDisabledHearths() {
        CompoundTag disabledHearths = new CompoundTag();
        int i = 0;
        for (Pair<BlockPos, ResourceLocation> pair : DISABLED_HEARTHS) {
            CompoundTag hearthData = new CompoundTag();
            hearthData.m_128356_("pos", ((BlockPos)pair.getFirst()).m_121878_());
            hearthData.m_128359_("level", ((ResourceLocation)pair.getSecond()).toString());
            disabledHearths.m_128365_(String.valueOf(i), (Tag)hearthData);
            ++i;
        }
        return disabledHearths;
    }

    @SubscribeEvent
    public static void loadDisabledHearths(PlayerEvent.PlayerLoggedInEvent event) {
        HearthSaveDataHandler.deserializeDisabledHearths(event.getEntity().getPersistentData().m_128469_("disabledHearths"));
    }

    public static void deserializeDisabledHearths(CompoundTag disabledHearths) {
        DISABLED_HEARTHS.clear();
        for (String key : disabledHearths.m_128431_()) {
            CompoundTag hearthData = disabledHearths.m_128469_(key);
            DISABLED_HEARTHS.add((Pair<BlockPos, ResourceLocation>)Pair.of((Object)BlockPos.m_122022_((long)hearthData.m_128454_("pos")), (Object)new ResourceLocation(hearthData.m_128461_("level"))));
        }
    }
}

