/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.api.temperature.modifier.BlockInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.block.BoilerBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.BoilerContainer;
import com.momosoftworks.coldsweat.common.event.capability.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.BlockDataUpdateMessage;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BoilerBlockEntity
extends HearthBlockEntity
implements MenuProvider,
WorldlyContainer {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    LazyOptional<? extends IItemHandler>[] slotHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();

    public BoilerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BOILER, pos, state);
        TaskScheduler.schedule(this::checkForSmokestack, 5);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void sendUpdatePacket() {
        this.usingPlayers.removeIf(player -> {
            AbstractContainerMenu patt3647$temp = player.f_36096_;
            if (!(patt3647$temp instanceof BoilerContainer)) return true;
            BoilerContainer boilerContainer = (BoilerContainer)patt3647$temp;
            if (boilerContainer.te != this) return true;
            return false;
        });
        ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.NMLIST.with(() -> this.usingPlayers.stream().map(player -> player.f_8906_.f_9742_).toList()), (Object)new BlockDataUpdateMessage((BlockEntity)this));
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.cold_sweat.boiler");
    }

    @Override
    public Component m_5446_() {
        return this.m_7770_() != null ? this.m_7770_() : this.m_6820_();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof BoilerBlockEntity) {
            BoilerBlockEntity boilerTE = (BoilerBlockEntity)te;
            boilerTE.tick(level, state, pos);
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        super.tick(level, pos);
        if (this.getFuel() > 0) {
            if (!((Boolean)state.m_61143_((Property)BoilerBlock.LIT)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BoilerBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
            if ((double)this.ticksExisted % (20.0 / ConfigSettings.TEMP_RATE.get()) == 0.0) {
                boolean hasItemStacks = false;
                for (int i = 1; i < 10; ++i) {
                    ItemStack stack = this.m_8020_(i);
                    CompoundTag tag = NBTHelper.getTagOrEmpty(stack);
                    double itemTemp = tag.m_128459_("Temperature");
                    if (!stack.m_204117_(ModItemTags.BOILER_VALID) && !stack.m_204117_(ModItemTags.BOILER_PURIFIABLE)) continue;
                    if (itemTemp < 50.0 && stack.m_150930_(ModItems.FILLED_WATERSKIN)) {
                        hasItemStacks = true;
                        tag.m_128347_("Temperature", itemTemp + 1.0);
                        continue;
                    }
                    if ((double)this.ticksExisted % (200.0 / ConfigSettings.TEMP_RATE.get()) != 0.0 || !stack.m_204117_(ModItemTags.BOILER_PURIFIABLE) || !CompatManager.isThirstLoaded() || CompatManager.getWaterPurity(stack) >= 3) continue;
                    hasItemStacks = true;
                    CompatManager.setWaterPurity(stack, CompatManager.getWaterPurity(stack) + 1);
                }
                if (hasItemStacks) {
                    this.setFuel(this.getFuel() - 1);
                }
            }
        } else if (((Boolean)state.m_61143_((Property)BoilerBlock.LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BoilerBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    public int getMaxPaths() {
        return 1500;
    }

    @Override
    public int getSpreadRange() {
        return 16;
    }

    @Override
    public int getMaxInsulationLevel() {
        return 5;
    }

    @Override
    public boolean hasSmokeStack() {
        return this.hasSmokestack;
    }

    @Override
    protected void trySpreading(int pathCount, int firstIndex, int lastIndex) {
        if (this.hasSmokestack) {
            super.trySpreading(pathCount, firstIndex, lastIndex);
        }
    }

    @Override
    void insulatePlayer(Player player) {
        if (!this.shouldUseHotFuel) {
            EntityTempManager.getTemperatureCap((Entity)player).ifPresent(cap -> {
                double max;
                double min;
                double temp = cap.getTrait(Temperature.Trait.WORLD);
                if (CSMath.betweenInclusive(temp, min = cap.getTrait(Temperature.Trait.FREEZING_POINT), max = cap.getTrait(Temperature.Trait.BURNING_POINT))) {
                    Optional<BlockInsulationTempModifier> modifier = Temperature.getModifier((LivingEntity)player, Temperature.Trait.WORLD, BlockInsulationTempModifier.class);
                    if (modifier.isPresent()) {
                        if (((TempModifier)modifier.get()).getExpireTime() - ((TempModifier)modifier.get()).getTicksExisted() > 20) {
                            return;
                        }
                        temp = ((TempModifier)modifier.get()).getLastInput();
                    } else {
                        return;
                    }
                }
                this.shouldUseHotFuel |= this.getHotFuel() > 0 && temp < min;
            });
        }
        if (this.shouldUseHotFuel) {
            int maxEffect = this.getMaxInsulationLevel() - 1;
            int effectLevel = (int)Math.min((double)maxEffect, (double)this.insulationLevel / (double)this.getInsulationTime() * (double)maxEffect);
            player.m_7292_(new MobEffectInstance(ModEffects.INSULATION, 120, effectLevel, false, false, true));
        }
    }

    @Override
    public int getItemFuel(ItemStack item) {
        return ((Number)CSMath.getIfNotNull(ConfigSettings.BOILER_FUEL.get().get(item.m_41720_()), fuel -> fuel.test(item) ? fuel.value() : 0.0, 0)).intValue();
    }

    @Override
    protected void storeFuel(ItemStack stack, int amount) {
        if ((double)this.getFuel() < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.m_41613_() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - this.getFuel()) / (double)Math.abs(amount)), stack.m_41613_());
                stack.m_41774_(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.m_6836_(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    public int getFuel() {
        return this.getHotFuel();
    }

    public void setFuel(int amount) {
        this.setHotFuel(amount, true);
    }

    @Override
    public void setHotFuel(int amount, boolean update) {
        super.setHotFuel(amount, update);
        this.sendUpdatePacket();
    }

    @Override
    public void addFuel(int amount) {
        this.setHotFuelAndUpdate(this.getHotFuel() + amount);
    }

    @Override
    protected boolean isFuelChanged() {
        return this.ticksExisted % 10 == 0;
    }

    @Override
    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        Player player = playerInv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.usingPlayers.add(serverPlayer);
        }
        return new BoilerContainer(id, playerInv, this);
    }

    @Override
    protected void tickParticles() {
        if (this.hasSmokestack) {
            super.tickParticles();
        }
    }

    @Override
    public int m_6643_() {
        return 10;
    }

    public int[] m_7071_(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Y ? WATERSKIN_SLOTS : FUEL_SLOT;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        if (slot == 0) {
            return this.getItemFuel(stack) != 0;
        }
        return stack.m_150930_(ModItems.WATERSKIN) || stack.m_150930_(ModItems.FILLED_WATERSKIN);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return switch (facing) {
                case Direction.UP -> this.slotHandlers[0].cast();
                case Direction.DOWN -> this.slotHandlers[1].cast();
                default -> this.slotHandlers[2].cast();
            };
        }
        return super.getCapability(capability, facing);
    }
}

