/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.tooltip.ClientSoulspringTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.InsulationTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.SoulspringTooltip;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.event.capability.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Wearable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TooltipHandler {
    public static final ChatFormatting COLD = ChatFormatting.BLUE;
    public static final ChatFormatting HOT = ChatFormatting.RED;
    static int FUEL_FADE_TIMER = 0;

    public static int getTooltipTitleIndex(List<Either<FormattedText, TooltipComponent>> tooltip, ItemStack stack) {
        int tooltipStartIndex;
        String hoverName = stack.m_41786_().getString();
        if (CompatManager.isIcebergLoaded()) {
            tooltipStartIndex = CompatManager.getLegendaryTTStartIndex(tooltip) + 1;
        } else {
            for (tooltipStartIndex = 0; tooltipStartIndex < tooltip.size(); ++tooltipStartIndex) {
                if (!tooltip.get(tooltipStartIndex).left().map(FormattedText::getString).map(String::strip).orElse("").equals(hoverName)) continue;
                ++tooltipStartIndex;
                break;
            }
        }
        if (tooltipStartIndex == -1) {
            tooltipStartIndex = 0;
        }
        return tooltipStartIndex;
    }

    public static int getTooltipEndIndex(List<Either<FormattedText, TooltipComponent>> tooltip, ItemStack stack) {
        int tooltipEndIndex = tooltip.size();
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            while (tooltip.get(tooltipEndIndex - 1).left().map(text -> !text.getString().equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString())).orElse(false).booleanValue()) {
                --tooltipEndIndex;
            }
            --tooltipEndIndex;
        }
        if (tooltipEndIndex == -1) {
            tooltipEndIndex = tooltip.size();
        }
        return tooltipEndIndex;
    }

    public static void addModifierTooltipLines(List<Component> tooltip, AttributeModifierMap map) {
        map.getMap().asMap().forEach((attribute, modifiers) -> {
            for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                double value = 0.0;
                for (AttributeModifier modifier : modifiers.stream().filter(mod -> mod.m_22217_() == operation).toList()) {
                    value += modifier.m_22218_();
                }
                if (value == 0.0) continue;
                tooltip.add((Component)TooltipHandler.getFormattedAttributeModifier(attribute, value, operation));
            }
        });
    }

    public static MutableComponent getFormattedAttributeModifier(Attribute attribute, double amount, AttributeModifier.Operation operation) {
        String percent;
        String sign;
        ChatFormatting color;
        String operationString;
        if (attribute == null) {
            return Component.m_237119_();
        }
        double value = amount;
        String attributeName = attribute.m_22087_().replace("attribute.", "");
        if (operation == AttributeModifier.Operation.ADDITION && (attribute == ModAttributes.FREEZING_POINT || attribute == ModAttributes.BURNING_POINT || attribute == ModAttributes.WORLD_TEMPERATURE || attribute == ModAttributes.BASE_BODY_TEMPERATURE)) {
            value = Temperature.convert(value, Temperature.Units.MC, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, false);
        }
        String string = operationString = operation == AttributeModifier.Operation.ADDITION ? "add" : "multiply";
        if (value >= 0.0) {
            color = ChatFormatting.BLUE;
            sign = "+";
        } else {
            color = ChatFormatting.RED;
            sign = "";
        }
        if (operation != AttributeModifier.Operation.ADDITION || attribute == ModAttributes.HEAT_RESISTANCE || attribute == ModAttributes.COLD_RESISTANCE || attribute == ModAttributes.HEAT_DAMPENING || attribute == ModAttributes.COLD_DAMPENING) {
            percent = "%";
            value *= 100.0;
        } else {
            percent = "";
        }
        return Component.m_237110_((String)String.format("attribute.cold_sweat.modifier.%s.%s", operationString, attributeName), (Object[])new Object[]{sign + CSMath.formatDoubleOrInt(CSMath.round(value, 2)) + percent}).m_130940_(color);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addCustomTooltips(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        List elements = event.getTooltipElements();
        if (stack.m_41619_()) {
            return;
        }
        int tooltipStartIndex = TooltipHandler.getTooltipTitleIndex(elements, stack);
        int tooltipEndIndex = TooltipHandler.getTooltipEndIndex(elements, stack);
        Insulator itemInsul = null;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (stack.m_41720_() instanceof SoulspringLampItem) {
            if (!Screen.m_96638_()) {
                elements.add(tooltipStartIndex, Either.left((Object)Component.m_237113_((String)"? ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)"'Shift'").m_130940_(ChatFormatting.DARK_GRAY))));
            }
            elements.add(tooltipStartIndex, Either.right((Object)new SoulspringTooltip(stack.m_41784_().m_128459_("Fuel"))));
        } else if (stack.m_41780_() == UseAnim.DRINK || stack.m_41780_() == UseAnim.EAT) {
            PredicateItem temp = ConfigSettings.FOOD_TEMPERATURES.get().get(stack.m_41720_());
            if (temp != null && temp.test((Entity)player, stack)) {
                elements.add(tooltipEndIndex, Either.left((Object)(temp.value() > 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp.value())}).m_130940_(HOT) : Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{CSMath.formatDoubleOrInt(temp.value())}).m_130940_(COLD))));
                elements.add(tooltipEndIndex, Either.left((Object)Component.m_237115_((String)"tooltip.cold_sweat.consumed").m_130940_(ChatFormatting.GRAY)));
                elements.add(tooltipEndIndex, Either.left((Object)Component.m_237119_()));
            }
        } else {
            itemInsul = ConfigSettings.INSULATION_ITEMS.get().get(item);
            if (itemInsul != null && !itemInsul.insulation().isEmpty()) {
                if (itemInsul.test((Entity)player, stack)) {
                    elements.add(tooltipStartIndex, Either.right((Object)new InsulationTooltip(itemInsul.insulation().split(), Insulation.Slot.ITEM, stack)));
                }
            } else if (CompatManager.isCuriosLoaded() && (itemInsul = ConfigSettings.INSULATING_CURIOS.get().get(item)) != null && !itemInsul.insulation().isEmpty() && itemInsul.test((Entity)player, stack)) {
                elements.add(tooltipStartIndex, Either.right((Object)new InsulationTooltip(itemInsul.insulation().split(), Insulation.Slot.CURIO, stack)));
            }
        }
        Insulator armorInsulator = ConfigSettings.INSULATING_ARMORS.get().get(item);
        if (stack.m_41720_() instanceof Wearable && (!Objects.equals(armorInsulator, itemInsul) || armorInsulator == null)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(arg_0 -> TooltipHandler.lambda$addCustomTooltips$5(stack, (Player)player, armorInsulator, elements, tooltipStartIndex, arg_0));
        }
    }

    @SubscribeEvent
    public static void renderSoulLampInsertTooltip(ScreenEvent.Render.Post event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse() != null && screen.getSlotUnderMouse().m_7993_().m_41720_() == ModItems.SOULSPRING_LAMP) {
            PredicateItem itemFuel;
            double fuel = screen.getSlotUnderMouse().m_7993_().m_41784_().m_128459_("Fuel");
            ItemStack carriedStack = screen.m_6262_().m_142621_();
            if (!carriedStack.m_41619_() && (itemFuel = ConfigSettings.SOULSPRING_LAMP_FUEL.get().get(carriedStack.m_41720_())) != null && itemFuel.test(carriedStack)) {
                double fuelValue = (double)screen.m_6262_().m_142621_().m_41613_() * itemFuel.value();
                int slotX = screen.getSlotUnderMouse().f_40220_ + screen.getGuiLeft();
                int slotY = screen.getSlotUnderMouse().f_40221_ + screen.getGuiTop();
                PoseStack ps = event.getPoseStack();
                if (event.getMouseY() < slotY + 8) {
                    ps.m_85837_(0.0, 32.0, 0.0);
                }
                event.getScreen().m_96597_(event.getPoseStack(), List.of(Component.m_237113_((String)"       ")), slotX - 18, slotY + 1);
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)ClientSoulspringTooltip.TOOLTIP_LOCATION.get());
                GuiComponent.m_93143_((PoseStack)ps, (int)(slotX - 7), (int)(slotY - 11), (int)401, (float)0.0f, (float)0.0f, (int)30, (int)8, (int)30, (int)34);
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.15f + (float)((Math.sin((float)FUEL_FADE_TIMER / 5.0f) + 1.0) / 2.0) * 0.4f));
                GuiComponent.m_93143_((PoseStack)ps, (int)(slotX - 7), (int)(slotY - 11), (int)401, (float)0.0f, (float)8.0f, (int)Math.min(30, (int)((fuel + fuelValue) / (double)2.1333f)), (int)8, (int)30, (int)34);
                RenderSystem.m_69461_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiComponent.m_93143_((PoseStack)ps, (int)(slotX - 7), (int)(slotY - 11), (int)401, (float)0.0f, (float)16.0f, (int)((int)(fuel / (double)2.1333f)), (int)8, (int)30, (int)34);
            }
        }
    }

    @SubscribeEvent
    public static void tickSoulLampInsertTooltip(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++FUEL_FADE_TIMER;
        }
    }

    private static /* synthetic */ void lambda$addCustomTooltips$5(ItemStack stack, Player player, Insulator armorInsulator, List elements, int tooltipStartIndex, IInsulatableCap cap) {
        cap.deserializeNBT((Tag)stack.m_41784_());
        ArrayList<Insulation> insulation = new ArrayList<Insulation>(cap.getInsulation().stream().filter(pair -> {
            ItemStack stack1 = (ItemStack)pair.getFirst();
            return CSMath.getIfNotNull(ConfigSettings.INSULATION_ITEMS.get().get(stack1.m_41720_()), insulator -> insulator.test((Entity)player, stack), true);
        }).map(Pair::getSecond).flatMap(Collection::stream).toList());
        if (armorInsulator != null && armorInsulator.test((Entity)player, stack)) {
            insulation.addAll(armorInsulator.insulation().split());
        }
        if (!insulation.isEmpty()) {
            elements.add(tooltipStartIndex, Either.right((Object)new InsulationTooltip(insulation, Insulation.Slot.ARMOR, stack)));
        }
    }
}

