/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;

public class BlockInsulationTempModifier
extends TempModifier {
    public BlockInsulationTempModifier() {
        this(0);
    }

    public BlockInsulationTempModifier(int strength) {
        this.getNBT().m_128405_("Strength", strength);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double min = ConfigSettings.MIN_TEMP.get();
        double max = ConfigSettings.MAX_TEMP.get();
        double mid = (min + max) / 2.0;
        double hearthStrength = ConfigSettings.HEARTH_STRENGTH.get();
        int insulationStrength = this.getNBT().m_128451_("Strength");
        return temp -> CSMath.blend(temp, CSMath.weightedAverage(temp, mid, 1.0 - hearthStrength, 1.0), (double)insulationStrength, 0.0, 10.0);
    }
}

