/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;
import oshi.util.tuples.Triplet;

public class BiomeTempModifier
extends TempModifier {
    public BiomeTempModifier() {
        this(16);
    }

    public BiomeTempModifier(int samples) {
        this.getNBT().m_128405_("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        try {
            double worldTemp = 0.0;
            Level level = entity.f_19853_;
            BlockPos entPos = entity.m_20183_();
            Pair<Double, Temperature.Units> dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get().get(level.m_6042_());
            if (dimTempOverride != null) {
                return temp -> temp + (Double)dimTempOverride.getFirst();
            }
            Pair<Double, Double> structureTemp = this.getStructureTemp(entity.f_19853_, entity.m_20183_());
            if (structureTemp.getFirst() != null) {
                return temp -> (Double)structureTemp.getFirst();
            }
            int biomeCount = 0;
            for (BlockPos blockPos : level.m_6042_().f_63856_() ? WorldHelper.getPositionCube(entPos, 6, 10) : WorldHelper.getPositionGrid(entPos, 36, 10)) {
                Holder holder;
                if (!level.m_46739_(blockPos) || blockPos.m_123331_((Vec3i)entPos) > 900.0 || (holder = level.m_7062_().m_204214_(blockPos)).m_203656_(Tags.Biomes.IS_UNDERGROUND) || holder.m_203543_().isEmpty()) continue;
                ++biomeCount;
                Pair<Double, Double> configTemp = this.getBiomeTemp((Holder<Biome>)holder);
                double min = (Double)configTemp.getFirst();
                double max = (Double)configTemp.getSecond();
                DimensionType dimension = level.m_6042_();
                if (!dimension.f_63856_()) {
                    double altitude = entity.m_20186_();
                    double mid = (min + max) / 2.0;
                    double biomeTemp = CSMath.blend(min, max, Math.sin((double)level.m_46468_() / 3819.7186342054883), -1.0, 1.0) + CSMath.blend(0.0, Math.min(-0.6, (min - mid) * 2.0), altitude, (double)level.m_5736_(), (double)level.m_151558_());
                    if (CompatManager.isPrimalWinterLoaded() && holder.m_203656_(BiomeTags.f_215817_)) {
                        biomeTemp = Math.min(biomeTemp, biomeTemp / 2.0) - Math.max(biomeTemp / 2.0, 0.0);
                    }
                    worldTemp += biomeTemp;
                    continue;
                }
                worldTemp += CSMath.average(max, min);
            }
            worldTemp /= (double)Math.max(1, biomeCount);
            Pair<Double, Temperature.Units> dimTempOffsetConf = ConfigSettings.DIMENSION_OFFSETS.get().get(level.m_6042_());
            if (dimTempOffsetConf != null) {
                worldTemp += ((Double)dimTempOffsetConf.getFirst()).doubleValue();
            }
            double finalWorldTemp = worldTemp += ((Double)structureTemp.getSecond()).doubleValue();
            return temp -> temp + finalWorldTemp;
        }
        catch (Exception e) {
            return temp -> temp;
        }
    }

    public Pair<Double, Double> getStructureTemp(Level level, BlockPos pos) {
        Structure structure = WorldHelper.getStructureAt(level, pos);
        if (structure == null) {
            return Pair.of(null, (Object)0.0);
        }
        Double strucTemp = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_TEMPS.get().get(structure), Pair::getFirst, null);
        Double strucOffset = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_OFFSETS.get().get(structure), Pair::getFirst, 0.0);
        return Pair.of((Object)strucTemp, (Object)strucOffset);
    }

    public Pair<Double, Double> getBiomeTemp(Holder<Biome> holder) {
        Biome biome = (Biome)holder.m_203334_();
        double variance = 1.0f / Math.max(1.0f, 2.0f + biome.getModifiedClimateSettings().f_47683_() * 2.0f);
        double baseTemp = biome.m_47554_();
        Triplet<Double, Double, Temperature.Units> configTemp = ConfigSettings.BIOME_TEMPS.get().getOrDefault(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)(baseTemp - variance), (Object)(baseTemp + variance), (Object)Temperature.Units.MC));
        Triplet<Double, Double, Temperature.Units> configOffset = ConfigSettings.BIOME_OFFSETS.get().getOrDefault(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)0.0, (Object)0.0, (Object)Temperature.Units.MC));
        return CSMath.addPairs(Pair.of((Object)((Double)configTemp.getA()), (Object)((Double)configTemp.getB())), Pair.of((Object)((Double)configOffset.getA()), (Object)((Double)configOffset.getB())));
    }
}

