/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;

public class GatherDefaultTempModifiersEvent
extends Event {
    private final List<TempModifier> modifiers;
    private final LivingEntity entity;
    private final Temperature.Trait trait;

    public GatherDefaultTempModifiersEvent(LivingEntity entity, Temperature.Trait trait) {
        this.entity = entity;
        this.trait = trait;
        this.modifiers = new ArrayList<TempModifier>(Temperature.getModifiers(entity, trait));
    }

    public List<TempModifier> getModifiers() {
        return this.modifiers;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public Temperature.Trait getTrait() {
        return this.trait;
    }

    public void addModifier(TempModifier modifier) {
        this.modifiers.add(modifier);
    }

    public void addModifiers(List<TempModifier> modifiers) {
        this.modifiers.addAll(modifiers);
    }

    public void addModifier(TempModifier modifier, boolean allowDupes, Placement params) {
        Temperature.addModifier(this.modifiers, modifier, allowDupes, 1, params);
    }
}

