/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import umpaz.brewinandchewin.common.effect.TipsyEffect;
import umpaz.brewinandchewin.common.utility.BCTextUtils;
import vectorwing.farmersdelight.common.item.DrinkableItem;

public class BoozeItem
extends DrinkableItem {
    protected final int potency;
    protected final int duration;

    public BoozeItem(int potency, int duration, Item.Properties properties) {
        super(properties);
        this.potency = potency;
        this.duration = duration;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        TipsyEffect.addTipsyEffect(consumer, this.duration, this.potency);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        MutableComponent textTipsy = BCTextUtils.getTranslation("tooltip.tipsy1", this.duration);
        if (this.potency == 2) {
            textTipsy = BCTextUtils.getTranslation("tooltip.tipsy2", this.duration);
        } else if (this.potency == 3) {
            textTipsy = BCTextUtils.getTranslation("tooltip.tipsy3", this.duration);
        }
        tooltip.add((Component)textTipsy.m_130940_(ChatFormatting.RED));
        BCTextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
    }
}

