/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.inventory;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import umpaz.brewinandchewin.common.crafting.KegRecipe;

public class KegServerPlaceRecipe<C extends Container>
implements PlaceRecipe<Integer> {
    protected final StackedContents stackedContents = new StackedContents();
    protected Inventory inventory;
    protected RecipeBookMenu<C> menu;

    public KegServerPlaceRecipe(RecipeBookMenu<C> keg) {
        this.menu = keg;
    }

    public void recipeClicked(ServerPlayer player, @Nullable Recipe<C> recipe, boolean p_135437_) {
        if (recipe != null && player.m_8952_().m_12709_(recipe)) {
            this.inventory = player.m_150109_();
            if (this.testClearGrid() || player.m_7500_()) {
                this.stackedContents.m_36453_();
                player.m_150109_().m_36010_(this.stackedContents);
                this.menu.m_5816_(this.stackedContents);
                if (this.stackedContents.m_36475_(recipe, (IntList)null)) {
                    this.handleRecipeClicked(recipe, p_135437_);
                } else {
                    this.clearGrid(true);
                    player.f_8906_.m_9829_((Packet)new ClientboundPlaceGhostRecipePacket(player.f_36096_.f_38840_, recipe));
                }
                player.m_150109_().m_6596_();
            }
        }
    }

    protected void clearGrid(boolean p_179845_) {
        for (int i = 0; i < this.menu.m_6653_(); ++i) {
            if (!this.menu.m_142157_(i)) continue;
            ItemStack itemstack = this.menu.m_38853_(i).m_7993_().m_41777_();
            this.inventory.m_150076_(itemstack, false);
            this.menu.m_38853_(i).m_5852_(itemstack);
        }
        this.menu.m_6650_();
    }

    protected void handleRecipeClicked(Recipe<C> recipe, boolean p_135442_) {
        int j1;
        IntArrayList intlist;
        boolean flag = this.menu.m_6032_(recipe);
        int i = this.stackedContents.m_36493_(recipe, (IntList)null);
        if (flag) {
            for (int j = 0; j < this.menu.m_6656_() * this.menu.m_6635_() + 1; ++j) {
                ItemStack itemstack;
                if (j == this.menu.m_6636_() || (itemstack = this.menu.m_38853_(j).m_7993_()).m_41619_() || Math.min(i, itemstack.m_41741_()) >= itemstack.m_41613_() + 1) continue;
                return;
            }
        }
        if (this.stackedContents.m_36478_(recipe, (IntList)(intlist = new IntArrayList()), j1 = this.getStackSize(p_135442_, i, flag))) {
            int k = j1;
            IntListIterator intListIterator = intlist.iterator();
            while (intListIterator.hasNext()) {
                int l = (Integer)intListIterator.next();
                int i1 = StackedContents.m_36454_((int)l).m_41741_();
                if (i1 >= k) continue;
                k = i1;
            }
            if (this.stackedContents.m_36478_(recipe, (IntList)intlist, k)) {
                this.clearGrid(false);
                if (!((KegRecipe)recipe).getFluidItem().m_43947_()) {
                    this.addFluidItemToSlot(((KegRecipe)recipe).getFluidItem().m_43908_()[0], 4, k, 0, 0);
                    intlist.remove(intlist.size() - 1);
                }
                this.m_135408_(this.menu.m_6635_(), this.menu.m_6656_(), this.menu.m_6636_(), recipe, (Iterator)intlist.iterator(), k);
            }
        }
    }

    public void m_5817_(Iterator<Integer> p_135444_, int index, int count, int p_135447_, int p_135448_) {
        Slot slot = this.menu.m_38853_(index);
        ItemStack itemstack = StackedContents.m_36454_((int)p_135444_.next());
        if (!itemstack.m_41619_()) {
            for (int i = 0; i < count; ++i) {
                this.moveItemToGrid(slot, itemstack);
            }
        }
    }

    public void addFluidItemToSlot(ItemStack itemStack, int index, int count, int p_135447_, int p_135448_) {
        Slot slot = this.menu.m_38853_(index);
        if (!itemStack.m_41619_()) {
            for (int i = 0; i < count; ++i) {
                this.moveItemToGrid(slot, itemStack);
            }
        }
    }

    protected int getStackSize(boolean p_135450_, int p_135451_, boolean p_135452_) {
        int i = 1;
        if (p_135450_) {
            i = p_135451_;
        } else if (p_135452_) {
            i = 64;
            for (int j = 0; j < this.menu.m_6635_() * this.menu.m_6656_() + 1; ++j) {
                ItemStack itemstack;
                if (j == this.menu.m_6636_() || (itemstack = this.menu.m_38853_(j).m_7993_()).m_41619_() || i <= itemstack.m_41613_()) continue;
                i = itemstack.m_41613_();
            }
            if (i < 64) {
                ++i;
            }
        }
        return i;
    }

    protected void moveItemToGrid(Slot slot, ItemStack itemStack) {
        ItemStack itemstack;
        int i = this.inventory.m_36043_(itemStack);
        if (i != -1 && !(itemstack = this.inventory.m_8020_(i).m_41777_()).m_41619_()) {
            if (itemstack.m_41613_() > 1) {
                this.inventory.m_7407_(i, 1);
            } else {
                this.inventory.m_8016_(i);
            }
            itemstack.m_41764_(1);
            if (slot.m_7993_().m_41619_()) {
                slot.m_5852_(itemstack);
            } else {
                slot.m_7993_().m_41769_(1);
            }
        }
    }

    private boolean testClearGrid() {
        ArrayList list = Lists.newArrayList();
        int i = this.getAmountOfFreeSlotsInInventory();
        for (int j = 0; j < this.menu.m_6635_() * this.menu.m_6656_() + 1; ++j) {
            ItemStack itemstack;
            if (j == this.menu.m_6636_() || (itemstack = this.menu.m_38853_(j).m_7993_().m_41777_()).m_41619_()) continue;
            int k = this.inventory.m_36050_(itemstack);
            if (k == -1 && list.size() <= i) {
                for (ItemStack itemstack1 : list) {
                    if (!itemstack1.m_41656_(itemstack) || itemstack1.m_41613_() == itemstack1.m_41741_() || itemstack1.m_41613_() + itemstack.m_41613_() > itemstack1.m_41741_()) continue;
                    itemstack1.m_41769_(itemstack.m_41613_());
                    itemstack.m_41764_(0);
                    break;
                }
                if (itemstack.m_41619_()) continue;
                if (list.size() >= i) {
                    return false;
                }
                list.add(itemstack);
                continue;
            }
            if (k != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int i = 0;
        for (ItemStack itemstack : this.inventory.f_35974_) {
            if (!itemstack.m_41619_()) continue;
            ++i;
        }
        return i;
    }
}

