/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegResultSlot;
import umpaz.brewinandchewin.common.block.entity.inventory.KegServerPlaceRecipe;
import umpaz.brewinandchewin.common.registry.BCBlocks;
import umpaz.brewinandchewin.common.registry.BCItems;
import umpaz.brewinandchewin.common.registry.BCMenuTypes;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMealSlot;

public class KegMenu
extends RecipeBookMenu<RecipeWrapper> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_MUG = new ResourceLocation("brewinandchewin", "item/empty_container_slot_mug");
    public final KegBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData kegData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public KegMenu(int windowId, Inventory playerInventory, KegBlockEntity tileEntity, ContainerData kegDataIn) {
        super((MenuType)BCMenuTypes.KEG.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.kegData = kegDataIn;
        this.level = playerInventory.f_35978_.f_19853_;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 28;
        int inputStartY = 28;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 2; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 2 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 4, 80, 18));
        this.m_38897_((Slot)new CookingPotMealSlot((IItemHandler)this.inventory, 5, 117, 23));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 6, 85, 55){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT_MUG);
            }
        });
        this.m_38897_((Slot)new KegResultSlot(playerInventory.f_35978_, tileEntity, (IItemHandler)this.inventory, 7, 117, 55));
        this.m_38897_((Slot)new KegResultSlot(playerInventory.f_35978_, tileEntity, (IItemHandler)this.inventory, 8, 143, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(kegDataIn);
    }

    private static KegBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof KegBlockEntity) {
            return (KegBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public KegMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, KegMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(5));
    }

    public boolean m_6875_(Player playerIn) {
        return KegMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BCBlocks.KEG.get()));
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        int indexDrinkDisplay = 4;
        int indexFluidItemInput = 5;
        int indexContainerInput = 6;
        int indexOutput = 7;
        int indexContainerOutput = 8;
        int startPlayerInv = indexContainerOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == indexOutput || index == indexContainerOutput) {
                if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index > indexContainerOutput) {
                if (itemstack1.m_41720_() == BCItems.TANKARD.get() && !this.m_38903_(itemstack1, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 0, indexFluidItemInput, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 0, indexDrinkDisplay, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFermentProgressionScaled() {
        int i = this.kegData.m_6413_(0);
        int j = this.kegData.m_6413_(1);
        return j != 0 && i != 0 ? i * 33 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFermentingTicks() {
        return this.kegData.m_6413_(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTemperature() {
        return this.kegData.m_6413_(2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAdjustedTemperature() {
        return this.kegData.m_6413_(3);
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 5; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super RecipeWrapper> recipe) {
        return recipe.m_5818_((Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.level);
    }

    public int m_6636_() {
        return 6;
    }

    public int m_6635_() {
        return 2;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 6;
    }

    public RecipeBookType m_5867_() {
        return BrewinAndChewin.RECIPE_TYPE_FERMENTING;
    }

    public boolean m_142157_(int slot) {
        return slot < 5;
    }

    public void m_6951_(boolean size, Recipe<?> recipe, ServerPlayer player) {
        new KegServerPlaceRecipe<RecipeWrapper>(this).recipeClicked(player, recipe, size);
    }
}

