/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import umpaz.brewinandchewin.common.registry.BCBlockEntityTypes;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class ItemCoasterBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.inventory);
    private ResourceLocation lastRecipeID;
    private boolean isItemCarvingBoard = false;

    public ItemCoasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BCBlockEntityTypes.ITEM_COASTER.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.isItemCarvingBoard = compound.m_128471_("IsItemCarved");
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128379_("IsItemCarved", this.isItemCarvingBoard);
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack item = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                ItemCoasterBlockEntity.this.inventoryChanged();
            }
        };
    }
}

