/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.registry.BCBlockEntityTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class KegBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty VERTICAL = BooleanProperty.m_61465_((String)"vertical");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE_X = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_Z = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_VERTICAL = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public KegBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!level.f_46443_) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof KegBlockEntity) {
                KegBlockEntity kegEntity = (KegBlockEntity)tileEntity;
                kegEntity.updateTemperature();
                ItemStack servingStack = kegEntity.useHeldItemOnDrink(heldStack);
                if (servingStack != ItemStack.f_41583_) {
                    if (!player.m_150109_().m_36054_(servingStack)) {
                        player.m_36176_(servingStack, false);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)kegEntity, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)VERTICAL)).booleanValue()) {
            if (state.m_61143_((Property)FACING) == Direction.SOUTH || state.m_61143_((Property)FACING) == Direction.NORTH) {
                return SHAPE_X;
            }
            if (state.m_61143_((Property)FACING) == Direction.EAST || state.m_61143_((Property)FACING) == Direction.WEST) {
                return SHAPE_Z;
            }
        }
        return SHAPE_VERTICAL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_7820_();
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        KegBlockEntity kegEntity = (KegBlockEntity)level.m_7702_(pos);
        if (kegEntity != null) {
            CompoundTag nbt = kegEntity.writeDrink(new CompoundTag());
            if (!nbt.m_128456_()) {
                stack.m_41700_("BlockEntityTag", (Tag)nbt);
            }
            if (kegEntity.m_8077_()) {
                stack.m_41714_(kegEntity.m_7770_());
            }
        }
        return stack;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof KegBlockEntity) {
                KegBlockEntity kegEntity = (KegBlockEntity)tileEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, kegEntity.getDroppableInventory());
                kegEntity.getUsedRecipesAndPopExperience(level, Vec3.m_82512_((Vec3i)pos));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, level, tooltip, flagIn);
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        ItemStack drinkStack = KegBlockEntity.getDrinkFromItem(stack);
        if (!drinkStack.m_41619_()) {
            MutableComponent textServingsOf = drinkStack.m_41613_() == 1 ? TextUtils.getTranslation((String)"tooltip.cooking_pot.single_serving", (Object[])new Object[0]) : TextUtils.getTranslation((String)"tooltip.cooking_pot.many_servings", (Object[])new Object[]{drinkStack.m_41613_()});
            tooltip.add((Component)textServingsOf.m_130940_(ChatFormatting.GRAY));
            MutableComponent textMealName = drinkStack.m_41786_().m_6881_();
            tooltip.add((Component)textMealName.m_130940_(drinkStack.m_41791_().f_43022_));
        } else {
            MutableComponent textEmpty = TextUtils.getTranslation((String)"tooltip.cooking_pot.empty", (Object[])new Object[0]);
            tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.GRAY));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, VERTICAL, WATERLOGGED});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        if (stack.m_41788_() && (tileEntity = level.m_7702_(pos)) instanceof KegBlockEntity) {
            ((KegBlockEntity)tileEntity).setCustomName(stack.m_41786_());
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof KegBlockEntity) {
            ItemStackHandler inventory = ((KegBlockEntity)tileEntity).getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BCBlockEntityTypes.KEG.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.f_46443_) {
            return KegBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BCBlockEntityTypes.KEG.get()), KegBlockEntity::animationTick);
        }
        return KegBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BCBlockEntityTypes.KEG.get()), KegBlockEntity::fermentingTick);
    }
}

