/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.mixin;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFixer;
import corgitaco.blockswap.BlockSwap;
import corgitaco.blockswap.config.BlockSwapConfig;
import corgitaco.blockswap.config.MissingBlockIDsConfig;
import corgitaco.blockswap.swapper.Swapper;
import corgitaco.blockswap.util.jankson.JanksonJsonOps;
import corgitaco.blockswap.util.jankson.JanksonUtil;
import java.net.Proxy;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void blockSwap_loadConfig(Thread $$0, LevelStorageSource.LevelStorageAccess $$1, PackRepository $$2, WorldStem $$3, Proxy $$4, DataFixer $$5, Services $$6, ChunkProgressListenerFactory $$7, CallbackInfo ci) {
        BlockSwapConfig config = BlockSwapConfig.getConfig(true);
        MissingBlockIDsConfig missingBlockIDsConfig = MissingBlockIDsConfig.getConfig(true);
        if (config.generateAllKnownStates()) {
            TreeMap<Block, List> allKnownStates = new TreeMap<Block, List>(Comparator.comparing(block -> Registry.f_122824_.m_7981_(block).toString()));
            for (Block block2 : Registry.f_122824_) {
                allKnownStates.computeIfAbsent(block2, key -> key.m_49965_().m_61056_());
            }
            allKnownStates.forEach((block, blockStates) -> {
                ResourceLocation blockKey = Registry.f_122824_.m_7981_(block);
                JanksonUtil.createConfig(BlockSwap.CONFIG_PATH.resolve("known_states").resolve(blockKey.m_135827_()).resolve(blockKey.m_135815_() + ".json5"), Swapper.COMMENTED_STATE_CODEC.listOf(), "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map<String, String>)ImmutableMap.of(), JanksonJsonOps.INSTANCE, blockStates);
            });
        }
    }
}

