/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.mixin;

import com.google.common.collect.ImmutableMap;
import fuzs.barteringstation.capability.BarteringStationCapability;
import fuzs.barteringstation.init.ModRegistry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Behavior.class})
abstract class BehaviorMixin<E extends LivingEntity> {
    @Unique
    private static final Map<MemoryModuleType<?>, MemoryStatus> ADMIRING_ITEM_ENTRY_CONDITION = ImmutableMap.of((Object)MemoryModuleType.f_26336_, (Object)MemoryStatus.VALUE_ABSENT);
    @Shadow
    @Final
    protected Map<MemoryModuleType<?>, MemoryStatus> f_22522_;

    BehaviorMixin() {
    }

    @Inject(method={"tryStart"}, at={@At(value="RETURN")})
    public final void barteringstation$tryStart(ServerLevel level, E owner, long gameTime, CallbackInfoReturnable<Boolean> callback) {
        Optional optional;
        if (((Boolean)callback.getReturnValue()).booleanValue() && owner instanceof Piglin && ADMIRING_ITEM_ENTRY_CONDITION.equals(this.f_22522_) && (optional = ModRegistry.BARTERING_STATION_CAPABILITY.maybeGet(owner)).isPresent() && optional.map(BarteringStationCapability::hasBarteringStationPos).orElseThrow().booleanValue()) {
            BarteringStationCapability capability = (BarteringStationCapability)optional.orElseThrow(IllegalStateException::new);
            BlockPos pos = capability.getBarteringStationPos();
            capability.clearBarteringStationPos();
            level.m_141902_(pos, (BlockEntityType)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.get()).ifPresent(blockEntity -> {
                List thrownItems = level.m_6443_(ItemEntity.class, owner.m_20191_(), item -> {
                    UUID thrower = item.m_32057_();
                    return item.m_32063_() && thrower != null && thrower.equals(owner.m_20148_());
                });
                for (ItemEntity item2 : thrownItems) {
                    if (!blockEntity.placeBarterResponseItem(item2.m_32055_())) continue;
                    item2.m_146870_();
                }
            });
        }
    }
}

