/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.data.SimpleTrainConnection;
import de.mrjulsen.crn.data.SimpleTrainSchedule;
import de.mrjulsen.crn.data.SimulatedTrainSchedule;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class TrainUtils {
    public static final GlobalRailwayManager RAILWAY_MANAGER = Create.RAILWAYS;

    public static Map<String, Collection<GlobalTrainDisplayData.TrainDeparturePrediction>> Gott() {
        return new HashMap<String, Collection<GlobalTrainDisplayData.TrainDeparturePrediction>>(GlobalTrainDisplayData.statusByDestination);
    }

    public static Map<TrainStationAlias, Collection<DeparturePrediction>> getMappedDeparturePredictions() {
        Map<String, Collection<GlobalTrainDisplayData.TrainDeparturePrediction>> statusData = TrainUtils.Gott();
        HashMap<TrainStationAlias, Collection<DeparturePrediction>> map = new HashMap<TrainStationAlias, Collection<DeparturePrediction>>();
        GlobalSettingsManager.getInstance().getSettingsData().getAliasList().forEach(alias -> map.put((TrainStationAlias)alias, (Collection<DeparturePrediction>)statusData.entrySet().stream().filter(x -> alias.contains((String)x.getKey())).flatMap(x -> ((Collection)x.getValue()).stream()).map(x -> new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)x)).toList()));
        return map;
    }

    public static void getMappedDeparturePredictions(Map<String, Collection<DeparturePrediction>> globalPredictions, Map<UUID, Collection<DeparturePrediction>> trainPredictions) {
        Map<String, Collection<GlobalTrainDisplayData.TrainDeparturePrediction>> statusData = TrainUtils.Gott();
        statusData.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            Collection value = (Collection)e.getValue();
            TrainStationAlias alias = GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(key);
            if (!globalPredictions.containsKey(alias.getAliasName().get())) {
                globalPredictions.put(alias.getAliasName().get(), new ArrayList());
            }
            ((Collection)globalPredictions.get(alias.getAliasName().get())).addAll(value.stream().map(x -> new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)x)).toList());
            value.forEach(x -> {
                if (!trainPredictions.containsKey(x.train.id)) {
                    trainPredictions.put(x.train.id, new ArrayList());
                }
                ((Collection)trainPredictions.get(x.train.id)).add(new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)x));
            });
        });
    }

    public static Collection<DeparturePrediction> getTrainDeparturePredictions(UUID trainId, Level level) {
        HashMap edges = level != null ? TrainUtils.getAllEdgesMapped() : new HashMap();
        HashMap stationsByName = level != null ? TrainUtils.getAllStations().stream().collect(Collectors.groupingBy(x -> x.name, Collectors.toSet())) : new HashMap();
        List<DeparturePrediction> preds = TrainUtils.Gott().values().stream().flatMap(x -> x.stream()).filter(x -> x.train.id.equals(trainId)).map(x -> {
            Set exitSides;
            DeparturePrediction prediction = new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)x);
            if (stationsByName.containsKey(prediction.getStationName()) && (exitSides = ((Set)stationsByName.get(prediction.getStationName())).stream().filter(a -> edges.containsKey(a.id)).map(a -> TrainUtils.getTrainStationExit(a, Direction.m_122364_((double)TrainUtils.angleOn((TrackEdgePoint)a, (TrackEdge)((Set)edges.get(a.id)).stream().findFirst().get())), level)).collect(Collectors.toSet())).size() == 1) {
                prediction.setExit((DeparturePrediction.TrainExitSide)((Object)((Object)exitSides.stream().findFirst().get())));
            }
            return prediction;
        }).toList();
        return preds;
    }

    public static Collection<TrainStop> getTrainStopsSorted(UUID trainId, Level level) {
        return TrainUtils.getTrainDeparturePredictions(trainId, level).stream().map(x -> new TrainStop(x.getNextStop(), (DeparturePrediction)x)).filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(x.getPrediction().getStationName())).sorted(Comparator.comparingInt(x -> x.getPrediction().getTicks())).toList();
    }

    public static List<SimpleTrainConnection> getConnectionsAt(String stationName, UUID currentTrainId, int ticksToNextStop) {
        TrainStationAlias alias = GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(stationName);
        SimpleTrainSchedule ownSchedule = SimpleTrainSchedule.of(TrainUtils.getTrainStopsSorted(currentTrainId, null));
        GlobalTrainDisplayData.refresh();
        ArrayList excludedSchedules = new ArrayList();
        HashMap scheduleByPrediction = new HashMap();
        HashMap simulatedScheduleByPrediction = new HashMap();
        return TrainUtils.Gott().entrySet().stream().filter(x -> alias.contains((String)x.getKey())).map(x -> (Collection)x.getValue()).flatMap(x -> x.parallelStream().map(y -> new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)y))).peek(x -> {
            SimpleTrainSchedule schedule = SimpleTrainSchedule.of(TrainUtils.getTrainStopsSorted(x.getTrain().id, null));
            scheduleByPrediction.put(x, schedule);
            simulatedScheduleByPrediction.put(x, schedule.simulate(x.getTrain(), ticksToNextStop, alias));
        }).sorted(Comparator.comparingInt(x -> ((SimulatedTrainSchedule)simulatedScheduleByPrediction.get(x)).getSimulationData().simulationCorrection())).filter(x -> {
            boolean b;
            SimpleTrainSchedule schedule = (SimpleTrainSchedule)scheduleByPrediction.get(x);
            SimulatedTrainSchedule directionalSchedule = (SimulatedTrainSchedule)simulatedScheduleByPrediction.get(x);
            if (excludedSchedules.stream().anyMatch(y -> y.exactEquals(directionalSchedule))) {
                return false;
            }
            boolean bl = b = !x.getTrain().id.equals(currentTrainId) && TrainUtils.isTrainValid(x.getTrain()) && !GlobalSettingsManager.getInstance().getSettingsData().isTrainBlacklisted(x.getTrain()) && !schedule.equals(ownSchedule);
            if (b) {
                excludedSchedules.add(directionalSchedule);
            }
            return b;
        }).map(x -> {
            SimulatedTrainSchedule sched = (SimulatedTrainSchedule)simulatedScheduleByPrediction.get(x);
            Optional<TrainStop> firstStop = sched.getFirstStopOf(x.getNextStop());
            return new SimpleTrainConnection(x.getTrain().name.getString(), x.getTrain().id, x.getTrain().icon.getId(), sched.getSimulationData().simulationTime() + sched.getSimulationData().simulationCorrection(), firstStop.isPresent() ? firstStop.get().getPrediction().getScheduleTitle() : x.getScheduleTitle(), firstStop.isPresent() ? firstStop.get().getStationAlias().getInfoForStation(firstStop.get().getPrediction().getStationName()) : x.getInfo());
        }).sorted(Comparator.comparingInt(x -> x.ticks())).toList();
    }

    public static boolean GottKnows(String station) {
        return TrainUtils.Gott().keySet().stream().anyMatch(x -> {
            String regex = x.isBlank() ? x : "\\Q" + x.replace("*", "\\E.*\\Q") + "\\E";
            return station.matches(regex);
        });
    }

    public static Collection<GlobalStation> getAllStations() {
        ArrayList<GlobalStation> stations = new ArrayList<GlobalStation>();
        TrainUtils.RAILWAY_MANAGER.trackNetworks.forEach((uuid, graph) -> {
            Collection foundStations = graph.getPoints(EdgePointType.STATION);
            stations.addAll(foundStations);
        });
        return stations;
    }

    public static Collection<TrackEdge> getAllEdges() {
        HashSet<TrackEdge> edges = new HashSet<TrackEdge>();
        TrainUtils.RAILWAY_MANAGER.trackNetworks.forEach((uuid, graph) -> edges.addAll(graph.getNodes().stream().map(x -> graph.locateNode(x)).flatMap(x -> graph.getConnectionsFrom(x).values().stream()).collect(Collectors.toSet())));
        return edges;
    }

    public static Map<UUID, Set<TrackEdge>> getAllEdgesMapped() {
        HashMap<UUID, Set<TrackEdge>> edges = new HashMap<UUID, Set<TrackEdge>>();
        TrainUtils.RAILWAY_MANAGER.trackNetworks.forEach((uuid, graph) -> edges.putAll(graph.getNodes().stream().map(x -> graph.locateNode(x)).flatMap(x -> graph.getConnectionsFrom(x).values().stream()).distinct().flatMap(edge -> edge.getEdgeData().getPoints().stream().map(point -> new AbstractMap.SimpleEntry<UUID, TrackEdge>(point.id, (TrackEdge)edge))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())))));
        return edges;
    }

    public static Optional<TrackEdge> getEdgeForStation(GlobalStation station) {
        return TrainUtils.getAllEdges().stream().filter(x -> x.getEdgeData().getPoints().stream().anyMatch(y -> y.equals(station))).findFirst();
    }

    public static NearestTrackStationResult getNearestTrackStation(Level level, Vec3i pos) {
        Optional<GlobalStation> station = TrainUtils.getAllStations().stream().filter(x -> TrainUtils.GottKnows(x.name) && x.getBlockEntityDimension().equals(level.m_46472_()) && !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(x.name)).min((a, b) -> Double.compare(a.getBlockEntityPos().m_123331_(pos), b.getBlockEntityPos().m_123331_(pos)));
        double distance = station.isPresent() ? station.get().getBlockEntityPos().m_123331_(pos) : 0.0;
        return new NearestTrackStationResult(station, distance);
    }

    public static double getStationAngle(GlobalStation station) {
        return TrainUtils.angleOn((TrackEdgePoint)station, TrainUtils.getEdgeForStation(station).get());
    }

    public static Direction getStationDirection(GlobalStation station) {
        return Direction.m_122364_((double)TrainUtils.getStationAngle(station));
    }

    public static double angleOn(TrackEdgePoint point, TrackEdge edge) {
        double basePos = point.isPrimary(edge.node1) ? edge.getLength() - point.position : point.position;
        Vec3 vec = edge.getDirectionAt(basePos);
        return point.isPrimary(edge.node1) ? MathUtils.getVectorAngle((Vec3)vec) : MathUtils.getVectorAngle((Vec3)vec.m_82548_());
    }

    public static DoorControlBehaviour getTrainStationDoorControl(GlobalStation station, Level level) {
        BlockPos stationPos = station.getBlockEntityPos();
        if (level == null || !level.m_46749_(stationPos)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(stationPos);
        if (blockEntity instanceof StationBlockEntity) {
            StationBlockEntity be = (StationBlockEntity)blockEntity;
            return be.doorControls;
        }
        return null;
    }

    public static DeparturePrediction.TrainExitSide getTrainStationExitDirection(GlobalStation station, Level level) {
        DoorControlBehaviour dcb = TrainUtils.getTrainStationDoorControl(station, level);
        if (dcb == null) {
            return DeparturePrediction.TrainExitSide.UNKNOWN;
        }
        Direction stationDirection = TrainUtils.getStationDirection(station);
        if (dcb.mode.matches(stationDirection.m_122427_())) {
            return DeparturePrediction.TrainExitSide.RIGHT;
        }
        if (dcb.mode.matches(stationDirection.m_122428_())) {
            return DeparturePrediction.TrainExitSide.LEFT;
        }
        return DeparturePrediction.TrainExitSide.UNKNOWN;
    }

    public static DeparturePrediction.TrainExitSide getTrainStationExit(GlobalStation station, Direction stationDirection, Level level) {
        DoorControlBehaviour dcb = TrainUtils.getTrainStationDoorControl(station, level);
        if (dcb == null) {
            return DeparturePrediction.TrainExitSide.UNKNOWN;
        }
        if (dcb.mode.matches(stationDirection.m_122427_())) {
            return DeparturePrediction.TrainExitSide.RIGHT;
        }
        if (dcb.mode.matches(stationDirection.m_122428_())) {
            return DeparturePrediction.TrainExitSide.LEFT;
        }
        return DeparturePrediction.TrainExitSide.UNKNOWN;
    }

    public static Collection<Train> getAllTrains() {
        return TrainUtils.RAILWAY_MANAGER.trains.values();
    }

    public static Train getTrain(UUID trainId) {
        return (Train)TrainUtils.RAILWAY_MANAGER.trains.get(trainId);
    }

    public static boolean isTrainValid(Train train) {
        return !train.derailed && !train.invalid && !train.runtime.paused && train.runtime.getSchedule() != null && train.graph != null;
    }

    public static boolean isTrainIdValid(UUID trainId) {
        return TrainUtils.isTrainValid(TrainUtils.getTrain(trainId));
    }
}

