/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class ModUtils {
    public static float clockHandDegrees(long time, int divisor) {
        return 360.0f / (float)divisor * (float)(time % (long)divisor);
    }

    public static double calcSpeed(double metersPerTick, ESpeedUnit unit) {
        return metersPerTick * 20.0 * unit.getFactor();
    }

    public static MutableComponent calcSpeedString(double metersPerTick, ESpeedUnit unit) {
        return TextUtils.text((String)((int)Math.abs(Math.round(ModUtils.calcSpeed(metersPerTick, unit))) + " " + unit.getUnit()));
    }

    public static String timeRemainingString(int ticks) {
        StringBuilder sb = new StringBuilder();
        String unpredictable = " ~ ";
        String whitespace = " ";
        if (ticks == -1 || ticks >= 11700) {
            sb.append(" ");
            sb.append(" ~ ");
        } else if (ticks < 200) {
            sb.append(Lang.translateDirect((String)"display_source.station_summary.now", (Object[])new Object[0]).getString());
        } else {
            int min = ticks / 1200;
            int sec = ticks / 20 % 60;
            if ((sec = Mth.m_14167_((float)((float)sec / 15.0f)) * 15) == 60) {
                ++min;
                sec = 0;
            }
            sb.append(min > 0 ? Components.literal((String)String.valueOf(min)).getString() : "");
            sb.append(min > 0 ? Lang.translateDirect((String)"display_source.station_summary.minutes", (Object[])new Object[0]).getString() : Lang.translateDirect((String)"display_source.station_summary.seconds", (Object[])new Object[]{sec}).getString());
        }
        return sb.toString();
    }

    public static <Key, Value> boolean areEqual(Set<Map.Entry<Key, Value>> set1, Set<Map.Entry<Key, Value>> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        for (Map.Entry<Key, Value> entry : set1) {
            if (set2.contains(entry)) continue;
            return false;
        }
        return true;
    }
}

