/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.network.packets.stc.RealtimeResponsePacket;
import de.mrjulsen.crn.util.TrainUtils;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class RealtimeRequestPacket
implements IPacketBase<RealtimeRequestPacket> {
    public long requestId;
    public Collection<UUID> ids;

    public RealtimeRequestPacket() {
    }

    public RealtimeRequestPacket(long requestId, Collection<UUID> ids) {
        this.requestId = requestId;
        this.ids = ids;
    }

    public void encode(RealtimeRequestPacket packet, FriendlyByteBuf buffer) {
        buffer.writeLong(packet.requestId);
        buffer.writeInt(packet.ids.size());
        for (UUID u : packet.ids) {
            buffer.m_130077_(u);
        }
    }

    public RealtimeRequestPacket decode(FriendlyByteBuf buffer) {
        long requestId = buffer.readLong();
        int count = buffer.readInt();
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < count; ++i) {
            uuids.add(buffer.m_130259_());
        }
        return new RealtimeRequestPacket(requestId, uuids);
    }

    public void handle(RealtimeRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Level level = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_();
            new Thread(() -> RealtimeRequestPacket.lambda$handle$4(level, packet, (Supplier)contextSupplier), "Realtime Provider").run();
        });
    }

    private static /* synthetic */ void lambda$handle$4(Level level, RealtimeRequestPacket packet, Supplier contextSupplier) {
        long updateTime = level.m_46468_();
        ArrayList<DeparturePrediction.SimpleDeparturePrediction> predictions = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>();
        packet.ids.forEach(arg_0 -> RealtimeRequestPacket.lambda$handle$3(predictions, (Supplier)contextSupplier, arg_0));
        CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new RealtimeResponsePacket(packet.requestId, predictions, updateTime));
    }

    private static /* synthetic */ void lambda$handle$3(Collection predictions, Supplier contextSupplier, UUID x) {
        if (!TrainUtils.isTrainIdValid(x)) {
            return;
        }
        predictions.addAll(TrainUtils.getTrainDeparturePredictions(x, ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_()).stream().map(a -> a.simplify()).filter(a -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(a.stationName())).sorted(Comparator.comparingInt(a -> a.departureTicks())).toList());
    }

    public record StationData(Collection<String> stationName, Collection<Integer> indices, UUID trainId) {
    }
}

