/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.data.EDisplayInfo;
import de.mrjulsen.crn.data.EDisplayType;
import de.mrjulsen.crn.data.ESide;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedDisplayUpdatePacket
implements IPacketBase<AdvancedDisplayUpdatePacket> {
    private BlockPos pos;
    private EDisplayType type;
    private EDisplayInfo info;
    private boolean doubleSided;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(Level level, BlockPos pos, EDisplayType type, EDisplayInfo info, boolean doubleSided) {
        this.pos = pos;
        this.info = info;
        this.type = type;
        this.doubleSided = doubleSided;
        this.apply(level, this);
    }

    protected AdvancedDisplayUpdatePacket(BlockPos pos, EDisplayType type, EDisplayInfo info, boolean doubleSided) {
        this.pos = pos;
        this.info = info;
        this.type = type;
        this.doubleSided = doubleSided;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.info.getId());
        buffer.writeInt(packet.type.getId());
        buffer.writeBoolean(packet.doubleSided);
    }

    public AdvancedDisplayUpdatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        EDisplayInfo info = EDisplayInfo.getTypeById(buffer.readInt());
        EDisplayType type = EDisplayType.getTypeById(buffer.readInt());
        boolean doubleSided = buffer.readBoolean();
        return new AdvancedDisplayUpdatePacket(pos, type, info, doubleSided);
    }

    private void apply(Level level, AdvancedDisplayUpdatePacket packet) {
        BlockEntity blockEntity;
        if (level.m_46749_(packet.pos) && (blockEntity = level.m_7702_(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity2.applyToAll(be -> {
                be.setDisplayType(packet.type);
                be.setInfoType(packet.info);
                if (level.m_8055_(be.m_58899_()).m_60734_() instanceof AbstractAdvancedSidedDisplayBlock) {
                    BlockState state = level.m_8055_(be.m_58899_());
                    state = (BlockState)state.m_61124_(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.m_46597_(be.m_58899_(), state);
                }
                be.notifyUpdate();
            });
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                Level level = player.m_9236_();
                this.apply(level, packet);
            }
        });
    }
}

