/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.SimpleTrainSchedule;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.util.TrainUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class GlobalTrainData {
    private final Collection<Train> trains;
    private final Map<String, Set<GlobalStation>> stationByName;
    private final Map<String, Collection<DeparturePrediction>> aliasPredictions = new HashMap<String, Collection<DeparturePrediction>>();
    private final Map<UUID, Collection<DeparturePrediction>> trainPredictions = new HashMap<UUID, Collection<DeparturePrediction>>();
    private final long updateTime;
    private static GlobalTrainData instance = null;

    private GlobalTrainData(long updateTime) {
        instance = this;
        this.trains = TrainUtils.getAllTrains();
        this.stationByName = TrainUtils.getAllStations().stream().collect(Collectors.groupingBy(x -> x.name, Collectors.toSet()));
        TrainUtils.getMappedDeparturePredictions(this.aliasPredictions, this.trainPredictions);
        this.updateTime = updateTime;
    }

    public static GlobalTrainData makeSnapshot(long updateTime) {
        return new GlobalTrainData(updateTime);
    }

    public static GlobalTrainData getInstance() {
        return instance;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public boolean stationHasDepartingTrains(TrainStationAlias alias) {
        return this.aliasPredictions.containsKey(alias.getAliasName().get());
    }

    public final Collection<Train> getAllTrains() {
        return this.trains;
    }

    public final Set<String> getAllStations() {
        return this.stationByName.keySet();
    }

    public final Set<GlobalStation> getStationData(String stationName) {
        return this.stationByName.get(stationName);
    }

    public Collection<DeparturePrediction> getPredictionsOfTrain(Train train) {
        return this.trainPredictions.get(train.id).stream().filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(x.getStationName())).toList();
    }

    public Collection<DeparturePrediction> getPredictionsOfTrainChronologically(Train train) {
        return this.getPredictionsOfTrain(train).parallelStream().sorted(Comparator.comparingInt(x -> x.getTicks())).toList();
    }

    public Optional<DeparturePrediction> getNextStop(Train train) {
        return this.getPredictionsOfTrainChronologically(train).stream().findFirst();
    }

    public boolean trainStopsAt(Train train, TrainStationAlias station) {
        return this.getPredictionsOfTrain(train).parallelStream().anyMatch(x -> x.getNextStop().equals(station));
    }

    public Collection<DeparturePrediction> getTrainStopDataAt(Train train, TrainStationAlias station) {
        Collection<DeparturePrediction> predictions = this.getPredictionsOfTrain(train);
        return predictions.parallelStream().filter(x -> x.getNextStop().equals(station)).toList();
    }

    public Collection<DeparturePrediction> getSortedTrainStopDataAt(Train train, TrainStationAlias station) {
        return this.getTrainStopDataAt(train, station).parallelStream().sorted(Comparator.comparingInt(x -> x.getTicks())).toList();
    }

    public Optional<DeparturePrediction> getNextTrainStopDataAt(Train train, TrainStationAlias station) {
        return this.getTrainStopDataAt(train, station).stream().findFirst();
    }

    public Collection<TrainStop> getAllStops(Train train) {
        return this.getPredictionsOfTrain(train).parallelStream().map(x -> new TrainStop(x.getNextStop(), (DeparturePrediction)x)).toList();
    }

    public List<TrainStop> getAllStopsSorted(Train train) {
        return this.getAllStops(train).parallelStream().sorted(Comparator.comparingInt(x -> x.getPrediction().getTicks())).toList();
    }

    public SimpleTrainSchedule getTrainSimpleSchedule(Train train) {
        return new SimpleTrainSchedule(train);
    }

    public List<TrainStop> getAllStopoversOfTrainSortedNew(Train train, TrainStationAlias start, TrainStationAlias end, boolean includeStartEnd, boolean correctStart) {
        Collection<TrainStop> stops = this.getAllStopsFrom(train, start, false, true).getAllStops();
        if (stops.parallelStream().noneMatch(x -> x.isStationAlias(start) || x.isStationAlias(end))) {
            return new ArrayList<TrainStop>();
        }
        DeparturePrediction startPrediction = null;
        DeparturePrediction endPrediction = null;
        int ticksStart = -1;
        int ticksStop = -1;
        Collection<DeparturePrediction> startStopDatas = this.getSortedTrainStopDataAt(train, start);
        Collection<DeparturePrediction> endStopDatas = this.getSortedTrainStopDataAt(train, end);
        Optional<DeparturePrediction> firstStartData = startStopDatas.stream().findFirst();
        if (firstStartData.isPresent()) {
            ticksStart = firstStartData.get().getTicks();
        }
        int ftmpTicksStart = ticksStart;
        if (endStopDatas != null && endStopDatas.size() > 0) {
            Optional<DeparturePrediction> endStopData = endStopDatas.stream().filter(x -> x.getTicks() >= ftmpTicksStart).findFirst();
            if (endStopData.isPresent()) {
                endPrediction = endStopData.get();
                ticksStop = endPrediction.getTicks();
            } else {
                endStopData = endStopDatas.stream().findFirst();
                if (endStopData.isPresent()) {
                    endPrediction = endStopData.get();
                    ticksStop = endPrediction.getTicks();
                }
            }
        }
        int fTicksStop = ticksStop;
        if (startStopDatas != null && startStopDatas.size() > 0) {
            DeparturePrediction startStopData;
            DeparturePrediction departurePrediction = startStopData = correctStart ? (DeparturePrediction)startStopDatas.stream().filter(x -> x.getTicks() <= fTicksStop).reduce((a, b) -> b).orElse(null) : startPrediction;
            if (startStopData != null) {
                startPrediction = startStopData;
                ticksStart = startPrediction.getTicks();
            } else {
                startStopData = startStopDatas.stream().reduce((a, b) -> b).orElse(null);
                if (startStopData != null) {
                    startPrediction = startStopData;
                    ticksStart = startPrediction.getTicks();
                }
            }
        }
        if (correctStart) {
            // empty if block
        }
        int fTicksStart = ticksStart;
        ArrayList<TrainStop> filteredStops = new ArrayList<TrainStop>();
        if (fTicksStart <= fTicksStop) {
            filteredStops.addAll(stops.stream().filter(x -> x.getPrediction().getTicks() > fTicksStart && x.getPrediction().getTicks() < fTicksStop).toList());
        } else {
            filteredStops.addAll(stops.stream().filter(x -> x.getPrediction().getTicks() < fTicksStop || x.getPrediction().getTicks() > fTicksStart).map(x -> {
                if (x.getPrediction().getTicks() < fTicksStop) {
                    return new TrainStop(x.getStationAlias(), DeparturePrediction.withNextCycleTicks(x.getPrediction()));
                }
                return x;
            }).toList());
        }
        if (includeStartEnd) {
            filteredStops.add(new TrainStop(end, fTicksStop < fTicksStart ? DeparturePrediction.withNextCycleTicks(endPrediction) : endPrediction));
            filteredStops.add(0, new TrainStop(start, startPrediction));
        }
        return filteredStops;
    }

    public SimpleTrainSchedule getAllStopsFrom(Train train, TrainStationAlias alias, boolean preventDuplicates, boolean loop) {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        int idx = 0;
        for (TrainStop stop : this.getAllStopsSorted(train)) {
            if (preventDuplicates && newList.contains(stop)) {
                if (!loop) break;
                continue;
            }
            if (stop.getStationAlias().equals(alias)) {
                idx = 0;
            }
            newList.add(idx, stop);
            ++idx;
        }
        return SimpleTrainSchedule.of(newList);
    }

    public SimpleTrainSchedule getDirectionalSchedule(Train train) {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        boolean isRepeating = false;
        for (TrainStop stop : this.getAllStopsSorted(train)) {
            if (newList.contains(stop)) {
                isRepeating = true;
                continue;
            }
            if (isRepeating) {
                newList.add(0, stop);
                continue;
            }
            newList.add(stop);
        }
        return SimpleTrainSchedule.of(newList);
    }

    public Collection<DeparturePrediction> getDepartingTrainsAt(TrainStationAlias station) {
        return ((Collection)this.aliasPredictions.getOrDefault(station.getAliasName().get(), Collections.emptyList())).parallelStream().sorted(Comparator.comparingInt(x -> x.getTicks())).toList();
    }

    public Optional<DeparturePrediction> getNextDepartingTrainAt(TrainStationAlias station) {
        Collection<DeparturePrediction> predictions = this.getDepartingTrainsAt(station);
        if (predictions == null || predictions.isEmpty()) {
            return Optional.empty();
        }
        return predictions.stream().findFirst();
    }
}

