/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.TrackStationsRequestPacket;
import java.util.ArrayList;
import java.util.Collection;

public class ClientTrainStationSnapshot {
    private static ClientTrainStationSnapshot instance;
    private final Collection<String> stationNames;
    private final Collection<String> trainNames;
    private final int listeningTrainCount;
    private final int totalTrainCount;

    private ClientTrainStationSnapshot(Collection<String> stationNames, Collection<String> trainNames, int listeningTrainCount, int totalTrainCount) {
        this.stationNames = stationNames;
        this.trainNames = trainNames;
        this.listeningTrainCount = listeningTrainCount;
        this.totalTrainCount = totalTrainCount;
    }

    public static ClientTrainStationSnapshot makeNew(Collection<String> stationNames, Collection<String> trainNames, int listeningTrainCount, int totalTrainCount) {
        instance = new ClientTrainStationSnapshot(stationNames, trainNames, listeningTrainCount, totalTrainCount);
        return instance;
    }

    public static ClientTrainStationSnapshot getInstance() {
        if (instance == null) {
            ClientTrainStationSnapshot.makeNew(new ArrayList<String>(), new ArrayList<String>(), 0, 0);
        }
        return instance;
    }

    public Collection<String> getAllTrainStations() {
        return this.stationNames;
    }

    public Collection<String> getAllTrainNames() {
        return this.trainNames;
    }

    public static void syncToClient(Runnable then) {
        long id = InstanceManager.registerClientResponseReceievedAction(then);
        CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new TrackStationsRequestPacket(id));
    }

    public int getListeningTrainCount() {
        return this.listeningTrainCount;
    }

    public int getTrainCount() {
        return this.totalTrainCount;
    }

    public int getStationCount() {
        return this.stationNames.size();
    }

    public void dispose() {
        instance = null;
    }
}

