/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.core.navigation;

import de.mrjulsen.crn.core.navigation.Edge;
import de.mrjulsen.crn.data.TrainStationAlias;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Node
implements Comparable<Node> {
    private TrainStationAlias name;
    private final UUID id;
    private final Set<UUID> trainIds = new HashSet<UUID>();
    private long cost = Long.MAX_VALUE;
    private Node previousNode = null;
    private Edge previousEdge = null;
    private boolean isTransferPoint = false;

    public Node(TrainStationAlias alias, UUID id) {
        this.id = id;
        this.name = alias;
    }

    public UUID getId() {
        return this.id;
    }

    public Set<UUID> getTrainIds() {
        return this.trainIds;
    }

    public void addTrain(UUID id) {
        this.trainIds.add(id);
    }

    public TrainStationAlias getStationAlias() {
        return this.name;
    }

    public void init() {
        this.cost = Long.MAX_VALUE;
        this.previousNode = null;
        this.previousEdge = null;
        this.isTransferPoint = false;
    }

    public long getCost() {
        return this.cost;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    public Node getPreviousNode() {
        return this.previousNode;
    }

    public Edge getPreviousEdge() {
        return this.previousEdge;
    }

    public boolean isTransferPoint() {
        return this.isTransferPoint;
    }

    public void setPrevious(Node node, Edge viaEdge) {
        this.previousNode = node;
        this.previousEdge = viaEdge;
    }

    public void setIsTransferPoint(boolean b) {
        this.isTransferPoint = b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            Node other = (Node)obj;
            return this.getStationAlias().equals(other.getStationAlias());
        }
        return false;
    }

    public String toString() {
        return String.format("%s (%s) %s", this.getStationAlias(), this.getId(), this.isTransferPoint() ? "(Transfer)" : "");
    }

    public int hashCode() {
        return 37 + Objects.hash(this.getStationAlias());
    }

    @Override
    public int compareTo(Node o) {
        return Long.compare(this.getCost(), o.getCost());
    }
}

