/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.core.navigation;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.core.navigation.Edge;
import de.mrjulsen.crn.core.navigation.Node;
import de.mrjulsen.crn.core.navigation.TrainSchedule;
import de.mrjulsen.crn.data.GlobalSettings;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.GlobalTrainData;
import de.mrjulsen.crn.data.Route;
import de.mrjulsen.crn.data.RoutePart;
import de.mrjulsen.crn.data.SimpleTrainSchedule;
import de.mrjulsen.crn.data.SimulatedTrainSchedule;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.event.listeners.TrainListener;
import de.mrjulsen.crn.util.TrainUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.level.Level;

public class Graph {
    protected static final int MIN_START_TIME = 200;
    private Map<UUID, Node> nodesById;
    private Map<TrainStationAlias, Node> nodesByStation;
    private Map<UUID, Edge> edgesById;
    private Map<Node, Map<Node, Set<Edge>>> edgesByNode;
    private Map<UUID, TrainSchedule> schedulesById;
    private Map<UUID, TrainSchedule> schedulesByTrainId;
    private Map<TrainSchedule, Set<UUID>> trainIdsBySchedule;
    private Map<UUID, UUID> scheduleIdByTrainId;
    private final GlobalSettings globalSettings;
    private final UserSettings settings;
    private final long lastUpdated;
    private final Level level;

    public Graph(Level level, UserSettings settings) {
        long startTime = System.currentTimeMillis();
        this.lastUpdated = level.m_46468_();
        this.settings = settings;
        this.level = level;
        GlobalTrainData.makeSnapshot(this.lastUpdated);
        this.nodesById = new HashMap<UUID, Node>();
        this.nodesByStation = new HashMap<TrainStationAlias, Node>();
        this.edgesById = new HashMap<UUID, Edge>();
        this.edgesByNode = new HashMap<Node, Map<Node, Set<Edge>>>();
        this.schedulesById = new HashMap<UUID, TrainSchedule>();
        this.schedulesByTrainId = new HashMap<UUID, TrainSchedule>();
        this.trainIdsBySchedule = new HashMap<TrainSchedule, Set<UUID>>();
        this.scheduleIdByTrainId = new HashMap<UUID, UUID>();
        int[] trainCounter = new int[]{0};
        this.globalSettings = GlobalSettingsManager.getInstance().getSettingsData();
        TrainUtils.getAllTrains().stream().filter(x -> TrainUtils.isTrainValid(x) && !this.globalSettings.isTrainBlacklisted((Train)x) && !settings.isTrainExcluded((Train)x, this.globalSettings)).forEach(x -> {
            this.addTrain((Train)x, this.globalSettings);
            trainCounter[0] = trainCounter[0] + 1;
        });
        long estimatedTime = System.currentTimeMillis() - startTime;
        CreateRailwaysNavigator.LOGGER.info(String.format("Graph generated. Took %sms. Contains %s nodes, %s edges and %s schedules. %s train processed.", estimatedTime, this.nodesById.size(), this.edgesById.size(), this.schedulesById.size(), trainCounter.length));
    }

    public UserSettings getSettings() {
        return this.settings;
    }

    protected Node addNode(TrainStationAlias alias, Train train) {
        if (this.nodesByStation.containsKey(alias)) {
            Node node = this.nodesByStation.get(alias);
            node.addTrain(train.id);
            return node;
        }
        UUID id = UUID.randomUUID();
        while (this.nodesById.containsKey(id)) {
            id = UUID.randomUUID();
        }
        Node node = new Node(alias, id);
        node.addTrain(train.id);
        this.nodesById.put(id, node);
        this.nodesByStation.put(alias, node);
        return node;
    }

    protected Edge addEdge(Node node1, Node node2, UUID scheduleId) {
        UUID id = UUID.randomUUID();
        while (this.edgesById.containsKey(id)) {
            id = UUID.randomUUID();
        }
        Edge edge = new Edge(node1, node2, id, scheduleId);
        if (this.putConnection(node1, node2, edge)) {
            this.edgesById.put(id, edge);
        }
        return edge;
    }

    protected TrainSchedule addTrain(Train train, GlobalSettings settingsInstance) {
        if (this.schedulesByTrainId.containsKey(train.id)) {
            return this.schedulesByTrainId.get(train.id);
        }
        UUID id = UUID.randomUUID();
        while (this.edgesById.containsKey(id)) {
            id = UUID.randomUUID();
        }
        TrainSchedule schedule = new TrainSchedule(train, id, settingsInstance);
        if (!schedule.addToGraph(this, train)) {
            return null;
        }
        if (this.trainIdsBySchedule.containsKey(schedule)) {
            TrainSchedule sched = this.schedulesByTrainId.get(this.trainIdsBySchedule.get(schedule).stream().findFirst().get());
            this.trainIdsBySchedule.get(schedule).add(train.id);
            this.schedulesByTrainId.put(train.id, sched);
            this.scheduleIdByTrainId.put(train.id, sched.getId());
            sched.getEdges().forEach(x -> {
                Optional<Edge> matchingEdge = schedule.getEdges().stream().filter(a -> a.equals(x)).findFirst();
                if (matchingEdge.isPresent()) {
                    x.withCost(matchingEdge.get().getCost(), false);
                }
            });
            return sched;
        }
        this.schedulesById.put(id, schedule);
        this.schedulesByTrainId.put(train.id, schedule);
        this.trainIdsBySchedule.put(schedule, new HashSet<UUID>(Set.of(train.id)));
        this.scheduleIdByTrainId.put(train.id, schedule.getId());
        return schedule;
    }

    public boolean putConnection(Node node1, Node node2, Edge edge) {
        Map connections = this.edgesByNode.computeIfAbsent(node1, n -> new IdentityHashMap());
        if (connections.containsKey(node2)) {
            if (((Set)connections.get(node2)).contains(edge)) {
                return false;
            }
            return ((Set)connections.get(node2)).add(edge);
        }
        return connections.put(node2, new HashSet<Edge>(Set.of(edge))) == null;
    }

    public Set<Node> getNodes() {
        return new HashSet<Node>(this.nodesById.values());
    }

    public Node getNode(TrainStationAlias alias) {
        return this.nodesByStation.get(alias);
    }

    public Node getNode(UUID id) {
        return this.nodesById.get(id);
    }

    public Map<Node, Set<Edge>> getEdges(Node node) {
        return this.edgesByNode.get(node);
    }

    public Set<Edge> getEdges() {
        return new HashSet<Edge>(this.edgesById.values());
    }

    public Edge getEdge(UUID id) {
        return this.edgesById.get(id);
    }

    public Map<Node, Set<Edge>> getConnectionsFrom(Node node) {
        if (node == null) {
            return null;
        }
        return this.edgesByNode.getOrDefault(node, new HashMap());
    }

    public Collection<Route> navigate(TrainStationAlias start, TrainStationAlias end, boolean avoidTransfers) {
        return this.searchTrains(this.searchRoute(start, end, avoidTransfers)).stream().filter(x -> !x.isEmpty()).sorted(Comparator.comparingInt(x -> x.getStartStation().getPrediction().getTicks())).toList();
    }

    public List<Node> searchRoute(TrainStationAlias start, TrainStationAlias end, boolean avoidTransfers) {
        if (!this.nodesByStation.containsKey(start) || !this.nodesByStation.containsKey(end)) {
            return List.of();
        }
        Map<TrainStationAlias, Node> nodes = this.dijkstra(start, avoidTransfers);
        Node endNode = nodes.get(end);
        if (endNode == null) {
            return List.of();
        }
        endNode.setIsTransferPoint(true);
        ArrayList<Node> route = new ArrayList<Node>();
        Node currentNode = endNode;
        while (!currentNode.getStationAlias().equals(start)) {
            route.add(0, currentNode);
            if (currentNode.getPreviousEdge() != null) {
                if (currentNode.getPreviousNode().getPreviousEdge() == null) {
                    currentNode.getPreviousNode().setIsTransferPoint(false);
                } else {
                    currentNode.getPreviousNode().setIsTransferPoint(!currentNode.getPreviousEdge().getScheduleId().equals(currentNode.getPreviousNode().getPreviousEdge().getScheduleId()));
                }
            }
            currentNode = currentNode.getPreviousNode();
        }
        currentNode.getPreviousNode().setIsTransferPoint(true);
        route.add(0, currentNode.getPreviousNode());
        return route;
    }

    private Map<UUID, SimpleTrainSchedule> generateTrainSchedules() {
        return GlobalTrainData.getInstance().getAllTrains().stream().filter(x -> TrainUtils.isTrainValid(x) && !this.globalSettings.isTrainBlacklisted((Train)x) && !this.settings.isTrainExcluded((Train)x, this.globalSettings)).collect(Collectors.toMap(x -> x.id, x -> new SimpleTrainSchedule((Train)x)));
    }

    public Collection<Route> searchTrains(List<Node> routeNodes) {
        Map<UUID, SimpleTrainSchedule> schedulesByTrain = this.generateTrainSchedules();
        ArrayList<Route> routes = new ArrayList<Route>();
        routes.add(new Route(this.lastUpdated));
        int timer = 200;
        Node[] filteredTransferNodes = (Node[])routeNodes.stream().filter(x -> x.isTransferPoint()).toArray(Node[]::new);
        if (filteredTransferNodes.length < 2) {
            return routes;
        }
        Node lastTransfer = filteredTransferNodes[0];
        HashMap lastTransferByTrain = new HashMap();
        Node lastNode = lastTransfer;
        int simulationTime = timer;
        List<SimulatedTrainSchedule> trainPredictions = GlobalTrainData.getInstance().getDepartingTrainsAt(lastNode.getStationAlias()).stream().filter(x -> {
            if (this.globalSettings.isTrainBlacklisted(x.getTrain()) || this.settings.isTrainExcluded(x.getTrain(), this.globalSettings)) {
                return false;
            }
            SimpleTrainSchedule schedule = (SimpleTrainSchedule)schedulesByTrain.get(x.getTrain().id);
            int i = filteredTransferNodes.length - 1;
            while (i > 0) {
                Node nde = filteredTransferNodes[i];
                int j = i--;
                if (!nde.getTrainIds().contains(x.getTrain().id)) continue;
                lastTransferByTrain.put(x.getTrain().id, j);
                break;
            }
            boolean b = lastTransferByTrain.containsKey(x.getTrain().id) && schedule.hasStationAlias(filteredTransferNodes[(Integer)lastTransferByTrain.get(x.getTrain().id)].getStationAlias()) && TrainUtils.isTrainValid(x.getTrain());
            return b;
        }).map(x -> {
            int t = x.getTicks() + TrainListener.getInstance().getDepartmentTime(this.level, x.getTrain());
            return ((SimpleTrainSchedule)schedulesByTrain.get(x.getTrain().id)).simulate(x.getTrain(), t > simulationTime ? 0 : simulationTime, lastNode.getStationAlias());
        }).sorted(Comparator.comparingInt(x -> x.getSimulationData().simulationCorrection())).toList();
        SimulatedTrainSchedule selectedPrediction = trainPredictions.stream().filter(x -> x.isInDirection(lastNode.getStationAlias(), filteredTransferNodes[(Integer)lastTransferByTrain.get(x.getSimulationData().train().id)].getStationAlias())).findFirst().orElse(trainPredictions.stream().findFirst().orElse(null));
        if (selectedPrediction == null) {
            CreateRailwaysNavigator.LOGGER.warn("Unable to find route from " + lastNode.getStationAlias().getAliasName());
            return routes;
        }
        Collection<SimulatedTrainSchedule> filteredSchedules = trainPredictions.stream().collect(Collectors.toMap(x -> x.getSimulationData().train().id, x -> x, (o, n) -> {
            if (n.isInDirection(lastNode.getStationAlias(), filteredTransferNodes[(Integer)lastTransferByTrain.get(o.getSimulationData().train().id)].getStationAlias())) {
                return n;
            }
            if (o.isInDirection(lastNode.getStationAlias(), filteredTransferNodes[(Integer)lastTransferByTrain.get(o.getSimulationData().train().id)].getStationAlias())) {
                return o;
            }
            return o.getSimulationData().simulationCorrection() < n.getSimulationData().simulationCorrection() ? o : n;
        })).values();
        if (filteredSchedules.isEmpty()) {
            filteredSchedules = List.of(selectedPrediction);
        }
        for (SimulatedTrainSchedule sched : filteredSchedules) {
            Route r = new Route(this.lastUpdated);
            int t = sched.getFirstStopOf(lastNode.getStationAlias()).get().getPrediction().getTicks() + TrainListener.getInstance().getDepartmentTime(this.level, sched.getSimulationData().train());
            RoutePart part = new RoutePart(this.level, sched.getSimulationData().train(), lastNode.getStationAlias(), filteredTransferNodes[(Integer)lastTransferByTrain.get(sched.getSimulationData().train().id)].getStationAlias(), t > simulationTime ? 0 : simulationTime);
            r.addPart(part);
            timer = part.getEndStation().getPrediction().getTicks() + this.settings.getTransferTime();
            HashSet<SimpleTrainSchedule> excludedSchedules = new HashSet<SimpleTrainSchedule>();
            excludedSchedules.add(schedulesByTrain.get(part.getTrain().id));
            Collection<RoutePart> parts = this.searchTrainsInternal(schedulesByTrain, new HashSet<SimpleTrainSchedule>(excludedSchedules), filteredTransferNodes, (Integer)lastTransferByTrain.get(sched.getSimulationData().train().id) + 1, timer, filteredTransferNodes[(Integer)lastTransferByTrain.get(sched.getSimulationData().train().id)]);
            parts.forEach(x -> r.addPart((RoutePart)x));
            routes.add(r);
        }
        return routes;
    }

    public Collection<RoutePart> searchTrainsInternal(Map<UUID, SimpleTrainSchedule> schedulesByTrain, Set<SimpleTrainSchedule> excludedSchedules, Node[] filteredTransferNodes, int startIdx, int timer, Node lastTransfer) {
        ArrayList<RoutePart> routes = new ArrayList<RoutePart>();
        int len = filteredTransferNodes.length;
        for (int i = startIdx; i < len; ++i) {
            Node node = filteredTransferNodes[i];
            if (lastTransfer != null) {
                Node lastNode = lastTransfer;
                int simulationTime = timer;
                List<SimulatedTrainSchedule> trainPredictions = GlobalTrainData.getInstance().getDepartingTrainsAt(lastNode.getStationAlias()).stream().filter(x -> {
                    if (this.globalSettings.isTrainBlacklisted(x.getTrain()) || this.settings.isTrainExcluded(x.getTrain(), this.globalSettings)) {
                        return false;
                    }
                    SimpleTrainSchedule schedule = (SimpleTrainSchedule)schedulesByTrain.get(x.getTrain().id);
                    boolean b = !excludedSchedules.contains(schedule) && schedule.hasStationAlias(node.getStationAlias()) && TrainUtils.isTrainValid(x.getTrain());
                    return b;
                }).map(x -> ((SimpleTrainSchedule)schedulesByTrain.get(x.getTrain().id)).simulate(x.getTrain(), simulationTime, lastNode.getStationAlias())).sorted(Comparator.comparingInt(x -> x.getSimulationData().simulationCorrection())).toList();
                SimulatedTrainSchedule selectedPrediction = trainPredictions.stream().filter(x -> x.isInDirection(lastNode.getStationAlias(), node.getStationAlias())).findFirst().orElse(trainPredictions.stream().findFirst().orElse(null));
                if (selectedPrediction == null) {
                    CreateRailwaysNavigator.LOGGER.warn("Route aborted! No train was found at " + lastNode.getStationAlias().getAliasName());
                    return routes;
                }
                RoutePart part = new RoutePart(this.level, selectedPrediction.getSimulationData().train(), lastNode.getStationAlias(), node.getStationAlias(), simulationTime);
                routes.add(part);
                timer = part.getEndStation().getPrediction().getTicks() + this.settings.getTransferTime();
                excludedSchedules.add(schedulesByTrain.get(part.getTrain().id));
            }
            lastTransfer = node;
        }
        return routes;
    }

    protected Map<TrainStationAlias, Node> dijkstra(TrainStationAlias start, boolean avoidTransfers) {
        this.nodesById.values().forEach(x -> x.init());
        Node startNode = this.nodesByStation.get(start);
        startNode.setCost(0L);
        startNode.setPrevious(startNode, null);
        startNode.setIsTransferPoint(true);
        PriorityQueue<Node> queue = new PriorityQueue<Node>();
        HashMap<TrainStationAlias, Node> excludedNodes = new HashMap<TrainStationAlias, Node>();
        queue.add(startNode);
        while (!queue.isEmpty()) {
            Node currentNode = (Node)queue.poll();
            Map<Node, Set<Edge>> reachableNodes = this.edgesByNode.get(currentNode);
            reachableNodes.entrySet().stream().filter(x -> !excludedNodes.containsKey(((Node)x.getKey()).getStationAlias())).forEach(y -> {
                Node node = (Node)y.getKey();
                ((Set)y.getValue()).forEach(x -> {
                    Edge edge = x;
                    boolean isTransfer = currentNode.getPreviousEdge() != null && !currentNode.getPreviousEdge().getScheduleId().equals(edge.getScheduleId());
                    TrainSchedule sched = this.schedulesById.get(edge.getScheduleId());
                    int avgTransferTime = (int)this.trainIdsBySchedule.get(sched).stream().mapToInt(a -> TrainListener.getInstance().getApproximatedTrainDuration((UUID)a)).average().getAsDouble();
                    long newCost = currentNode.getCost() + (long)edge.getCost() + (long)(isTransfer && avoidTransfers ? avgTransferTime + 1000 : 0);
                    if (newCost > node.getCost()) {
                        return;
                    }
                    node.setCost(newCost);
                    node.setPrevious(currentNode, edge);
                    queue.add(node);
                });
            });
            excludedNodes.put(currentNode.getStationAlias(), currentNode);
        }
        return excludedNodes;
    }
}

