/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.NavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.RouteDetailsScreen;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;

public class RouteEntryOverviewWidget
extends DLButton {
    public static final int WIDTH = 200;
    public static final int HEIGHT = 54;
    private static final int DISPLAY_WIDTH = 190;
    private final SimpleRoute route;
    private final NavigatorScreen parent;
    private final Level level;
    private final long lastRefreshedTime;
    private final MutableComponent transferText = ELanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.transfer");
    private final MutableComponent connectionInPast = ELanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final MutableComponent trainCanceled = ELanguage.translate("gui.createrailwaysnavigator.route_overview.stop_canceled");

    public RouteEntryOverviewWidget(NavigatorScreen parent, Level level, long lastRefreshedTime, int pX, int pY, SimpleRoute route, Consumer<RouteEntryOverviewWidget> onClick) {
        super(pX, pY, 200, 54, (Component)TextUtils.text((String)route.getName()), onClick);
        this.route = route;
        this.parent = parent;
        this.level = level;
        this.lastRefreshedTime = lastRefreshedTime;
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        super.m_5716_(pMouseX, pMouseY);
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91152_((Screen)new RouteDetailsScreen((Screen)this.parent, this.level, this.route, this.route.getListenerId()));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i;
        float scale = 0.75f;
        float l = this.m_5953_(pMouseX, pMouseY) ? 0.1f : 0.0f;
        boolean isActive = JourneyListenerManager.getInstance().get(this.route.getListenerId(), null) != null;
        boolean beforeJourney = isActive && JourneyListenerManager.getInstance().get(this.route.getListenerId(), null).getCurrentState() == JourneyListener.State.BEFORE_JOURNEY;
        int color = ColorUtils.lightenColor((int)CreateDynamicWidgets.ColorShade.DARK.getColor(), (float)l);
        if (!beforeJourney) {
            color = ColorUtils.applyTint((int)color, (int)0x663300);
        }
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.f_93620_, this.f_93621_, 200, 54, color);
        CreateDynamicWidgets.renderHorizontalSeparator(graphics, this.f_93620_ + 6, this.f_93621_ + 22, 188);
        Minecraft minecraft = Minecraft.m_91087_();
        SimpleRoute.SimpleRoutePart[] parts = (SimpleRoute.SimpleRoutePart[])this.route.getParts().toArray(SimpleRoute.SimpleRoutePart[]::new);
        NoShadowFontWrapper shadowlessFont = new NoShadowFontWrapper(minecraft.f_91062_);
        String timeStart = TimeUtils.parseTime((long)((int)((this.lastRefreshedTime + 6000L) % 24000L) + this.route.getStartStation().getTicks()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String timeEnd = TimeUtils.parseTime((long)((int)((this.lastRefreshedTime + 6000L) % 24000L) + this.route.getEndStation().getTicks()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String dash = " - ";
        MutableComponent line = TextUtils.text((String)String.format("%s%s%s | %s %s | %s", timeStart, dash, timeEnd, this.route.getTransferCount(), this.transferText.getString(), TimeUtils.parseDurationShort((int)this.route.getTotalDuration())));
        if (!this.route.isValid()) {
            line = line.m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        float localScale = shadowlessFont.m_92852_((FormattedText)line) > 188 ? 0.75f : 1.0f;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(localScale, 1.0f, 1.0f);
        GuiUtils.drawString((Graphics)graphics, (Font)minecraft.f_91062_, (int)((int)((float)(this.f_93620_ + 6) / localScale)), (int)(this.f_93621_ + 5), (FormattedText)line, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
        int routePartWidth = 190 / parts.length;
        String end = this.route.getEndStation().getStationName();
        int textW = shadowlessFont.m_92895_(end);
        for (i = 0; i < parts.length; ++i) {
            GuiUtils.fill((Graphics)graphics, (int)(this.f_93620_ + 5 + i * routePartWidth + 1), (int)(this.f_93621_ + 27), (int)(routePartWidth - 2), (int)11, (int)-13027015);
        }
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        if (this.route.getStartStation().shouldRenderRealtime()) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)(((float)(this.f_93620_ + 6) + (float)shadowlessFont.m_92895_(timeStart) * localScale / 2.0f) / 0.75f) - shadowlessFont.m_92895_(timeStart) / 2), (int)((int)((float)(this.f_93621_ + 15) / 0.75f)), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)(this.route.getStartStation().getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getStartStation().isDelayed() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (this.route.getEndStation().shouldRenderRealtime()) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)(((float)(this.f_93620_ + 6) + (float)shadowlessFont.m_92895_(timeEnd) * localScale * 1.5f + (float)shadowlessFont.m_92895_(dash) * localScale) / 0.75f) - shadowlessFont.m_92895_(timeEnd) / 2), (int)((int)((float)(this.f_93621_ + 15) / 0.75f)), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)(this.route.getEndStation().getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getEndStation().isDelayed() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (!this.route.isValid()) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.f_93620_ + 200 - 5) / 0.75f) - shadowlessFont.m_92852_((FormattedText)this.trainCanceled)), (int)((int)((float)(this.f_93621_ + 15) / 0.75f)), (FormattedText)this.trainCanceled, (int)0xFF4242, (EAlignment)EAlignment.LEFT, (boolean)false);
        } else if (!beforeJourney) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.f_93620_ + 200 - 5) / 0.75f) - shadowlessFont.m_92852_((FormattedText)this.connectionInPast)), (int)((int)((float)(this.f_93621_ + 15) / 0.75f)), (FormattedText)this.connectionInPast, (int)0xFF4242, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        for (i = 0; i < parts.length; ++i) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.f_93620_ + 5 + i * routePartWidth + routePartWidth / 2) / 0.75f)), (int)((int)((float)(this.f_93621_ + 30) / 0.75f)), (FormattedText)TextUtils.text((String)parts[i].getTrainName()), (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.f_93620_ + 6) / 0.75f)), (int)((int)((float)(this.f_93621_ + 43) / 0.75f)), (FormattedText)TextUtils.text((String)this.route.getStartStation().getStationName()), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.f_93620_ + 200 - 6) / 0.75f) - textW), (int)((int)((float)(this.f_93621_ + 43) / 0.75f)), (FormattedText)TextUtils.text((String)end), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
    }
}

