/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import de.mrjulsen.crn.client.gui.screen.AbstractEntryListSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.TrainGroupEntryWidget;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class TrainGroupScreen
extends AbstractEntryListSettingsScreen<TrainGroup, TrainGroupEntryWidget> {
    public TrainGroupScreen(Level level, Screen lastScreen) {
        super(level, lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.train_group_settings.title"));
    }

    protected TrainGroup[] getData(String searchText) {
        return (TrainGroup[])GlobalSettingsManager.getInstance().getSettingsData().getTrainGroupsList().stream().filter(x -> x.getGroupName().toLowerCase().contains(searchText.toLowerCase())).toArray(TrainGroup[]::new);
    }

    @Override
    protected TrainGroupEntryWidget createWidget(AbstractEntryListSettingsScreen.WidgetCreationData<TrainGroup, AbstractEntryListSettingsScreen<TrainGroup, TrainGroupEntryWidget>> widgetData, TrainGroup data) {
        List<String> expandedAliasNames = widgetData.previousEntries().stream().filter(x -> {
            TrainGroupEntryWidget w;
            return x instanceof TrainGroupEntryWidget && (w = (TrainGroupEntryWidget)x).isExpanded();
        }).map(x -> ((TrainGroupEntryWidget)x).getTrainGroup().getGroupName()).toList();
        return new TrainGroupEntryWidget(widgetData.parent(), widgetData.x(), widgetData.y(), data, () -> this.refreshEntries(), expandedAliasNames.contains(data.getGroupName()));
    }

    @Override
    protected void onCreateNewEntry(String value, Runnable refreshAction) {
        GlobalSettingsManager.getInstance().getSettingsData().registerTrainGroup(new TrainGroup(value), refreshAction);
    }
}

